/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

inline hkgShaderEffect* hkgShaderEffect::defaultCreateInternal()
{
	return new hkgShaderEffect();
}

inline void hkgShaderEffect::setName(const char* n )
{
	m_name = n;
}

inline const char* hkgShaderEffect::getName( ) const
{
	return m_name;
}

inline HKG_SHADER_RENDER_STYLE hkgShaderEffect::getStyleOR() const
{
	int sn = m_shaders.getSize();
	HKG_SHADER_RENDER_STYLE rs = HKG_SHADER_RENDER_NOSTYLE;
	for (int s=0; s < sn; ++s)
	{
		rs |= m_shaders[s]->getStyle();
	}
	return rs;
}

inline HKG_SHADER_RENDER_STYLE hkgShaderEffect::getStyleAND() const
{
	int sn = m_shaders.getSize();
	hkUint32 rs = ~(hkUint32)HKG_SHADER_RENDER_NOSTYLE;
	for (int s=0; s < sn; ++s)
	{
		rs &= (hkUint32)m_shaders[s]->getStyle();
	}
	return (HKG_SHADER_RENDER_STYLE)rs;
}

inline int hkgShaderEffect::getNumShaders() const
{
	return m_shaders.getSize();
}

inline const hkgShader* hkgShaderEffect::getShaderByType( HKG_SHADER_TYPE t) const
{
	int sn = m_shaders.getSize();
	for (int s=0; s < sn; ++s)
	{
		if (m_shaders[s]->getShaderType() == t)
			return m_shaders[s];
	}
	return HK_NULL;
}

inline const hkgShader* hkgShaderEffect::getShaderByIndex( int i ) const
{
	return m_shaders[i];
}

inline const char* hkgShaderEffect::getDefaultComponentName(HKG_VERTEX_COMPONENT c)
{
	return s_defaultComponentNames[c];
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
