/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_SHADER_EFFECT__H
#define HK_GRAPHICS_SHADER_EFFECT__H

#include <Graphics/Common/Shader/hkgShader.h>
#include <Graphics/Common/Geometry/VertexSet/hkgVertexSetDefines.h>

// Shaders (vertex, geom, hull, pixel, etc)
// all normally are grouped to form a particluar effect
// This class represents that group, and for instance in pure OpenGL GLSL programs is the warpper for the actual gl program
class hkgShaderEffect : public hkgReferencedObject, public hkgShaderParamInterface
{
	friend class hkgDisplayContext; // only one allowed bind()

public: 

	static hkgShaderEffect* (HK_CALL* create)();

	virtual HKG_SHADER_PARAM_TYPE getParamType() const { return HKG_EFFECT_SHADER; }
	
	/// Default create function, use ::create instead to get platform create as it may be different
	inline static hkgShaderEffect* defaultCreateInternal();

	inline void setName(const char* n );

	void setShaders(hkgShader** shaders, int numShaders);
	void setShaders(hkgShader* vertex, hkgShader* pixel);
	
	//DX10 / OGL3.0 or higher
	void setShaders(hkgShader* vertex, hkgShader* geom, hkgShader* pixel);
	
	//DX11 or higher
	void setShaders(hkgShader* vertex, hkgShader* hull, hkgShader* domain, hkgShader* geom, hkgShader* pixel );
	
	inline int getNumShaders() const;
	inline const hkgShader* getShaderByType( HKG_SHADER_TYPE t ) const;
	inline const hkgShader* getShaderByIndex( int i ) const;
	
	virtual void feedShaders(hkgDisplayContext* ctx, bool onlyFeedDirty, const hkgVertexSet* vertexHints);
	
	virtual const extArray<ShaderInput>* getInputOrder() const ;
	
	virtual void setWKNFloatInputIndex( int i, const float* v, int numV);
	virtual void setWKNFloatInput(HKG_SHADER_INPUT_CONSTANT semantic, int i, const float* v, int numV);
	virtual void setWKNMatFloatInput(HKG_SHADER_MAT_INPUT_CONSTANT semantic, int i, const float* v, int numV);
	virtual void setFloatInputByName( const char* n, const float* v, int numV );
	virtual void uploadConstants();
	virtual bool needsVertexInformation() const ;

	virtual bool hasNamedSamplers() const;
	virtual void addWKNSampler( HKG_TEXTURE_TYPE_HINT t, int index, int samplerIndex );
	virtual int getNamedSamplerIndex(HKG_TEXTURE_TYPE_HINT t, int index) const;
	

	inline HKG_SHADER_RENDER_STYLE getStyleOR() const;
	inline HKG_SHADER_RENDER_STYLE getStyleAND() const;
	
	inline const char* getName( ) const;
	void getDescription( extStringBuf& desc ) const; 

	static inline const char* getDefaultComponentName(HKG_VERTEX_COMPONENT c);

	/// Callback that happens when a shader is bound, to allow the
	/// user code to set any extra constants that may be required that
	/// aren't automatic in HKG.
	void (HK_CALL* m_userBindCallback)(hkgShaderEffect* shader);

protected:

	virtual void bind(hkgDisplayContext* ctx, const hkgVertexSet* vertexSetHint, bool changesEffect);
	virtual void unbind(hkgDisplayContext* ctx);

	hkgShaderEffect();
	virtual ~hkgShaderEffect();

	extArray<hkgShader*> m_shaders;
	extStringPtr m_name;

	static const char* s_defaultComponentNames[HKG_VERTEX_COMPONENT_NUM];
};

#include <Graphics/Common/Shader/hkgShaderEffect.inl>

#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
