/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


inline const char* hkgShader::getShaderTypeName(HKG_SHADER_TYPE t)
{
	static const char* _names[6]  = {
		"NS", // HKG_NULL_SHADER 0
		"VS", // HKG_VERTEX_SHADER 1
		"PS", // HKG_PIXEL_SHADER  2
		"GS", // HKG_GEOMETRY_SHADER 3	  
		"HS", // HKG_HULL_SHADER     4	  
		"DS"  // HKG_DOMAIN_SHADER   5	 
	};
	return _names[t];
}
	

hkgShader::hkgShader(HKG_SHADER_TYPE type) 
:	m_type(type)
,	m_allNormalInputs(0)
,	m_allMatrixInputs(0)
,	m_style(0)
,	m_needsVertexInformation(false)
{
	m_name = "";
}

HKG_SHADER_INPUT_CONSTANT hkgShader::getInputMask() const
{
	return m_allNormalInputs;
}


HKG_SHADER_MAT_INPUT_CONSTANT hkgShader::getMatInputMask() const
{
	return m_allMatrixInputs;
}

inline HKG_SHADER_RENDER_STYLE hkgShader::getStyle() const
{
	return m_style;
}

inline HKG_SHADER_RENDER_STYLE hkgShader::getStyleForMaterialHint( HKG_MATERIAL_VERTEX_HINT hint )
{
	HKG_SHADER_RENDER_STYLE s = HKG_SHADER_RENDER_NOSTYLE;

	if (hint & HKG_MATERIAL_VERTEX_HINT_VCOLOR)
		s |= HKG_SHADER_RENDER_VERTEX_COLOR;

	if (hint & HKG_MATERIAL_VERTEX_HINT_TANGENTS)
		s |= HKG_SHADER_RENDER_TANGENTS;

	if (hint & HKG_MATERIAL_VERTEX_HINT_BLENDING)
		s |= HKG_SHADER_RENDER_BLENDING;

	if (hint & HKG_MATERIAL_VERTEX_HINT_INSTANCED)
		s |= HKG_SHADER_RENDER_INSTANCING_USING_TCOORDS;

	if (hint & HKG_MATERIAL_VERTEX_HINT_DYNAMICVB)
		s |= HKG_SHADER_RENDER_DYNAMICVB;

	return s;
}


inline hkgShader* HK_CALL hkgShader::create(HKG_SHADER_TYPE type, hkgDisplayContext* context)
{
	if ( (type == HKG_GEOMETRY_SHADER) && (createGeometryShader != HK_NULL) ) return createGeometryShader(context);
	else if ( (type == HKG_VERTEX_SHADER) && (createVertexShader != HK_NULL) ) return createVertexShader(context);
	else if ( (type == HKG_PIXEL_SHADER) && (createPixelShader != HK_NULL) ) return createPixelShader(context);
	else if ( (type == HKG_HULL_SHADER) && (createHullShader != HK_NULL) ) return createHullShader(context);
	else if ( (type == HKG_DOMAIN_SHADER) && (createDomainShader != HK_NULL) ) return createDomainShader(context);	
	return HK_NULL;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
