/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_MOVIE_RECORDER
#define HK_GRAPHICS_MOVIE_RECORDER

	/// Abstract interface for a Havok Graphics movie recorder. 
class hkgMovieRecorder : public hkgReferencedObject
{
	public:
			/// Begin recording a movie, saved to disk at the given filename.
		virtual void startRecording(const char* filename, int motionBlurSamples) = 0;

			/// Add a frame to the current movie, taking a snapshot of the current display buffer.
		virtual void addFrame() = 0;

			/// Stop movie recording, closing file and stream.
		virtual void stopRecording() = 0;

			/// Creates a movie recorder for the current platform. If the platform has not been implemented, 
			/// an hkgNullMovieRecorder will be returned.
		static hkgMovieRecorder* HK_CALL create(hkgWindow* window);

};

#endif // HK_GRAPHICS_MOVIE_RECORDER

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
