/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_WIN32_MOVIE_RECORDER
#define HK_GRAPHICS_WIN32_MOVIE_RECORDER

#include <windows.h>
#include <Common/Base/Fwd/hkcstdio.h>


#include <Graphics/Common/Movie/hkgMovieRecorder.h>

	/// A Havok Graphics movie recorder that runs on Win32 systems using FFmpeg executable.
class hkgWin32MovieRecorder : public hkgMovieRecorder
{
	public:

			/// Create a Win32 Havok Graphics movie recorder.
		hkgWin32MovieRecorder(hkgWindow* window);

			/// Begin recording a movie, saved to disk at the given filename.
		virtual void startRecording(const char* filename, int motionBlurSamples);

			/// Add a frame to the current movie, taking a snapshot of the current display buffer.
		virtual void addFrame();

			/// Stop movie recording, closing file and stream.
		virtual void stopRecording();

	protected:
		
			/// mpeg file written to.
		FILE* m_ffmpegFileHandle;
		
			/// The current frame index.
		int m_frameCount;

			/// Havok Graphics window being recorded.
		hkgWindow* m_window;

			/// The initial width of the recorded window. This is stored because changing the size of a window
			/// during recording cannot use the same stream so the class needs to be aware of that.
		unsigned int m_initialWidth;
			/// The initial height of the recorded window. This is stored because changing the size of a window
			/// during recording cannot use the same stream so the class needs to be aware of that.
		unsigned int m_initialHeight;

		bool m_isRecording;

			/// Number of frames to accumulate before saving a frame (any value <= 1 will result in every frame being saved).
		int m_motionBlurSamples;

			/// Accumulation buffer. Only used if m_motionBlurSamples > 1.
		hkArray<hkUint32> m_accumBuffer;
};

#endif // HK_GRAPHICS_WIN32_MOVIE_RECORDER

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
