/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HKBASE_HKGRAPHARRAY_H
#define HKBASE_HKGRAPHARRAY_H

// a class for a directed graph storing its data in arrays

template <class NODETYPE>
class hkGraphArray
{
 public:

    class Arc;
    class Node;

    // New types
    typedef hkUint32                           NodeID;
    typedef extArray<Node>                NodeArray;
    typedef typename NodeArray::iterator       NodeIterator;
    typedef typename NodeArray::const_iterator ConstNodeIterator;

    typedef hkGraphArray<NODETYPE>             GraphType;


    // hkGraphArray::Arc class
    class Arc
	{
	public:
		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY, Arc);
		HK_FORCE_INLINE Arc() {}
		~Arc();

		HK_FORCE_INLINE NodeIterator terminal() const;

	protected:
	    friend class hkGraphArray<NODETYPE>;

	    Arc(NodeIterator terminal);

	    NodeIterator m_terminal;
	};


    // New types
    typedef extArray<Arc>                ArcArray;
    typedef typename ArcArray::iterator       ArcIterator;
    typedef typename ArcArray::const_iterator ConstArcIterator;


    // hkGraphArray::Node class
    class Node
	{
	public:
		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_GEOMETRY, Node);
		HK_FORCE_INLINE Node() : m_arcs(HK_NULL), m_begin(0), m_end(0), m_marker(false) {}
		~Node();

	    HK_FORCE_INLINE void mark();
	    HK_FORCE_INLINE void unmark();
	    HK_FORCE_INLINE hkBool marked() const;

	    HK_FORCE_INLINE hkBool outEmpty() const;
	    HK_FORCE_INLINE hkUint32 outSize() const;

	    HK_FORCE_INLINE ArcIterator outBegin();
	    HK_FORCE_INLINE ArcIterator outEnd();
	    HK_FORCE_INLINE ConstArcIterator outBegin() const;
	    HK_FORCE_INLINE ConstArcIterator outEnd() const;

	    HK_FORCE_INLINE NODETYPE & operator * ();
	    HK_FORCE_INLINE NODETYPE * operator -> ();
	    HK_FORCE_INLINE const NODETYPE & operator * () const;
	    HK_FORCE_INLINE const NODETYPE * operator -> () const;

	    NODETYPE & operator = (const NODETYPE & e);

	protected:
	    friend class hkGraphArray<NODETYPE>;

		Node(ArcArray * arcs);

	    ArcArray * m_arcs;
	    hkUint32   m_begin;
	    hkUint32   m_end;

	    NODETYPE   m_elem;
	    hkBool     m_marker;
	};


    hkGraphArray();
    HK_FORCE_INLINE explicit hkGraphArray(hkUint32 numNodes);

    // Node related member functions
    HK_FORCE_INLINE hkBool isEmpty() const;
    HK_FORCE_INLINE hkUint32 getSize() const;

    HK_FORCE_INLINE Node & operator [] (NodeID i);
    HK_FORCE_INLINE const Node & operator [] (NodeID i) const;

    HK_FORCE_INLINE NodeIterator begin();
    HK_FORCE_INLINE NodeIterator end();
    HK_FORCE_INLINE ConstNodeIterator begin() const;
    HK_FORCE_INLINE ConstNodeIterator end() const;

    // Arc related member functions
    HK_FORCE_INLINE ArcIterator insertArc(NodeID initial, NodeID terminal);
    HK_FORCE_INLINE ArcIterator insertArc(NodeIterator initial, NodeIterator terminal);

    // Optimized (overloaded) functions
    HK_FORCE_INLINE void swap(GraphType & right);
    //friend void swap(GraphType & left, GraphType & right);

 protected:
    hkGraphArray(const GraphType &);
    GraphType & operator = (const GraphType &);

	ArcArray  m_arcs;
    NodeArray m_nodes;
};

#include <Graphics/Common/Geometry/FaceSet/hkGraphArray.inl>

#endif // HKBASE_HKGRAPHARRAY_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
