/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_WIREFRAME_DISPLAY_OBJECT_H
#define HK_GRAPHICS_WIREFRAME_DISPLAY_OBJECT_H

#include <Graphics/Common/DisplayObject/hkgDisplayObject.h>



class hkgWireframeDisplayObject : public hkgDisplayObject
{
	public:
		/// Creates a platform specific display object.
		static hkgWireframeDisplayObject* (HK_CALL *create)();

		/// Default create function, use ::create instead.
		inline static hkgWireframeDisplayObject* defaultCreateInternal() { return new hkgWireframeDisplayObject; }

		virtual hkgDisplayObject* copy( HKG_DISPLAY_OBJECT_COPY_FLAGS f, hkgDisplayContext* ctx /*only required if doing deeper copies (facesets and/or verts)*/ ) const HK_OVERRIDE;

		virtual void render(hkgDisplayContext* context) const HK_OVERRIDE;
		virtual void setColor( hkgDisplayWorld* displayWorld, hkColor::Argb color ) HK_OVERRIDE;

		void setDisplayLines( const hkArrayBase<hkVector4>& lines );

		void appendDisplayLines( const hkArrayBase<hkVector4>& lines );

		inline hkColor::Argb getWireframeColor() const { return m_color; }
		void setWireframeColor( hkColor::Argb c );

	protected:

		void setAABBfromLines();

		hkgWireframeDisplayObject();

		virtual ~hkgWireframeDisplayObject();

		hkArray<hkVector4> m_lines;
		hkColor::Argb m_color;
	
};
#endif // HK_GRAPHICS_PARTICLE_DISPLAY_OBJECT_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
