/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_PARTICLE_DISPLAY_OBJECT_H
#define HK_GRAPHICS_PARTICLE_DISPLAY_OBJECT_H

#include <Graphics/Common/DisplayObject/hkgDisplayObject.h>
#include <Graphics/Common/DisplayObject/hkgParticleDisplayObjectDefines.h>



class hkgParticleDisplayObject : public hkgDisplayObject
{
	public:
		static hkgParticleDisplayObject* (HK_CALL *create)( hkgDisplayContext* ctx );

		virtual hkgDisplayObject* copy( HKG_DISPLAY_OBJECT_COPY_FLAGS f, hkgDisplayContext* ctx /*only required if doing deeper copies (facesets and/or verts)*/ ) const;
	
		virtual void setMaxNumParticles( int numParticles, bool allocateBuffers = false ) = 0;
		inline int getMaxNumParticles()	{ return m_maxNumParticles; }

		virtual void setPosition( const float* position, int objectIdx ) = 0;
		HK_FORCE_INLINE void setPosition( hkVector4Parameter position, int objectIdx );
		virtual const float* getPosition( int objectIdx ) const = 0;

		virtual void setVelocity( const float* vel, int objectIdx ) = 0;
		HK_FORCE_INLINE void setVelocity( hkVector4Parameter velocity, int objectIdx );
		virtual const float* getVelocity( int objectIdx ) const = 0;

		virtual void setUserData( const float* data, int objectIdx ) = 0;
		HK_FORCE_INLINE void setUserData( hkVector4Parameter data, int objectIdx );
		virtual const float* getUserData( int objectIdx ) const = 0;

		virtual void setNumParticles( int numParticles );
		virtual void setStartIndex( int index );
		inline int getNumParticles() const { return m_currentNumParticles; }
		inline int getStartIndex() const { return m_startIndex; }

		void setMaterial( hkgMaterial* m );
		inline hkgMaterial* getMaterial() { return m_material; }
		inline const hkgMaterial* getMaterial() const { return m_material; }

		inline void setRenderMode( HKG_PARTICLE_DISPLAY_MODE m ) { m_renderMode = m; }
		inline HKG_PARTICLE_DISPLAY_MODE getRenderMode() const { return m_renderMode; }

		inline void setBlendMode( HKG_PARTICLE_BLEND_MODE m ) { m_blendMode = m; }
		inline HKG_PARTICLE_BLEND_MODE getBlendMode() const { return m_blendMode; }

		inline void setParticlePointSize(float size) { m_particlePointSize = size; }
		inline void setParticleTime( float t ) { m_particleTime = t; }
		inline void setParticleLifeTime( float t ) { m_particleLifeTime = t; }

		inline float getParticlePointSize() const { return m_particlePointSize; }
		inline float getParticleTime() const { return m_particleTime; }
		inline float getParticleLifeTime() const { return m_particleLifeTime; }

		inline hkUlong getUserId() const { return m_userId; }
		inline void setUserId(hkUlong id) { m_userId = id; }

		// some impls support a cpu sort
		virtual bool sort( bool backToFront, const hkVector4& from ) { return false; } 

	protected:

		hkgParticleDisplayObject();

		virtual ~hkgParticleDisplayObject();
		
		int m_maxNumParticles;
		int m_startIndex;
		int m_currentNumParticles;
		float m_particlePointSize;
		float m_particleTime;
		float m_particleLifeTime;
		HKG_PARTICLE_BLEND_MODE m_blendMode; 
		HKG_PARTICLE_DISPLAY_MODE m_renderMode;
		hkgMaterial* m_material; // we don't store any geom (there will be no hkgGeometry) so instead we just store a material
		hkUlong m_userId;
};

HK_FORCE_INLINE void hkgParticleDisplayObject::setPosition( hkVector4Parameter position, int objectIdx )
{
#if defined(HK_REAL_IS_DOUBLE)
	HK_ALIGN_REAL(hkFloat32 p[4]);
	position.store<4>(&p[0]);
	setPosition( &p[0], objectIdx );
#else
	setPosition( &position(0), objectIdx );
#endif
}

HK_FORCE_INLINE void hkgParticleDisplayObject::setVelocity( hkVector4Parameter velocity, int objectIdx )
{
#if defined(HK_REAL_IS_DOUBLE)
	HK_ALIGN_REAL(hkFloat32 v[4]);
	velocity.store<4>(&v[0]);
	setVelocity( &v[0], objectIdx );
#else
	setVelocity( &velocity(0), objectIdx);
#endif
}

HK_FORCE_INLINE void hkgParticleDisplayObject::setUserData( hkVector4Parameter data, int objectIdx )
{
#if defined(HK_REAL_IS_DOUBLE)
	HK_ALIGN_REAL(hkFloat32 u[4]);
	data.store<4>(&u[0]);
	setUserData( &u[0], objectIdx );
#else
	setUserData( &data(0), objectIdx);
#endif
}
#endif // HK_GRAPHICS_PARTICLE_DISPLAY_OBJECT_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
