/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_INSTANCED_DISPLAY_OBJECT_H
#define HK_GRAPHICS_INSTANCED_DISPLAY_OBJECT_H

#include <Graphics/Common/DisplayObject/hkgDisplayObject.h>
#include <Graphics/Common/DisplayObject/hkgInstancedDisplayObjectDefines.h>

class hkgInstancedDisplayObject : public hkgDisplayObject
{
	public:
		static hkgInstancedDisplayObject* (HK_CALL *create)( hkgDisplayContext* ctx );

		virtual hkgDisplayObject* copy( HKG_DISPLAY_OBJECT_COPY_FLAGS f, hkgDisplayContext* ctx /*only required if doing deeper copies (facesets and/or verts)*/ ) const;
		virtual int intersect( const hkgFrustum& frustum, bool ignoreBackfaces, hkgDisplayObjectPickData& data) const HK_OVERRIDE { HK_WARN_ONCE(0x22440125, "Intersect frustum not implemented for instanced display objects."); return 0; }
		virtual int intersect( const hkgRay& ray, bool ignoreBackfaces, hkgDisplayObjectPickData& data) const  HK_OVERRIDE { HK_WARN_ONCE(0x22440125, "Intersect ray not implemented for instanced display objects."); return 0; }

		/// Returns true if the implementation supports skinning
		HK_FORCE_INLINE bool getSupportsSkinning() const {	return m_supportsSkinning;	}

		virtual void setMaxNumObjects( int numObjects, int numBonesPerObject = 0, bool allocateBuffers = true, int perBoneExtraDataSize = 0 ) = 0;
		virtual void setNumObjects( int numObjects );
		
		virtual void setRenderMode(HKG_INSTANCED_DISPLAY_MODE mode) = 0;
		inline HKG_INSTANCED_DISPLAY_MODE getRenderMode() const { return m_renderMode; }

		inline int getNumObjects() const { return m_currentNumObjects; }
		inline int getMaxNumObjects() const { return m_maxNumObjects; }

		virtual void setTransform( const float* transform, int objectIdx ) = 0;
		virtual void setTransforms( const float* allTransforms, int numTransforms, int startTransform );
		virtual void setTransformAligned( const hkTransform& transform, int objectIdx ) { HK_ALIGN16(float t[16]); transform.get4x4ColumnMajor(t); setTransform(t, objectIdx );  }

		/// Per bone user data handling
		inline int getPerBoneExtraDataSize() { return m_perBoneUserDataSize; }
		virtual const void* getBoneUserData(int objectIdx, int boneIdx) const;
		virtual void setBoneUserData(int objectIdx, int boneIdx, const void* data);

		/// Sets the bone transform
		virtual void setBoneTransform(const float* transform, int objectIdx, int boneIdx);
		virtual void getBoneTransform(int objectIdx, int boneIdx, float* transformOut) const;

		virtual void setInstanceColor( hkUint32 c, int objectIdx ) { } 
		
		virtual HKG_INSTANCED_TRANSFORM_ACCESS getDirectTransformAccessSupport() const { return HKG_INSTANCED_TRANSFORM_ACCESS_NOT_SUPPORTED; }
		virtual float* lockDirectTransformAccess(bool write) { return HK_NULL; }
		virtual void unlockDirectTransformAccess() { }

		virtual const float* getTransform( int objectIdx ) const = 0;

		void setSupportsColorBuffer( bool colorBuffer ) { m_supportsColorBuffer = colorBuffer; }
		bool getSupportsColorBuffer() const { return m_supportsColorBuffer; }

		void setStartTransformIndex( int index );
		int getStartTransformIndex() const;

		inline hkUlong getUserShapeId() const { return m_userShapeId; }
		inline void setUserShapeId(hkUlong id) { m_userShapeId = id; }

		/// Returns the number of bones per instance
		inline int getNumBonesPerObject() const {	return m_numBonesPerObject;	}

			// per index user data. This will use mem, so only set if you need it (for picking perhaps)
		inline void setUserDataAtIndex( int index, hkUlong d ) { if (m_perIndexData.getSize() <= index) { m_perIndexData.setSize(index + 1, 0); } m_perIndexData[index] = d; }
		inline hkUlong getUserDataFromIndex( int index ) const { if (m_perIndexData.getSize() > index) return m_perIndexData[index]; else return 0; }

		virtual void computeAABBInView( const hkgCamera* c ) { }

		/// Returns the size of the extra per-instance data
		virtual int getExtraInstanceDataSize() const { return 0; }

		virtual hkgDisplayKeyFrame::KeyFrame* getKeyFrame(hkgDisplayKeyFrame& owner) const HK_OVERRIDE;
		virtual void setKeyFrame(const hkgDisplayKeyFrame& kfBuffer, const hkgDisplayKeyFrame::KeyFrame* transformIn) HK_OVERRIDE;

		/// Returns a blend matrix set for a given instance
		hkgBlendMatrixSet* getObjectBlendMatrixSet(int objectIdx) const;

	protected:

		inline hkgInstancedDisplayObject( )
			: m_renderMode(HKG_INSTANCED_DISPLAY_TCOORD123), m_maxNumObjects(0), m_numBonesPerObject(0), m_currentNumObjects(0), m_startTransformIndex(0), m_perBoneUserDataSize(0), m_userShapeId(0), m_perInstanceBoundingRadius(-1), m_supportsSkinning(false)
		{
			setStatusFlags( getStatusFlags() | HKG_DISPLAY_OBJECT_INSTANCED );
			m_supportsColorBuffer = false;
		}

		HKG_INSTANCED_DISPLAY_MODE m_renderMode;
		
		int m_maxNumObjects;
		int m_numBonesPerObject;
		int m_currentNumObjects;
		int m_startTransformIndex;
		int m_perBoneUserDataSize;			// In bytes

		hkUlong m_userShapeId;
		extArray<hkUlong> m_perIndexData;
		mutable float m_perInstanceBoundingRadius;

		bool m_supportsColorBuffer;
		bool m_supportsSkinning;
};

#endif // HK_GRAPHICS_INSTANCED_DISPLAY_OBJECT_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
