/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

// Define HK_GPU_STATS to get GPU statistics
// Win/DirectX11 only at the moment

#ifndef HK_GRAPHICS_DISPLAY_STATISTICS_H
#define HK_GRAPHICS_DISPLAY_STATISTICS_H

class hkgDisplayStatistics
{
public:
	HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO, hkgDisplayStatistics);

	struct HWStatistics
	{
		unsigned long m_inputVertices;
		unsigned long m_inputPrimitives;
		unsigned long m_rasterizerPrimitives;
		unsigned long m_renderedPrimitives;
		unsigned long m_pixels;

		HWStatistics()
		{
			clear();
		}

		void clear()
		{
			m_inputVertices = 0;
			m_inputPrimitives = 0;
			m_rasterizerPrimitives = 0;
			m_renderedPrimitives = 0;
			m_pixels = 0;
		}
	};

	struct ObjectStatistics
	{
		ObjectStatistics()
		{
			clear();
		}

		void clear()
		{
			m_position.setZero();
			m_numDrawCalls = 0;
			m_numNonInstancedDrawCalls = 0;
			m_numInstancedDrawCalls = 0;
			m_numPrimitives = 0;
			m_numNonInstancedPrimitives = 0;
			m_numInstancedPrimitives = 0;
			m_numInstances = 0;
			m_numResourceUpdates = 0;
			m_numClears = 0;
		}

		unsigned long m_numDrawCalls;				// Draw calls in frame
		unsigned long m_numNonInstancedDrawCalls;	// Instanced draw calls in frame
		unsigned long m_numInstancedDrawCalls;		// Non-instanced draw calls in frame
		unsigned long m_numPrimitives;				// Primitives in frame
		unsigned long m_numNonInstancedPrimitives;	// Non-instanced primitives in frame
		unsigned long m_numInstancedPrimitives;		// Instanced primitives in frame
		unsigned long m_numInstances;				// Instances
		unsigned long m_numResourceUpdates;			// Resource locks, resolves, updates
		unsigned long m_numClears;					// Render target clears

		const char*   m_name;
		hkVector4 m_position;
	};
	struct GroupStatistics
	{
		hkArray<ObjectStatistics> m_objects;
		int m_currentObject;

		GroupStatistics()
		{
			addObject( "Sum" );
		}

			// Log to a specified object
		void addObject( const char *name )
		{
			ObjectStatistics &newObject = m_objects.expandOne();
			newObject.m_name = name;

			m_currentObject = m_objects.getSize() - 1;
		}

			// Log to global
		void clearObject()
		{
			m_currentObject = 0;
		}

			// Add non-instanced primitives
		inline void addDrawCall( unsigned long numPrimitives )
		{
			ObjectStatistics &object = m_objects[ m_currentObject ];
			object.m_numPrimitives += numPrimitives;
			object.m_numNonInstancedPrimitives += numPrimitives;
			object.m_numDrawCalls++;
			object.m_numNonInstancedDrawCalls++;
			if ( m_currentObject != 0 )
			{
				ObjectStatistics &sumObject = m_objects[ 0 ];
				sumObject.m_numPrimitives += numPrimitives;
				sumObject.m_numNonInstancedPrimitives += numPrimitives;
				sumObject.m_numDrawCalls++;
				sumObject.m_numNonInstancedDrawCalls++;
			}
		}

			// Add instanced primitives
		inline void addInstancedDrawCall( unsigned long numPrimitives, unsigned long numInstances )
		{
			ObjectStatistics &object = m_objects[ m_currentObject ];
			unsigned long numAllPrimitives = numPrimitives * numInstances;
			object.m_numPrimitives += numAllPrimitives;
			object.m_numInstancedPrimitives += numAllPrimitives;
			object.m_numInstances += numInstances;
			object.m_numDrawCalls++;
			object.m_numInstancedDrawCalls++;
			if ( m_currentObject != 0 )
			{
				ObjectStatistics &sumObject = m_objects[ 0 ];
				sumObject.m_numPrimitives += numAllPrimitives;
				sumObject.m_numInstancedPrimitives += numAllPrimitives;
				sumObject.m_numInstances += numInstances;
				sumObject.m_numDrawCalls++;
				sumObject.m_numInstancedDrawCalls++;
			}
		}

		inline void addResourceUpdate( unsigned int numUpdates = 1 )
		{
			ObjectStatistics &object = m_objects[ m_currentObject ];
			object.m_numResourceUpdates += numUpdates;
			if ( m_currentObject != 0 )
			{
				ObjectStatistics &sumObject = m_objects[ 0 ];
				sumObject.m_numResourceUpdates += numUpdates;
			}
		}

		inline void addClear( unsigned int numClears = 1 )
		{

			ObjectStatistics &object = m_objects[ m_currentObject ];
			object.m_numClears += numClears;
			if ( m_currentObject != 0 )
			{
				ObjectStatistics &sumObject = m_objects[ 0 ];
				sumObject.m_numClears += numClears;
			}
		}

		void clear()
		{
			m_objects.setSize(1);
			m_objects[0].clear();
		}
	};

	enum Group
	{
		GROUP_SUM = 0,
		GROUP_NORMAL,
		GROUP_SHADOW_0,
		GROUP_SHADOW_1,
		GROUP_SHADOW_2,
		GROUP_SHADOW_3,
		GROUP_SHADOW_4,
		GROUP_SHADOW_5,
		GROUP_SHADOW_6,
		GROUP_SHADOW_7,
		GROUP_VELOCITY,
		GROUP_REFLECTION,
		GROUP_MAX
	};

	inline void clearAll()
	{
		for ( int i=0; i<GROUP_MAX; i++ )
		{
			m_groups[i].clear();
		}
	}

	void advanceFrame();

		// Add non-instanced primitives
	inline void addDrawCall( unsigned long numPrimitives )
	{
		m_groups[ m_currentGroup ].addDrawCall( numPrimitives );
		if ( m_currentGroup != GROUP_SUM )
		{
			m_groups[ GROUP_SUM ].addDrawCall( numPrimitives );
		}
	}

		// Add instanced primitives
	inline void addInstancedDrawCall( unsigned long numPrimitives, unsigned long numInstances )
	{
		m_groups[ m_currentGroup ].addInstancedDrawCall( numPrimitives, numInstances );
		if ( m_currentGroup != GROUP_SUM )
		{
			m_groups[ GROUP_SUM ].addInstancedDrawCall( numPrimitives, numInstances );
		}
	}

	inline void addResourceUpdate( unsigned int numUpdates = 1 )
	{
		m_groups[ m_currentGroup ].addResourceUpdate( numUpdates );
		if ( m_currentGroup != GROUP_SUM )
		{
			m_groups[ GROUP_SUM ].addResourceUpdate( numUpdates );
		}
	}

	inline void addClear( unsigned int numClears = 1 )
	{
		m_groups[ m_currentGroup ].addClear( numClears );
		if ( m_currentGroup != GROUP_SUM )
		{
			m_groups[ GROUP_SUM ].addClear( numClears );
		}
	}

	inline void setGroup( Group group )
	{
		m_currentGroup = group;
	}

	inline void addObject( const char *name )
	{
		m_groups[ m_currentGroup ].addObject( name ) ;
		if ( m_currentGroup != GROUP_SUM )
		{
			m_groups[ GROUP_SUM ].addObject( name ) ;
		}
	}

	inline void clearObject()
	{
		m_groups[ m_currentGroup ].clearObject();
		if ( m_currentGroup != GROUP_SUM )
		{
			m_groups[ GROUP_SUM ].clearObject() ;
		}
	}

public:
	static const char* const m_groupNames[12];
	GroupStatistics m_groups[ GROUP_MAX ];
	HWStatistics m_hwStats;

	Group     m_currentGroup;
	hkVector4   m_currentPos;
};


#endif	// HK_GRAPHICS_DISPLAY_STATISTICS_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
