/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#ifndef HKG_SYSTEM_H
#define HKG_SYSTEM_H

/// The graphics subsystem class.
class hkgSystem
{
	public:
			/// Ensure hkBaseSystem::init has been called first.
		static void HK_CALL init(const char* renderer=0);
		static void HK_CALL quit();

		enum HKG_RENDERER
		{
			HKG_RENDERER_NONE = 0, // Not initialized yet
			HKG_RENDERER_NULL, // Null Display : does everything except actually send anything to the cards etc.
			HKG_RENDERER_OGLS,  // PC, OpenGL but only using shaders (the PS3 renderer on PC)
			HKG_RENDERER_OGLES,  // PC, handhelds, OpenGL ES 1.0 / 1,1 (fixed function)
			HKG_RENDERER_OGLES2,  // PC, handhelds, OpenGL ES 2.0 (shaders)
			HKG_RENDERER_DX9,  // PC, DX9 Shaders only (the Xbox360 renderer on PC) 
			HKG_RENDERER_DX11,  // Vista (with Platform Update), and Windows7 DX11 (which is always shaders only, and can work on DX9, DX10 and DX11 h/w)
			HKG_RENDERER_CONSOLE // XBOX, GameCube etc
		};

		// The API being used
		enum HKG_RENDERER_SUBSYSTEM_API
		{
			HKG_RENDERER_SUBSYSTEM_NONE = 0, 
			HKG_RENDERER_SUBSYSTEM_NULL, // No subsystem 
			HKG_RENDERER_SUBSYSTEM_DIRECTX9,// Xbox360, PC
			HKG_RENDERER_SUBSYSTEM_DIRECTX11,// PC (Vista, Win7)
			HKG_RENDERER_SUBSYSTEM_OPENGL, // PC, PS3 (although it is more like ES2, just with Cg etc), Linux, Mac
			HKG_RENDERER_SUBSYSTEM_OPENGLES, // PC, handhelds
			HKG_RENDERER_SUBSYSTEM_OPENGLES2, // PC, handhelds
			HKG_RENDERER_SUBSYSTEM_OTHER // GameCube, Wii, PSP, CTR, PS Vita
		};


		static hkEnum<HKG_RENDERER, hkUint8> g_RendererType;

		static const char* HK_CALL getRendererString();
		static HKG_RENDERER_SUBSYSTEM_API HK_CALL getRendererSubSystemAPI();


	private:

		hkgSystem();
};	

#endif // HKG_SYSTEM_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
