/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#ifndef HKG_MESH_TEXTURE_H
#define HKG_MESH_TEXTURE_H

#include <Common/GeometryUtilities/Mesh/hkMeshTexture.h>

extern const class hkClass hkgMeshTextureClass;

	/// Havoks texture wrapper around hkg Graphics
	/// Utltimately, when the texture loading will be possible through hkBase, the hkgTexture class shouldn't exist anymore
	/// For now, loading png and jpg files are only possible through demo framework, hence the class division for texture handling
class hkgMeshTexture: public hkMeshTexture
{
	public:

		HK_DECLARE_REFLECTION();

	protected:

		/// Base class for a texture sampler
		struct HkgSamplerBase : public Sampler
		{
			/// Constructor
			HkgSamplerBase(const hkgTexture* t);

			/// Samples the texture at the given Uv.
			void sample(hkVector4Parameter uvIn, hkVector4& texelOut) const HK_OVERRIDE;

			/// Returns an image at the specified mip level
			virtual hkImage* getImage(int mipLevel) const HK_OVERRIDE;

			const hkgTexture* m_texture;	///< The texture
			hkArray<hkUint32> m_argb;		///< The ARGB color data
		};

	public:
			/// Constructor that creates a new hkgTexture using context.  Textures created with this 
			/// constructor are write only.
		hkgMeshTexture(hkgDisplayContext* context);
			/// Constructor that wraps an existing hkgTexture.  Textures created with this constructor
			/// are read only.
		hkgMeshTexture(const hkgTexture* texture, bool readOnly = true);

			/// Serialization constructor
		hkgMeshTexture(hkFinishLoadedObjectFlag flag);

			/// Destructor.  Releases the hkgTexture if it was loaded.
		~hkgMeshTexture();

			// hkReferencedObject implementation
		virtual const hkClass* getClassType() const HK_OVERRIDE;

			/// Not implemented, returns HK_NULL, 0 and unknown respectively
		virtual void getData(unsigned char*& data, int& size, Format& format);
			/// Sets the data of the internal hkgTexture
		virtual void setData(unsigned char* data, int size, Format format);

			/// Gets the raw data format
		virtual Format getFormat() const HK_OVERRIDE;
	
			// hkMeshTexture implementation
		virtual const char* getFilename() const;
			// hkMeshTexture implementation
		virtual void setFilename( const char* filename );

			// hkMeshTexture implementation
		virtual bool getHasMipMaps() const;
			// hkMeshTexture implementation
		virtual void setHasMipMaps(bool hasMipMaps);
			
			// hkMeshTexture implementation
		virtual FilterMode getFilterMode() const;
			// hkMeshTexture implementation
		virtual void setFilterMode(FilterMode filterMode);
			
			// hkMeshTexture implementation
		virtual TextureUsageType getUsageHint() const;
			// hkMeshTexture implementation
		virtual void setUsageHint( TextureUsageType hint );

			// hkMeshTexture implementation
		virtual hkInt32 getTextureCoordChannel() const;
			// hkMeshTexture implementation
		virtual void setTextureCoordChannel( hkInt32 channelIndex );

			// Is the texture a read only wrapper around a hkgTexture instance.
		virtual bool isReadOnly() const HK_OVERRIDE;

			// Gets the wrapped hkgTexture.
		hkgTexture* getTexture() const;

			// hkMeshTexture implementation
		Sampler* createSampler() const HK_OVERRIDE;

		/// Tests whether two textures are equal
		virtual bool equals(const hkMeshTexture* other) const HK_OVERRIDE;

	protected:
			/// Internal hkgTexture
		hkgTexture* m_texture;
			/// Filename of the texture, if specified
		hkStringPtr m_filename;
			/// Flag if the texture can be written to
		hkBool m_isReadOnly;
			/// Usage hint
		hkEnum<hkMeshTexture::TextureUsageType, hkInt8> m_usageHint;
			/// Channel in the vertex buffer
		hkInt32 m_textureCoordChannel;

			/// A descriptor for returning the RAW data if any
		RawBufferDescriptor m_rawDescriptor;	//+nosave
};
#endif	//HKG_MESH_TEXTURE_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
