/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_HKGBONEMESHBODY_H
#define HK_HKGBONEMESHBODY_H

#include <Common/GeometryUtilities/Mesh/hkMeshBody.h>

extern const hkClass hkgBoneMeshBodyClass;

class hkgBoneMeshBody : public hkMeshBody
{
	public:

			/// Constructor
		hkgBoneMeshBody( hkMeshBody* skin, int boneIndex );

			/// hkMeshBody implementation
		virtual void completeUpdate();
		virtual void completeUpdate(const hkMatrix4& transform);

			/// hkReferencedObject Implementation
		virtual const hkClass* getClassType() const { return &hkgBoneMeshBodyClass; }

			/// Change visibility
		void setVisible( hkBool visible );

			/// Get the mesh shape
		virtual const hkMeshShape* getMeshShape() const { return HK_NULL; }

			/// Get the currently set model to world transform
		virtual void getTransform( hkMatrix4& transform ) const;

			/// Set the current model to world transform
		virtual void setTransform(const hkMatrix4& matrix);

			/// Get the per body per mesh section vertex buffer/s - one per section (note they can be shared).
			/// If there is no per body vertex data, this method can return HK_NULL.
			/// The format of this buffer must minimally contain the elements specified as instantiable (FLAG_NOT_SHARED elements) in the
			/// shapes vertex buffer. It may or may not contained the shared members - reading or writing to non instance
			/// members produces undefined results.
		virtual hkMeshVertexBuffer* getVertexBuffer(int sectionIndex) { return HK_NULL; }

			/// Get the number of indexed transforms
		virtual int getNumIndexedTransforms() { return 0; }

			/// Set the indexed transforms - when all changes are made, make a call to 'completeUpdate' to complete the update
		virtual void setIndexedTransforms(int startIndex, const hkMatrix4* matrices, int numMatrices) {}

			/// Get the indexed transforms
		virtual void getIndexedTransforms(int startIndex, hkMatrix4* matrices, int numMatrices) { HK_ASSERT2(0x3bf6cbb, false, "This should never be called!" ); }

			/// Get the indexed inverse transforms
		virtual void getIndexedInverseTransforms(int startIndex, hkMatrix4* matrices, int numMatrices) { HK_ASSERT2(0x3e294899, false, "This should never be called!" ); }

			/// Get main skin
		const hkMeshBody* getSkin() const	{ return m_skin; }
		hkMeshBody* getSkin()				{ return m_skin; }

			/// Set main skin
		void setSkin( hkMeshBody* skin );

			/// Get bone index
		int getBoneIndex() const { return m_boneIndex; }

	protected:

			/// World transform
		hkMatrix4 m_transform;

			/// Dirty flag
		hkBool m_dirty;

			/// Bone index in main skin
		int m_boneIndex;

			/// Reference to main skin
		hkRefPtr<hkMeshBody>	m_skin;

			/// Visibility flag
		bool m_visible;

		hkMatrix4 m_offset;
};

#endif // HK_HKGBONEMESHBODY_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
