/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#ifndef HKG_MEMORY_TRACKER_GRAPH_H
#define HKG_MEMORY_TRACKER_GRAPH_H

#include <Common/Base/Memory/Tracker/ScanCalculator/hkTrackerSnapshot.h>
#include <Common/Base/Memory/Tracker/ScanCalculator/hkTrackerScanSnapshot.h>
#include <Common/Base/Memory/Tracker/Report/hkCategoryReportUtil.h>

class hkgFont;
class hkgTexture;

class hkgMemoryTrackerGraph : public hkgReferencedObject
{
	public:

		hkgMemoryTrackerGraph();
		virtual ~hkgMemoryTrackerGraph();

			// can be called more than once (to change type, resize, etc)
		bool init(hkgDisplayContext* context, hkTrackerSnapshot& snapshot, int width, int height);  
		void resize(hkgDisplayContext* context, int width, int height);

		enum ActionType
		{
			ACTION_NONE = 0,
			ACTION_RESET_ZOOM,
			ACTION_PAN_NEGX,
			ACTION_PAN_POSX,
			//ACTION_PAN_NEGY,
			//ACTION_PAN_POSY
		};

		void zoom( int fromPixelX, int fromPixelY, int toPixelX, int toPixelY);
		void pan( hkReal percentX); // usually say (-0.1f, 0) or (0.f, 1) etc 

		void display( int xPos, int yPos, bool useCurrentViewport = false );

			// call this if the user presses a button over the stat graph. Will return what action it preformed, if any
		ActionType userAction( int xMousePos, int yMousePos );

		inline hkInt32 getDisplayWidth() const { return m_displayWidth; }
		inline hkInt32 getDisplayHeight() const { return m_displayHeight; }
		inline hkInt32 getDisplayLastX() const { return m_displayLastX; }
		inline hkInt32 getDisplayLastY() const { return m_displayLastY; }

		void displayZoomExtents( int originX, int originY, int mouseX, int mouseY, bool useCurrentViewport = false) const;

		void update(hkReal timeStep);

		struct ZoomData
		{
			HK_DECLARE_POD_TYPE(); 
			
			hkReal m_zoomStart;				///< The start in address space in the zoom window 
			hkReal m_zoomEnd;				///< The end in address space in the zoom window
		};

		const ZoomData& getCurrentZoomData() const { return m_zoomData.back(); }

		typedef hkCategoryReportUtil::Category Category;
		typedef hkCategoryReportUtil::Block Block;

		struct OrderedBlock
		{
			HK_DECLARE_POD_TYPE(); 

			int m_category;
			hk_size_t m_start;
			hk_size_t m_size;
			const Block* m_block;
		};

		struct CategoryBlock
		{
			HK_DECLARE_POD_TYPE(); 
			hk_size_t m_start;
			hk_size_t m_size;
		};

			/// From an (x,y) coordinate in screen space, returns the ordered block index underneath, or -1 if not over a block
		int pickOrderedBlockIndex(int x, int y);
			/// Get an ordered block
		const OrderedBlock& getOrderedBlock(int index) const { return m_orderedBlocks[index]; }


	protected:
		void setTexture( const hkColor::Argb* colorsIn, int numColors, int numRows);

		void _initGraphics(hkgDisplayContext* context, int width, int height);
		void _initSnapshot();
		int _findOrderedBlockIndex(hk_size_t addr) const;
		void _initBarChartTexture();
		void _initZoom();
		void _addToHistory();
		hk_size_t _calcMaxHistorySize() const;
		hk_size_t _calcMaxSize() const;
		int _getRowHeight( int row) const ;

		HK_FORCE_INLINE static hkBool HK_CALL _orderOrderedBlocks(const OrderedBlock& a, const OrderedBlock& b);


		hkInt32 m_displayWidth;
		hkInt32 m_displayHeight;
		hkInt32 m_displayLastX;
		hkInt32 m_displayLastY;
		
		hkInt32 m_startOffset[2];
		hkInt32 m_statWidthHeight[2];

		//hkUint32 m_alphaKeyColor; 
		hkgDisplayContext* m_context;
		hkgTexture* m_barChartTexture;
		hkgTexture* m_barChartSurroundTexture;
		hkgFont* m_statFont;
		
		// Color table for drawing the stats overlay
		///struct hkMonitorStreamColorTable* m_colorTable;
		//class hkResource* m_colorTablePackfileData; 

		hkArray< ZoomData > m_zoomData; // always has one element anyway 

		hkTrackerSnapshot m_trackerSnapshot;
		hkRefPtr<hkTrackerScanSnapshot> m_scanSnapshot;

		hkArray<OrderedBlock> m_orderedBlocks;

		hk_size_t m_maxSize;
		int m_historySize;
		// Storage of previous category information. 
		// Each row 
		hkArray<CategoryBlock> m_categoryHistory;

		hkReal m_updateTime;
};	

#endif // HKG_MEMORY_TRACKER_GRAPH_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
