/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#ifndef HKG_IMGUI_H
#define HKG_IMGUI_H

// Utilities for using ImGui with hkg

#include <Graphics/ImGui/ImGui.h>
#include <Graphics/ImGui/ImGuiContext.h>
#include <Graphics/ImGui/ImGuiPainter.h>
#include <Graphics/ImGui/ImGuiLayout.h>
#include <Graphics/ImGui/ImGuiWidget.h>

#include <Graphics/ImGui/FlatPainter/ImGuiFlatPainter.h>
#include <Graphics/Common/Window/hkgWindow.h>


class hkgDisplayContext;
class hkgFont;

namespace hkgImGui
{
	void sendInput( ImGui::Context& gui, const hkgWindow* window);

	struct Renderer : public ImGui::RenderMetrics
	{
		Renderer(hkgDisplayContext* context);
		~Renderer();

		virtual int getWindowHeight();
		virtual int getWindowWidth();
		virtual int getMaxCharWidth();
		virtual int getMaxCharHeight();
		virtual hkReal measureWidth( int c );

		void render(const ImGui::RenderBuffer& buffer);

		void _setClipRectIndex(int i, const ImGui::RenderBuffer& painter);
		void _renderTriangles(const ImGui::RenderBuffer& painter);
		void _renderLines(const ImGui::RenderBuffer& painter);
		void _renderText(const ImGui::RenderBuffer& painter);
		void _renderImages(const ImGui::RenderBuffer& painter);

		hkgDisplayContext* m_context;
		hkgFont* m_font;
		int m_winWidth;
		int m_winHeight;
	};

		/// This does the setup/teardown necessary for imgui to work with hkg
	struct BaseGui
	{
		struct Context : public ImGui::Context
		{
		};

		BaseGui(hkgWindow* window, Context& ctx )
			: m_context(ctx)
			, m_renderer(window->getContext())
			, m_painter(&m_renderer, m_buffer)
		{
			m_context.setPainter(&m_painter);

			m_painter.m_winHeight = window->getHeight();
			m_painter.m_winWidth = window->getWidth();

			hkgImGui::sendInput(ctx, window);
		}

		~BaseGui()
		{
			m_context.tick();
			m_renderer.render( m_buffer );
		}

		Context& m_context;
		Renderer m_renderer;
		ImGui::RenderBuffer m_buffer;
		ImGui::FlatPainter m_painter;
	};


		// Utility to do the usual gui setup with a notebook
	struct NotebookGui : public BaseGui
	{
		struct Context : public BaseGui::Context
		{
			ImGui::NotebookState m_notebookState;
		};

		NotebookGui(hkgWindow* window, Context& ctx, ImGui::Rectangle& guiRect )
			: BaseGui(window, ctx)
			, notebook(ctx, guiRect, ctx.m_notebookState)
		{
			ImGui::Pair mouse(window->getMouse().getPosX(), window->getHeight() - window->getMouse().getPosY());
			window->getCurrentViewport()->setAcceptsMouseEvents(!guiRect.contains(mouse));
		}

		ImGui::Widget::Notebook notebook;
	};
}

#endif // HKG_IMGUI_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
