/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#ifndef HK_GRAPHICS_GEOMETRY_CONVERTER_H
#define HK_GRAPHICS_GEOMETRY_CONVERTER_H

#include <Common/Base/Types/Geometry/hkGeometry.h>

class hkgGeometry;
class hkDisplaySphere;
class hkDisplayGeometry;
class hkgDisplayContext;
class hkgGeometryConverter
{
	public:
		static hkgGeometry* HK_CALL createGraphicsDisplay(hkDisplayGeometry* geom, hkgDisplayContext* context, hkTransform* texWTransform = HK_NULL, float textureMapScale = 1.0f, bool fixedTexcoords = false, hkGeometry::GeometryType geomType = hkGeometry::GEOMETRY_STATIC);

		
		static hkgGeometry* HK_CALL createSmoothGraphicsDisplay(hkGeometry* geom, hkgDisplayContext* context, hkTransform* texWTransform = HK_NULL, float textureMapScale = 1.0f, bool fixedTexcoords = false);


			// helpers
		static hkgGeometry* HK_CALL createGraphicsDisplay(const hkGeometry* geom, const hkTransform& transform, hkgDisplayContext* context, hkTransform* texWTransform = HK_NULL, float textureMapScale = 1.0f, bool fixedTexcoords = false, hkGeometry::GeometryType geometryType = hkGeometry::GEOMETRY_STATIC);
		static hkgGeometry* HK_CALL createGraphicsDisplay(const hkDisplaySphere* geom, hkgDisplayContext* context);

		static void HK_CALL computeBoxTextureCoords( hkVector4Parameter pos, hkVector4Parameter norm, hkSimdReal& u, hkSimdReal& v, hkSimdRealParameter textureMapScale);

};



#endif //  HK_GRAPHICS_GEOMETRY_CONVERTER_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
