/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#include <Demos/demos.h>

#	define HK_MAIN_CALL _cdecl

#ifndef HK_DYNAMIC_DLL
#include <Common/Base/keycode.cxx>
#endif

// Function to set up the platform
// The function is called twice:
// once before options have been parsed with null argument
// once after parsing with the parsed options structure.
extern void HK_CALL DemoPlatformInit(hkDemoFrameworkOptions* options);

extern int HK_CALL hkFrameworkMain(hkDemoFrameworkOptions& options, char* startUpGame);

#if defined( HK_ATOM )
extern "C" int __cdecl ADP_Close( void );
#endif


#ifndef HK_ANDROID_PLATFORM_8 // On Android-8 platform the application is controlled by Java code
//
// The entry point for our demos
// 

#if defined(HK_PLATFORM_WINRT)
int HK_CALL hkgMetroMainLine(int argc, char* argvIn[])
{
	int firstArg = 2;
#elif defined(HK_PLATFORM_CTR)
extern "C" void nnMain( void )
{
	int argc = 0;
	const char** argvIn = HK_NULL;
	int firstArg = 0;
#else
int HK_MAIN_CALL main(int argc, char** argvIn)
{
	int firstArg = 1;
#endif

	DemoPlatformInit(HK_NULL);

	const char** argv = (const char**)argvIn;

	hkDemoFrameworkOptions options;
	options.parse(argc, argv, firstArg);
	DemoPlatformInit(&options);

	// Start the demo framework
	int res = frameworkMain(options, "Menu");

#if defined( HK_ATOM )
	ADP_Close();
#endif
	return res;
}

#endif /* HK_ANDROID_PLATFORM_8 */

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
