/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/ShowCase/Animation/Statemachine/States/AnimStandState.h>

void AnimStandState::enterState( hkUint32 prevState, AnimationMachine* animMachine ) const
{
	AnimationMachine::AnimationCommand cmd;
	cmd.m_time = 0.0f; // immediately
	cmd.m_command = AnimationMachine::HK_EASE_IN;
	cmd.m_params.setEase.m_control = ANIM_IDLE_CONTROL;
	cmd.m_params.setEase.m_easeTime = 0.2f;
	animMachine->addCommand( cmd );
}

void AnimStandState::leaveState( hkUint32 nextState, AnimationMachine* animMachine ) const
{
	AnimationMachine::AnimationCommand cmd;
	cmd.m_time = 0.0f; // immediately
	cmd.m_command = AnimationMachine::HK_EASE_OUT;
	cmd.m_params.setEase.m_control = ANIM_IDLE_CONTROL;


	switch (nextState)
	{
	case ANIM_WALK_STATE:
	case ANIM_IN_AIR_STATE:
		{
			cmd.m_params.setEase.m_easeTime = 0.5f;
			break;
		}
	case ANIM_DYING_STATE:
		{
			cmd.m_params.setEase.m_easeTime = 0.05f;
			break;
		}
	default:
		{
			cmd.m_params.setEase.m_easeTime = 0.1f;
			break;
		}
	}

	animMachine->addCommand( cmd );
}

void AnimStandState::update( hkReal timestep, const AnimStateInput* input ) const
{

	if (!input->m_isSupported)
	{
		input->m_context->setCurrentState(ANIM_IN_AIR_STATE, input->m_animMachine);
	}
	else if (input->m_shouldWalk)
	{
		input->m_context->setCurrentState(ANIM_WALK_STATE, input->m_animMachine);
	}
	else if (input->m_shouldJump)
	{
		input->m_context->setCurrentState(ANIM_JUMP_STATE, input->m_animMachine);
	}
	else if (input->m_shouldDie)
	{
		input->m_context->setCurrentState(ANIM_DYING_STATE, input->m_animMachine);
	}
	else if (input->m_shouldDive)
	{
		input->m_context->setCurrentState(ANIM_DIVE_STATE, input->m_animMachine);
	}
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
