/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/ShowCase/Animation/Statemachine/States/AnimJumpState.h>

void AnimJumpState::enterState( hkUint32 prevState, AnimationMachine* animMachine ) const
{
	AnimationMachine::AnimationCommand cmd;
	cmd.m_time = 0.0f; // immediately

	cmd.m_command = AnimationMachine::HK_SET_PLAYBACK_SPEED;
	cmd.m_params.setSpeed.m_control = ANIM_JUMP_CONTROL;
	cmd.m_params.setSpeed.m_speed = 1.0f;
	animMachine->addCommand( cmd );

	cmd.m_command = AnimationMachine::HK_SET_LOCAL_TIME;
	cmd.m_params.setTime.m_control = ANIM_JUMP_CONTROL;
	cmd.m_params.setTime.m_localTime = 0.0f;
	animMachine->addCommand( cmd );

	cmd.m_command = AnimationMachine::HK_EASE_IN;
	cmd.m_params.setEase.m_control = ANIM_JUMP_CONTROL;
	cmd.m_params.setEase.m_easeTime = 0.1f;
	animMachine->addCommand( cmd );

	cmd.m_command = AnimationMachine::HK_SET_PLAYBACK_SPEED;
	cmd.m_time = 40.0f / 60.0f;	// Hold at peak of jump - this should be annotation driven (or similar)
	cmd.m_params.setSpeed.m_control = ANIM_JUMP_CONTROL;
	cmd.m_params.setSpeed.m_speed = 0.0f;
	animMachine->addCommand( cmd );
}

void AnimJumpState::leaveState( hkUint32 nextState, AnimationMachine* animMachine ) const
{
	AnimationMachine::AnimationCommand cmd;
	cmd.m_time = 0.0f; // immediately
	cmd.m_command = AnimationMachine::HK_EASE_OUT;
	cmd.m_params.setEase.m_control = ANIM_JUMP_CONTROL;
	switch (nextState)
	{
	case ANIM_IN_AIR_STATE:
		{
			cmd.m_params.setEase.m_easeTime = 0.5f;
			break;
		}
	default:
		{
			cmd.m_params.setEase.m_easeTime = 0.1f;
			break;
		}
	}
	animMachine->addCommand( cmd );
}

void AnimJumpState::update( hkReal timestep, const AnimStateInput* input ) const
{
	if (input->m_shouldDie)
	{
		input->m_context->setCurrentState(ANIM_DYING_STATE, input->m_animMachine);
	}

	const hkReal timeInState = input->m_context->getCurrentTime() - input->m_context->getLastStateChange();

	if (timeInState >= 40.0f / 60.0f - 0.2f)
	{
		input->m_context->setCurrentState(ANIM_IN_AIR_STATE, input->m_animMachine);
	}

}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
