/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/ShowCase/Animation/AnimationShowcase.h>

// Serialization
#include <Common/Base/Reflection/hkClass.h>
#include <Common/Serialize/Util/hkLoader.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Common/Base/Reflection/Registry/hkTypeInfoRegistry.h>
#include <Common/Serialize/Util/hkBuiltinTypeRegistry.h>

// Utilities
#include <Demos/DemoCommon/Utilities/Asset/hkAssetManagementUtil.h>
#include <Demos/DemoCommon/Utilities/Animation/AnimationUtils.h>

// Skeletal Animation
#include <Animation/Animation/hkaAnimationContainer.h>
#include <Animation/Animation/Rig/hkaSkeleton.h>
#include <Animation/Animation/Rig/hkaSkeletonUtils.h>
#include <Animation/Animation/Playback/hkaAnimatedSkeleton.h>
#include <Animation/Animation/Playback/Control/Default/hkaDefaultAnimationControl.h>
#include <Animation/Animation/Animation/hkaAnimationBinding.h>

// Vertex Deformation
#include <Animation/Animation/Deform/Skinning/hkaMeshBinding.h>

// Scene Data
#include <Common/SceneData/Scene/hkxScene.h>
#include <Common/SceneData/Mesh/hkxMesh.h>
#include <Common/SceneData/Mesh/hkxMeshSection.h>
#include <Common/SceneData/Mesh/hkxIndexBuffer.h>
#include <Common/SceneData/Mesh/hkxVertexBuffer.h>
#include <Animation/Animation/Rig/hkaPose.h>

// State Machine
#include <Demos/ShowCase/Animation/Statemachine/AnimState.h>
#include <Demos/ShowCase/Animation/Statemachine/AnimStateTypes.h>
#include <Demos/ShowCase/Animation/Statemachine/States/AnimStandState.h>
#include <Demos/ShowCase/Animation/Statemachine/States/AnimWalkState.h>
#include <Demos/ShowCase/Animation/Statemachine/States/AnimJumpState.h>
#include <Demos/ShowCase/Animation/Statemachine/States/AnimDiveState.h>
#include <Demos/ShowCase/Animation/Statemachine/States/AnimInAirState.h>
#include <Demos/ShowCase/Animation/Statemachine/States/AnimLandState.h>
#include <Demos/ShowCase/Animation/Statemachine/States/AnimDyingState.h>
#include <Demos/ShowCase/Animation/Statemachine/States/AnimDeadState.h>
#include <Demos/ShowCase/Animation/Statemachine/States/AnimGettingUpState.h>

// Graphics & Window Stuff
#include <Graphics/Bridge/SceneData/hkgSceneDataConverter.h>
#include <Graphics/Common/Window/hkgWindow.h>

void AnimationShowcase::initAnimation()
{
	// Initialize the state machine.
	m_stateManager = new AnimStateManager();
	{
		AnimState* state = new AnimStandState();
		m_stateManager->registerState (ANIM_STAND_STATE, state);
		state->removeReference();

		state = new AnimWalkState();
		m_stateManager->registerState (ANIM_WALK_STATE, state);
		state->removeReference();

		state = new AnimJumpState();
		m_stateManager->registerState (ANIM_JUMP_STATE, state);
		state->removeReference();

		state = new AnimInAirState();
		m_stateManager->registerState (ANIM_IN_AIR_STATE, state);
		state->removeReference();

		state = new AnimLandState();
		m_stateManager->registerState (ANIM_LAND_STATE, state);
		state->removeReference();

		state = new AnimDyingState();
		m_stateManager->registerState (ANIM_DYING_STATE, state);
		state->removeReference();

		state = new AnimDeadState();
		m_stateManager->registerState (ANIM_DEAD_STATE, state);
		state->removeReference();

		state = new AnimGettingUpState();
		m_stateManager->registerState (ANIM_GETTING_UP_STATE, state);
		state->removeReference();

		state = new AnimDiveState();
		m_stateManager->registerState (ANIM_DIVE_STATE, state);
		state->removeReference();
	}

	//Initialize the skeleton
	{

		// Get the rig
		{
			hkStringBuf assetFile(HK_GET_DEMOS_ASSET_FILENAME("Resources/Animation/ShowCase/Model/Firefighter_Rig.hkt")); hkAssetManagementUtil::getFilePath(assetFile);
			m_rigContainer = m_loader->load( assetFile.cString() );
			HK_ASSERT2(0x27343437, m_rigContainer != HK_NULL , "Could not load asset");
			hkaAnimationContainer* ac = reinterpret_cast<hkaAnimationContainer*>( m_rigContainer->findObjectByType( hkaAnimationContainerClass.getName() ));

			HK_ASSERT2(0x27343435, ac && (ac->m_skeletons.getSize() > 0), "No skeleton loaded");

			m_animatedSkeleton = new hkaAnimatedSkeleton( ac->m_skeletons[0] );

		}

		// Get the skin (different file)
		{
			hkStringBuf assetFile;
			if (m_bUseHardwareSkinning)
				hkAssetManagementUtil::getFilePath(HK_GET_DEMOS_ASSET_FILENAME("Resources/Animation/ShowCase/Model/Firefighter_PS2_18Bones_Skin.hkt"), assetFile);
			else
				hkAssetManagementUtil::getFilePath(HK_GET_DEMOS_ASSET_FILENAME("Resources/Animation/ShowCase/Model/Firefighter_Skin.hkt"), assetFile);

			hkRootLevelContainer* rootContainer = m_loader->load( assetFile.cString() );
			HK_ASSERT2(0x27343437, rootContainer != HK_NULL , "Could not load asset");
			hkaAnimationContainer* ac = reinterpret_cast<hkaAnimationContainer*>( rootContainer->findObjectByType( hkaAnimationContainerClass.getName() ));

			HK_ASSERT2(0x27343435, ac && (ac->m_skins.getSize() > 0), "No skins loaded");

			m_skinBindings = ac->m_skins;

			hkxScene* scene = reinterpret_cast<hkxScene*>( rootContainer->findObjectByType( hkxSceneClass.getName() ));
			HK_ASSERT2(0x27343435, scene , "No scene loaded");

			// Make graphics output buffers for the skins
			m_env->m_sceneConverter->setAllowHardwareSkinning(m_bUseHardwareSkinning);
			m_env->m_sceneConverter->convert( scene );

			if (m_bUseHardwareSkinning)
			{
				for (int ms=0; ms < m_skinBindings.getSize(); ++ms)
				{
					hkaMeshBinding* skinBinding = m_skinBindings[ms];

					if (! m_env->m_sceneConverter->setupHardwareSkin( m_env->m_window->getContext(), skinBinding->m_mesh,
						   reinterpret_cast<hkgAssetConverter::IndexMapping*>( skinBinding->m_mappings.begin() ),
						   skinBinding->m_mappings.getSize(), (hkInt16)skinBinding->m_skeleton->m_bones.getSize() ) )
					{
						HK_WARN(0x0, "Could not setup hardware skinning from given asset!");
					}
				}
			}
		}

		// Add animations in order
		{
			// ANIM_MOVE_CONTROL - A Dummy control
			hkaDefaultAnimationControl* control;

			// ANIM_WALK_CONTROL
			control = new hkaDefaultAnimationControl( HK_NULL );
			control->easeOut(0.0f);
			control->setMasterWeight(0.01f);
			m_animatedSkeleton->addAnimationControl( control );
			control->removeReference();

			// ANIM_IDLE_CONTROL
			control = AnimationUtils::loadControl( *m_loader, HK_GET_DEMOS_ASSET_FILENAME("Resources/Animation/ShowCase/Animations/hkIdle1.hkt") );
			m_animatedSkeleton->addAnimationControl( control );
			control->removeReference();

			// ANIM_JUMP_CONTROL
			control = AnimationUtils::loadControl( *m_loader, HK_GET_DEMOS_ASSET_FILENAME("Resources/Animation/ShowCase/Animations/hkRunJump.hkt") );
			m_animatedSkeleton->addAnimationControl( control );
			control->removeReference();

			// ANIM_IN_AIR_CONTROL
			control = AnimationUtils::loadControl( *m_loader, HK_GET_DEMOS_ASSET_FILENAME("Resources/Animation/ShowCase/Animations/hkInAir.hkt") );
			m_animatedSkeleton->addAnimationControl( control );
			control->removeReference();

			// ANIM_LAND_CONTROL
			control = AnimationUtils::loadControl( *m_loader, HK_GET_DEMOS_ASSET_FILENAME("Resources/Animation/ShowCase/Animations/hkHardLand.hkt") );
			m_animatedSkeleton->addAnimationControl( control );
			control->removeReference();

			// ANIM_DYING_CONTROL
			control = AnimationUtils::loadControl( *m_loader, HK_GET_DEMOS_ASSET_FILENAME("Resources/Animation/ShowCase/Animations/hkDie.hkt") );
			m_animatedSkeleton->addAnimationControl( control );
			control->removeReference();

			// ANIM_GET_UP_CONTROL
			control = AnimationUtils::loadControl( *m_loader, HK_GET_DEMOS_ASSET_FILENAME("Resources/Animation/ShowCase/Animations/hkKnockdown2.hkt") );
			m_animatedSkeleton->addAnimationControl( control );
			control->setPlaybackSpeed(0.0f);
			control->removeReference();

			// ANIM_WALK_CONTROL
			control = AnimationUtils::loadControl( *m_loader, HK_GET_DEMOS_ASSET_FILENAME("Resources/Animation/ShowCase/Animations/hkWalk.hkt") );
			control->setMasterWeight( 0.0f );
			control->easeIn( 0.0f );
			m_animatedSkeleton->addAnimationControl( control );
			control->removeReference();

			// ANIM_RUN_CONTROL
			control = AnimationUtils::loadControl( *m_loader, HK_GET_DEMOS_ASSET_FILENAME("Resources/Animation/ShowCase/Animations/hkRun.hkt") );
			// To sync with walk
			control->setLocalTime( 17.0f / 60.0f );
			control->setMasterWeight( 0.0f );
			control->easeIn( 0.0f );
			m_animatedSkeleton->addAnimationControl( control );
			control->removeReference();

			// ANIM_DIVE_CONTROL
			control = AnimationUtils::loadControl( *m_loader, HK_GET_DEMOS_ASSET_FILENAME("Resources/Animation/ShowCase/Animations/hkDive.hkt") );
			m_animatedSkeleton->addAnimationControl( control );
			control->removeReference();

		}

		// Initialize the animation command processor
		{
			m_animationMachine = new AnimationMachine(m_animatedSkeleton);
			m_animatedSkeleton->removeReference();
		}

		// Initialize the state machine
		{
			m_animationStateMachine = new AnimStateContext( m_stateManager );
			m_stateManager->removeReference();
			m_animationStateMachine->setCurrentState(ANIM_STAND_STATE, m_animationMachine );
		}

		// Add constraints to skeleton
		{
			hkaSkeleton* skeleton = const_cast<hkaSkeleton*>(m_animatedSkeleton->getSkeleton());

			// Lock translations (except root, named "position")
			hkaSkeletonUtils::lockTranslations(*skeleton);

			// and except also the children "reference" and "root"
			const hkInt16 referenceBoneIdx = hkaSkeletonUtils::findBoneWithName(*skeleton, "reference");
			const hkInt16 rootBoneIdx = hkaSkeletonUtils::findBoneWithName(*skeleton, "root");
			skeleton->m_bones[referenceBoneIdx].m_lockTranslation = false;
			skeleton->m_bones[rootBoneIdx].m_lockTranslation = false;

		}

	}
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
