/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//
// One or Two diffuse maps, along with a normal and specular map, with and without shadows. The most common demo shaders 
// with 'proper' assets. These will currently also allow loading of a gloss map, but will ignore it
//
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 NORMAL0 SPECULAR0
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP NORMAL0 SPECULAR0

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING

#include "CommonHeader.hlslh"
#include "CommonVertexShaders.hlslh"


// Pixel Shaders
pixelOutput PixT1Bump( vertexOutputT1B In )
{
	HKG_TEST_DEPTH_PEEL

	pixelOutput Output;

	clip( g_cDiffuseColor.a - ALPHA_DISCARD_TOLERANCE );

	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_NORMAL_MAP
	N = _sample0( In.texCoord0).xyz*2.0 - 1.0;
	N = normalize(N);
#endif

#if ENABLE_SPEC_MAP
	SpecMap *= _sample1( In.texCoord0).rgb;
#endif

	
	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;
	Output.color.rgb = negLight*g_cAmbientColor.rgb*g_cDiffuseColor.rgb + totalLight*g_cDiffuseColor.rgb + light0.www*SpecMap;
	Output.color.a = g_cDiffuseColor.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output; 
   
}

pixelOutput PixShadowSceneT1Bump( vertexOutputT1B In )
{
  	HKG_TEST_DEPTH_PEEL
 
    pixelOutput Output;

	clip( g_cDiffuseColor.a - ALPHA_DISCARD_TOLERANCE );

	float lightAmount = getLightAmountShadow( In.posView );
		
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
		
#if ENABLE_NORMAL_MAP
	N = _sample4(In.texCoord0).xyz*2.0 - 1.0;
	N = normalize(N);
#endif

#if ENABLE_SPEC_MAP
	SpecMap *= _sample5( In.texCoord0).rgb;
#endif

	
	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb + g_cAmbientColor.rgb;
	saturate(totalLight);
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*g_cDiffuseColor.rgb + lightAmount*( totalLight*g_cDiffuseColor.rgb + light0.www*SpecMap );
	Output.color.a = g_cDiffuseColor.a; // modulate alpha as is, shadow doesn't affect it.
	
     if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
