/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//
// One or Two diffuse maps, along with a normal and specular map, with and without shadows. The most common demo shaders 
// with 'proper' assets. These will currently also allow loading of a gloss map, but will ignore it
//
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 NORMAL0 SPECULAR0 DEFINE:TEX_COORD0
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP NORMAL0 SPECULAR0 DEFINE:TEX_COORD0

//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0

//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0
 
#pragma include(CommonHeader.glslh)
#pragma include(CommonVertexShaders.glslh)



// Pixel Shaders
#ifdef ENTRYPOINT_PixT1Bump
varying HIGHP vec2 VOutTexCoord0;

varying HIGHP vec3 VOutLightDir0TS;
varying HIGHP vec3 VOutLightDir1TS;
varying HIGHP vec3 VOutEyeDirTS;
varying HIGHP vec3 VOutPosView; 

void main()
{
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0.0,0.0,1.0); 
	
	N = texture2D(g_sSamplerZero, VOutTexCoord0.xy).xyz*2.0 - 1.0;
	N = normalize(N);

	SpecMap *= texture2D(g_sSamplerOne, VOutTexCoord0.xy).rgb;

	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, N, VOutLightDir0TS, VOutLightDir1TS, VOutEyeDirTS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb;
	totalLight = clamp(totalLight,0.0,1.0);
	vec3 negLight = vec3(1.0,1.0,1.0) - totalLight;

	gl_FragColor.rgb = negLight*g_cAmbientColor.rgb*g_cDiffuseColor.rgb + totalLight.rgb*g_cDiffuseColor.rgb + light0.www*SpecMap;
	gl_FragColor.a = g_cDiffuseColor.a; // modulate alpha as is, light doesn't affect it.
	
	COMPUTE_FOG
}
#endif

#ifdef ENTRYPOINT_PixShadowSceneT1Bump
varying HIGHP vec2 VOutTexCoord0;

varying HIGHP vec3 VOutLightDir0TS;
varying HIGHP vec3 VOutLightDir1TS;
varying HIGHP vec3 VOutEyeDirTS;
varying HIGHP vec3 VOutPosView; 
void main()
{
    float lightAmount = getLightAmountShadow( VOutPosView ); 
		
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0.0,0.0,1.0); 
		
	N = texture2D(g_sSamplerFour, VOutTexCoord0.xy).xyz*2.0 - 1.0;
	N = normalize(N);

	SpecMap *= texture2D(g_sSamplerFive, VOutTexCoord0.xy).rgb;

	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, N, VOutLightDir0TS, VOutLightDir1TS, VOutEyeDirTS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb;
	totalLight = clamp(totalLight,0.0,1.0);
	
	gl_FragColor.rgb = (1.0-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*g_cDiffuseColor.rgb + lightAmount*( totalLight*g_cDiffuseColor.rgb + light0.www*SpecMap );
	gl_FragColor.a = g_cDiffuseColor.a; // modulate alpha as is, shadow doesn't affect it.
	
	COMPUTE_FOG
}	

#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
