/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#version 120

attribute vec4 InPosition;  
attribute vec2 InTexCoord0;
attribute vec3 InNormal;
attribute vec3 InTangent;
attribute vec3 InBinormal;

varying vec2 VOutTexCoord0;
varying vec3 VOutTexCoord2;
varying vec3 VOutTexCoord3;

uniform vec3 g_vLightDir;

uniform mat4 g_mWorld;
uniform mat4 g_mWorldInv;
uniform mat4 g_mViewInv;
uniform mat4 g_mWorldViewProj;

void main()
{
	vec4 position = vec4(InPosition.xyz,1.0);
    vec3 normal = InNormal;

	// copy texture coordinates
    VOutTexCoord0 = InTexCoord0;
	
	// transform position to clip space
	gl_Position = g_mWorldViewProj * position;

	// compute the 3x3 tranform from object space to tangent space
	mat3 objToTangentSpace;
	
	float bumpHeight = 1.0;
		
	objToTangentSpace[0] = InTangent.xyz * bumpHeight;
	objToTangentSpace[1] = InBinormal.xyz * bumpHeight;
	objToTangentSpace[2] = normal;
	
    vec4 vertexPos = g_mWorld * position; // world space position

	// light vector
	vec3 lightVec =  mat3(g_mWorldInv) * g_vLightDir;  // transform back to object space
	VOutTexCoord2.xyz = lightVec * objToTangentSpace; // transform from object to tangent space
	
	// eye vector
	vec3 eyeVec = g_mViewInv[3].xyz - vertexPos.xyz; // world space eye vector
	eyeVec = mat3(g_mWorldInv) * eyeVec;  // transform back to object space
	eyeVec = normalize(eyeVec);
	
	// half-angle vector
	vec3 H = normalize(lightVec + eyeVec);
	VOutTexCoord3.xyz = H * objToTangentSpace;	// transform to tangent space
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
