/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixT1 LD0 T1 DIFFUSE0 DEFINE:TEX_COORD0
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD0 T1 SHADOWMAP DIFFUSE0 DEFINE:TEX_COORD0
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixT1 LD0 T1 DIFFUSE0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD0 T1 SHADOWMAP DIFFUSE0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixT1 LD0 T1 DIFFUSE0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD0 T1 SHADOWMAP DIFFUSE0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0

//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixT1 LD0 T1 DIFFUSE0 OPACITY0 DEFINE:TEX_COORD0 DEFINE:OPACITY_MAP
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD0 T1 SHADOWMAP DIFFUSE0 OPACITY0 DEFINE:TEX_COORD0 DEFINE:OPACITY_MAP
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixT1 LD0 T1 DIFFUSE0 OPACITY0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:OPACITY_MAP
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD0 T1 SHADOWMAP DIFFUSE0 OPACITY0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:OPACITY_MAP
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixT1 LD0 T1 DIFFUSE0 OPACITY0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:OPACITY_MAP
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD0 T1 SHADOWMAP DIFFUSE0 OPACITY0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:OPACITY_MAP

//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixT1 LD* T1 EMISSIVE0 DEFINE:TEX_COORD0 DEFINE:EMIT_ONLY
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP EMISSIVE0 DEFINE:TEX_COORD0 DEFINE:EMIT_ONLY
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixT1 LD* T1 EMISSIVE0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:EMIT_ONLY
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP EMISSIVE0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:EMIT_ONLY
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixT1 LD* T1 EMISSIVE0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:EMIT_ONLY
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP EMISSIVE0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:EMIT_ONLY

//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixT1 LD* T1 EMISSIVE0 OPACITY0 DEFINE:TEX_COORD0 DEFINE:EMIT_ONLY DEFINE:OPACITY_MAP
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP EMISSIVE0 OPACITY0 DEFINE:TEX_COORD0 DEFINE:EMIT_ONLY DEFINE:OPACITY_MAP
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixT1 LD* T1 EMISSIVE0 OPACITY0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:EMIT_ONLY DEFINE:OPACITY_MAP
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP EMISSIVE0 OPACITY0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:EMIT_ONLY DEFINE:OPACITY_MAP
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixT1 LD* T1 EMISSIVE0 OPACITY0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:EMIT_ONLY DEFINE:OPACITY_MAP
//:STYLE VertNoLight HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP EMISSIVE0 OPACITY0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:EMIT_ONLY DEFINE:OPACITY_MAP

 
#pragma include(CommonHeader.glslh)
#pragma include(CommonVertexShaders.glslh)


#ifdef ENTRYPOINT_PixShadowSceneT1
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec3 VOutPosView;
void main()
{
	#ifndef EMIT_ONLY
		float lightAmount = getLightAmountShadow( VOutPosView ); 
	#else
		float lightAmount = 1.0;
	#endif
	
    vec4 texel = texture2D( g_sSamplerFour, VOutTexCoord0.xy );
    gl_FragColor.rgb = texel.rgb * lightAmount ; // modulate rgb wrt shadow.
    gl_FragColor.a = texel.a; // set alpha as is, shadow doesn't affect it.
	
	COMPUTE_FOG
}
#endif

#ifdef ENTRYPOINT_PixT1
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec3 VOutPosView;
void main()
{ 
    gl_FragColor = texture2D(g_sSamplerZero, VOutTexCoord0.xy); 
	
	COMPUTE_FOG
}
#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
