/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//
// One or Two diffuse maps, along with a normal and specular map, with and without shadows. The most common demo shaders 
// with 'proper' assets. These will currently also allow loading of a gloss map, but will ignore it
//

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Trans LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 OPACITY0
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Trans LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 OPACITY0

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Trans LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 OPACITY0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Trans LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 OPACITY0 SKINNED DEFINE:HKG_SKINNING

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Trans LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 OPACITY0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Trans LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 OPACITY0 INSTANCED DEFINE:HKG_INSTANCING

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Trans LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 SPECULAR0 OPACITY0 DEFINE:USE_SPEC_MAP2
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Trans LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 SPECULAR0 OPACITY0 DEFINE:USE_SPEC_MAP2

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Trans LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 SPECULAR0 OPACITY0 SKINNED DEFINE:HKG_SKINNING DEFINE:USE_SPEC_MAP2
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Trans LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 SPECULAR0 OPACITY0 SKINNED DEFINE:HKG_SKINNING DEFINE:USE_SPEC_MAP2

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Trans LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 SPECULAR0 OPACITY0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:USE_SPEC_MAP2
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Trans LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 SPECULAR0 OPACITY0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:USE_SPEC_MAP2

#include "CommonHeader.hlslh"
#include "CommonVertexShaders.hlslh"

pixelOutput PixT1Trans( vertexOutputT1B In )
{
	HKG_TEST_DEPTH_PEEL

	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample0(In.texCoord0);
#endif
		
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample1(In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample1(In.texCoord0);
	#endif
#endif

#if ENABLE_SPEC_MAP
	SpecMap *= _sample2(In.texCoord0).rgb;
	#ifdef USE_SPEC_MAP2
		SpecMap *= _sample3(In.texCoord0).rgb;
	#endif
#endif

	ColorMap *= g_cDiffuseColor;
	
	float4 OpacityMap = _sample4(In.texCoord0);
	float Opacity = OpacityMap.r; //((OpacityMap.r + OpacityMap.g + OpacityMap.b) / 3);
	clip( Opacity*ColorMap.a - ALPHA_DISCARD_TOLERANCE );
	
	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;
	
	pixelOutput Output;
	Output.color.rgb = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*SpecMap;
	Output.color.a = Opacity * ColorMap.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;
    
	return Output; 
}


pixelOutput PixShadowSceneT1Trans( vertexOutputT1B In )
{
   	HKG_TEST_DEPTH_PEEL

 	pixelOutput Output;
    
	float lightAmount = getLightAmountShadow( In.posView );

		
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample4(In.texCoord0);
#endif
		
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample5(In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample5(In.texCoord0);
	#endif
#endif

#if ENABLE_SPEC_MAP && !defined(HKG_DEPTH_PEEL)
	SpecMap *= _sample6(In.texCoord0).rgb;
	#ifdef USE_SPEC_MAP2
		SpecMap *= _sample7(In.texCoord0).rgb;
	#endif
#endif

	ColorMap *= g_cDiffuseColor;
	#if defined(USE_SPEC_MAP2) || defined(HKG_DEPTH_PEEL)
		float4 OpacityMap = float4(0,0,0,1);
	#else
		float4 OpacityMap = _sample7(In.texCoord0);
	#endif
	float Opacity = OpacityMap.r; //((OpacityMap.r + OpacityMap.g + OpacityMap.b) / 3);
	clip( Opacity*ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);

	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap.rgb );	
	Output.color.a = Opacity * ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

     return Output;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
