/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//
// One or Two diffuse maps, along with a normal and specular map, with and without shadows. The most common demo shaders 
// with 'proper' assets. These will currently also allow loading of a gloss map, but will ignore it
// 

//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1ReflectNoDiff LD* T1 REFLECTION NORMAL0 SPECULAR0 DEFINE:HKG_CUBEMAP_SLOT0 DEFINE:_PT1ReflectNoDiff
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1ReflectNoDiff LD* T1 SHADOWMAP REFLECTION NORMAL0 SPECULAR0 DEFINE:HKG_CUBEMAP_SLOT4 DEFINE:_PShadowSceneT1ReflectNoDiff
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1ReflectNoDiffNoSpec LD* T1 REFLECTION NORMAL0 DEFINE:HKG_CUBEMAP_SLOT0 DEFINE:_PT1ReflectNoDiffNoSpec
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1ReflectNoDiffNoSpec LD* T1 SHADOWMAP REFLECTION NORMAL0 DEFINE:HKG_CUBEMAP_SLOT4 DEFINE:_PShadowSceneT1ReflectNoDiffNoSpec
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1ReflectNoSpec LD* T1 DIFFUSE0 REFLECTION NORMAL0 DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:_PT1ReflectNoSpec
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1ReflectNoSpec LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:_PShadowSceneT1ReflectNoSpec
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:_PT1Reflect
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:_PShadowSceneT1Reflect
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1ReflectMask LD* T1 DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 DEFINE:HKG_CUBEMAP_SLOT2 DEFINE:_PT1ReflectMask
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1ReflectMask LD* T1 SHADOWMAP DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 DEFINE:HKG_CUBEMAP_SLOT6 DEFINE:_PShadowSceneT1ReflectMask
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT2ReflectMask LD* T2 DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 DEFINE:HKG_CUBEMAP_SLOT2 DEFINE:_PT2ReflectMask DEFINE:TWO_TCOORDS
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT2ReflectMask LD* T2 SHADOWMAP DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 DEFINE:HKG_CUBEMAP_SLOT6 DEFINE:_PShadowSceneT2ReflectMask DEFINE:TWO_TCOORDS

//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1ReflectNoDiff LD* T1 REFLECTION NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_CUBEMAP_SLOT0 DEFINE:_PT1ReflectNoDiff DEFINE:HKG_SKINNING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1ReflectNoDiff LD* T1 SHADOWMAP REFLECTION NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_CUBEMAP_SLOT4 DEFINE:_PShadowSceneT1ReflectNoDiff DEFINE:HKG_SKINNING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1ReflectNoDiffNoSpec LD* T1 REFLECTION NORMAL0 SKINNED DEFINE:HKG_CUBEMAP_SLOT0 DEFINE:_PT1ReflectNoDiffNoSpec DEFINE:HKG_SKINNING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1ReflectNoDiffNoSpec LD* T1 SHADOWMAP REFLECTION NORMAL0 SKINNED DEFINE:HKG_CUBEMAP_SLOT4 DEFINE:_PShadowSceneT1ReflectNoDiffNoSpec DEFINE:HKG_SKINNING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1ReflectNoSpec LD* T1 DIFFUSE0 REFLECTION NORMAL0 SKINNED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:_PT1ReflectNoSpec DEFINE:HKG_SKINNING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1ReflectNoSpec LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SKINNED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:_PShadowSceneT1ReflectNoSpec DEFINE:HKG_SKINNING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:_PT1Reflect DEFINE:HKG_SKINNING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:_PShadowSceneT1Reflect DEFINE:HKG_SKINNING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1ReflectMask LD* T1 DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_CUBEMAP_SLOT2 DEFINE:_PT1ReflectMask DEFINE:HKG_SKINNING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1ReflectMask LD* T1 SHADOWMAP DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_CUBEMAP_SLOT6 DEFINE:_PShadowSceneT1ReflectMask DEFINE:HKG_SKINNING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT2ReflectMask LD* T2 DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_CUBEMAP_SLOT2 DEFINE:_PT2ReflectMask DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT2ReflectMask LD* T2 SHADOWMAP DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_CUBEMAP_SLOT6 DEFINE:_PShadowSceneT2ReflectMask DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS


//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1ReflectNoDiff LD* T1 REFLECTION NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT0 DEFINE:_PT1ReflectNoDiff DEFINE:HKG_INSTANCING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1ReflectNoDiff LD* T1 SHADOWMAP REFLECTION NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT4 DEFINE:_PShadowSceneT1ReflectNoDiff DEFINE:HKG_INSTANCING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1ReflectNoDiffNoSpec LD* T1 REFLECTION NORMAL0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT0 DEFINE:_PT1ReflectNoDiffNoSpec DEFINE:HKG_INSTANCING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1ReflectNoDiffNoSpec LD* T1 SHADOWMAP REFLECTION NORMAL0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT4 DEFINE:_PShadowSceneT1ReflectNoDiffNoSpec DEFINE:HKG_INSTANCING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1ReflectNoSpec LD* T1 DIFFUSE0 REFLECTION NORMAL0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:_PT1ReflectNoSpec DEFINE:HKG_INSTANCING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1ReflectNoSpec LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:_PShadowSceneT1ReflectNoSpec DEFINE:HKG_INSTANCING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:_PT1Reflect DEFINE:HKG_INSTANCING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:_PShadowSceneT1Reflect DEFINE:HKG_INSTANCING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1ReflectMask LD* T1 DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT2 DEFINE:_PT1ReflectMask DEFINE:HKG_INSTANCING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1ReflectMask LD* T1 SHADOWMAP DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT6 DEFINE:_PShadowSceneT1ReflectMask DEFINE:HKG_INSTANCING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT2ReflectMask LD* T2 DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT2 DEFINE:_PT2ReflectMask DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT2ReflectMask LD* T2 SHADOWMAP DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT6 DEFINE:_PShadowSceneT2ReflectMask DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS

//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 INSTANCED SKINNED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:_PT1Reflect DEFINE:HKG_INSTANCING DEFINE:HKG_SKINNING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 INSTANCED SKINNED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:_PShadowSceneT1Reflect DEFINE:HKG_INSTANCING DEFINE:HKG_SKINNING

//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 IRRADIANCE SKINNED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:_PT1Reflect DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 IRRADIANCE SKINNED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:_PShadowSceneT1Reflect DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 IRRADIANCE RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:_PT1Reflect DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 IRRADIANCE RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:_PShadowSceneT1Reflect DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 IRRADIANCE INSTANCED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:_PT1Reflect DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 IRRADIANCE INSTANCED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:_PShadowSceneT1Reflect DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 IRRADIANCE INSTANCED SKINNED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:_PT1Reflect DEFINE:HKG_INSTANCING DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 IRRADIANCE INSTANCED SKINNED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:_PShadowSceneT1Reflect DEFINE:HKG_INSTANCING DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 IRRADIANCE INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:_PT1Reflect DEFINE:HKG_INSTANCING DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 IRRADIANCE INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:_PShadowSceneT1Reflect DEFINE:HKG_INSTANCING DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS

#include "CommonHeader.hlslh"
#include "CommonVertexShaders.hlslh"

// Pixel Shaders

#ifdef _PT1Reflect
#	ifdef HKG_IRRADIANCE_MAPS
pixelOutput PixT1Reflect( vertexOutputT1BDim In )
#	else
pixelOutput PixT1Reflect( vertexOutputT1BR In )
#	endif
{
 	HKG_TEST_DEPTH_PEEL
	
	pixelOutput Output;

	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
	ColorMap = _sample0( In.texCoord0);
#endif
	
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample2(In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample2(In.texCoord0);
	#endif
#endif

	float3x3 mTangentToWorld 	= float3x3(In.tangToWorld0.xyz, In.tangToWorld1.xyz, In.tangToWorld2.xyz);
	float3 vNormalWorld 		= normalize(mul( mTangentToWorld, N));
	float3 vView	 			= normalize(float3(In.tangToWorld0.w, In.tangToWorld1.w, In.tangToWorld2.w));
	
	float fNdotV 				= saturate(dot(vNormalWorld, vView));
	float3 vReflection 			= 2 * vNormalWorld * fNdotV - vView;
	float3x3 rotWorldToEnv 		= (float3x3)g_mWorldToEnv;
	float3 envReflection  		= mul(vReflection, rotWorldToEnv);
	float4 ReflectionMap 		= _cubeSample1(envReflection); 

#if ENABLE_SPEC_MAP
	SpecMap *= _sample3(In.texCoord0).rgb;
#endif

	ColorMap.rgb += SpecMap.rgb * ReflectionMap.rgb;  
	ColorMap *= g_cDiffuseColor;

	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );
	
	float3 litColor;
#ifdef HKG_IRRADIANCE_MAPS
	{
		float3 shadowedColor;
		LightPixelWithCubeMap(ColorMap, SpecMap, vNormalWorld, vView, shadowedColor, litColor);
	}
#else
	{
		float4 light0 = 1;
		float3 light1 = 0;
	#if ENABLE_LIGHTING
		LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
	#endif
	
		float3 totalLight = light0.rgb + light1.rgb + g_cAmbientColor.rgb;
		saturate(totalLight);
		litColor = totalLight*ColorMap.rgb + light0.www*SpecMap.rgb;
	}
#endif
	
	Output.color.rgb = litColor;
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.

	//Output.color.rgb = ColorMap.rgb;

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
	
	if ( getColorRangeCorrectionEnabled() )
	{
		Output.color.rgb *= getExposurePow2();
		Output.color.rgb = pow(Output.color.rgb, getInvGamma() ); 
	}
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}
#endif

#ifdef _PT1ReflectNoSpec
pixelOutput PixT1ReflectNoSpec( vertexOutputT1BR In )
{
 	HKG_TEST_DEPTH_PEEL

	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample0(In.texCoord0);
#endif
	
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample2(In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample2(In.texCoord0);
	#endif
#endif

	float3 worldEyeVec = float3( -In.tangToWorld0.w, -In.tangToWorld1.w, -In.tangToWorld2.w ); 
	float3 worldNormal = float3( dot(In.tangToWorld0.xyz, N), dot(In.tangToWorld1.xyz, N), dot(In.tangToWorld2.xyz, N) );
	float3 reflVect = reflect( worldEyeVec, worldNormal ); 
	
	float4 ReflectionMap = _cubeSample1( reflVect ); 

	ColorMap.rgb = ColorMap.rgb * ReflectionMap.rgb;  

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );
	
	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
		
	pixelOutput Output;
	float3 totalLight = light0.rgb + light1.rgb + g_cAmbientColor.rgb;
	saturate(totalLight);
	
	Output.color.rgb = totalLight*ColorMap.rgb + light0.www*SpecMap.rgb;
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.

	//Output.color.rgb = ReflectionMap.rgb;

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}
#endif

#ifdef _PT1ReflectNoDiff
pixelOutput PixT1ReflectNoDiff( vertexOutputT1BR In )
{
 	HKG_TEST_DEPTH_PEEL

	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample1(In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _cubeSample1(In.texCoord0);
	#endif
#endif

	float3 worldEyeVec = float3( -In.tangToWorld0.w, -In.tangToWorld1.w, -In.tangToWorld2.w ); 
	float3 worldNormal = float3( dot(In.tangToWorld0.xyz, N), dot(In.tangToWorld1.xyz, N), dot(In.tangToWorld2.xyz, N) );
	float3 reflVect = reflect( worldEyeVec, worldNormal ); 
	
	float4 ReflectionMap = _cubeSample0(reflVect); 

	ColorMap.rgb = ColorMap.rgb * ReflectionMap.rgb;  

#if ENABLE_SPEC_MAP
	SpecMap *= _sample2(In.texCoord0).rgb;
#endif

	ColorMap *= g_cDiffuseColor;
		clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
		
	pixelOutput Output;
	float3 totalLight = light0.rgb + light1.rgb + g_cAmbientColor.rgb;
	saturate(totalLight);
	
	Output.color.rgb = totalLight*ColorMap.rgb + light0.www*SpecMap.rgb;
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}
#endif

#ifdef _PT1ReflectNoDiffNoSpec
pixelOutput PixT1ReflectNoDiffNoSpec( vertexOutputT1BR In )
{
 	HKG_TEST_DEPTH_PEEL

	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample1(In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample1(In.texCoord0);
	#endif
#endif

	float3 worldEyeVec = float3( -In.tangToWorld0.w, -In.tangToWorld1.w, -In.tangToWorld2.w ); 
	float3 worldNormal = float3( dot(In.tangToWorld0.xyz, N), dot(In.tangToWorld1.xyz, N), dot(In.tangToWorld2.xyz, N) );
	float3 reflVect = reflect( worldEyeVec, worldNormal ); 
	
	float4 ReflectionMap = _cubeSample0(reflVect); 

	ColorMap.rgb = ColorMap.rgb * ReflectionMap.rgb;  
	ColorMap *= g_cDiffuseColor;
		clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
		
	pixelOutput Output;
	float3 totalLight = light0.rgb + light1.rgb + g_cAmbientColor.rgb;
	saturate(totalLight);
	
	Output.color.rgb = totalLight*ColorMap.rgb + light0.www*SpecMap.rgb;
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}
#endif

#ifdef _PT1ReflectMask
pixelOutput PixT1ReflectMask( vertexOutputT1BR In )
{
 	HKG_TEST_DEPTH_PEEL

	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample0(In.texCoord0);
#endif

#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample3(In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample3(In.texCoord0);
	#endif
#endif

	float3 worldEyeVec = float3( -In.tangToWorld0.w, -In.tangToWorld1.w, -In.tangToWorld2.w ); 
	float3 worldNormal = float3( dot(In.tangToWorld0.xyz, N), dot(In.tangToWorld1.xyz, N), dot(In.tangToWorld2.xyz, N) );
	float3 reflVect = reflect( worldEyeVec, worldNormal ); 
	
	float4 ReflectionMap = _cubeSample2(reflVect); 

	float4 ReflectionMask = _sample1(In.texCoord0); 

	ColorMap.rgb = (1-ReflectionMask.rgb)*ColorMap.rgb + ReflectionMask.rgb*ReflectionMap.rgb*ColorMap.rgb;  
		


#if ENABLE_SPEC_MAP
	SpecMap *= _sample4(In.texCoord0).rgb;
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	pixelOutput Output;
	float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	saturate(totalLight);

	Output.color.rgb = totalLight*ColorMap.rgb + light0.www*SpecMap.rgb;
	
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	 if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
	Output.pzDepth.a = Output.color.a;

    return Output; 
}
#endif

#ifdef _PT2ReflectMask
pixelOutput PixT2ReflectMask( vertexOutputT2BR In )
{
 	HKG_TEST_DEPTH_PEEL

	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample0(In.texCoord01.xy);
#endif
	
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample3(In.texCoord01.xy).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample3(In.texCoord01.xy);
	#endif
#endif

	
	float3 worldEyeVec = float3( -In.tangToWorld0.w, -In.tangToWorld1.w, -In.tangToWorld2.w ); 
	float3 worldNormal = float3( dot(In.tangToWorld0.xyz, N), dot(In.tangToWorld1.xyz, N), dot(In.tangToWorld2.xyz, N) );
	float3 reflVect = reflect( worldEyeVec, worldNormal ); 

	float4 ReflectionMap = _cubeSample2(reflVect); 

	float4 ReflectionMask = _sample1(In.texCoord01.zw); 
	ColorMap.rgb = (1-ReflectionMask.rgb)*ColorMap.rgb + ReflectionMask.rgb*ReflectionMap.rgb*ColorMap.rgb;  

#if ENABLE_SPEC_MAP
	SpecMap *= _sample4(In.texCoord01.xy).rgb;
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	pixelOutput Output;
	float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	saturate(totalLight);
	Output.color.rgb = totalLight*ColorMap.rgb + light0.www*SpecMap.rgb;
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}
#endif

#ifdef _PShadowSceneT1Reflect
#ifdef HKG_IRRADIANCE_MAPS
pixelOutput PixShadowSceneT1Reflect( vertexOutputT1BDim In )
#else
pixelOutput PixShadowSceneT1Reflect( vertexOutputT1BR In )
#endif
{
  	HKG_TEST_DEPTH_PEEL

	pixelOutput Output;
    
	float lightAmount = getLightAmountShadow( In.posView );
	
		
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample4( In.texCoord0);
#endif
		
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample6( In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample6(In.texCoord0);
	#endif
#endif

	float3x3 mTangentToWorld 	= float3x3(In.tangToWorld0.xyz, In.tangToWorld1.xyz, In.tangToWorld2.xyz);
	float3 vNormalWorld 		= normalize(mul( mTangentToWorld, N));
	float3 vView	 			= normalize(float3(In.tangToWorld0.w, In.tangToWorld1.w, In.tangToWorld2.w));
	
	float fNdotV 				= saturate(dot(vNormalWorld, vView));
	float3 vReflection 			= 2 * vNormalWorld * fNdotV - vView;
	float3x3 rotWorldToEnv 		= (float3x3)g_mWorldToEnv;
	float3 envReflection  		= mul(vReflection, rotWorldToEnv);

	float4 ReflectionMap 		= _cubeSample5(envReflection); 


#if ENABLE_SPEC_MAP && !defined(HKG_DEPTH_PEEL)
	SpecMap *= _sample7(In.texCoord0).rgb;
#endif

	ColorMap.rgb += SpecMap.rgb * ReflectionMap.rgb;  

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );
	
	float3 shadowedColor, litColor;
#ifdef HKG_IRRADIANCE_MAPS
	{
		LightPixelWithCubeMap(ColorMap, SpecMap, vNormalWorld, vView, shadowedColor, litColor);
	}
#else
	{
		float4 light0 = 1;
		float3 light1 = 0;
	#if ENABLE_LIGHTING
		LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
	#endif
		
		float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
		saturate(totalLight);
		
		shadowedColor	= (light1.rgb + g_cAmbientColor.rgb) * ColorMap.rgb;
		litColor		= totalLight * ColorMap.rgb + light0.www * SpecMap.rgb;
	}
#endif
	
	Output.color.rgb = (1 - lightAmount) * shadowedColor + lightAmount * litColor;
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
	
	if ( getColorRangeCorrectionEnabled() )
	{
		Output.color.rgb *= getExposurePow2();
		Output.color.rgb = pow(Output.color.rgb, getInvGamma() ); 
	}
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}
#endif

#ifdef _PShadowSceneT1ReflectNoSpec
pixelOutput PixShadowSceneT1ReflectNoSpec( vertexOutputT1BR In )
{
 	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;
	
float lightAmount = getLightAmountShadow( In.posView );
	
		
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample4(In.texCoord0);
#endif
		
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample6(In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample6(In.texCoord0);
	#endif
#endif

	float3 worldEyeVec = float3( -In.tangToWorld0.w, -In.tangToWorld1.w, -In.tangToWorld2.w ); 
	float3 worldNormal = float3( dot(In.tangToWorld0.xyz, N), dot(In.tangToWorld1.xyz, N), dot(In.tangToWorld2.xyz, N) );
	float3 reflVect = reflect( worldEyeVec, worldNormal ); 

	float4 ReflectionMap = _cubeSample5( reflVect); 

	ColorMap.rgb = ColorMap.rgb * ReflectionMap.rgb;  
	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	saturate(totalLight);
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap.rgb );
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
     if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}
#endif

#ifdef _PShadowSceneT1ReflectNoDiff
pixelOutput PixShadowSceneT1ReflectNoDiff( vertexOutputT1BR In )
{
 	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;
    
float lightAmount = getLightAmountShadow( In.posView );
	
		
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
			
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample5(In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample5(In.texCoord0);
	#endif
#endif

	float3 worldEyeVec = float3( -In.tangToWorld0.w, -In.tangToWorld1.w, -In.tangToWorld2.w ); 
	float3 worldNormal = float3( dot(In.tangToWorld0.xyz, N), dot(In.tangToWorld1.xyz, N), dot(In.tangToWorld2.xyz, N) );
	float3 reflVect = reflect( worldEyeVec, worldNormal ); 

	float4 ReflectionMap = _cubeSample4( reflVect); 

	ColorMap.rgb = ColorMap.rgb * ReflectionMap.rgb;  

#if ENABLE_SPEC_MAP
	SpecMap *= _sample5(In.texCoord0).rgb;
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );
	
	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	saturate(totalLight);
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap.rgb );
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
     if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}
#endif

#ifdef _PShadowSceneT1ReflectNoDiffNoSpec
pixelOutput PixShadowSceneT1ReflectNoDiffNoSpec( vertexOutputT1BR In )
{
 	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;
    
float lightAmount = getLightAmountShadow( In.posView );
	
		
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
			
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample5(In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample5(In.texCoord0);
	#endif
#endif

	float3 worldEyeVec = float3( -In.tangToWorld0.w, -In.tangToWorld1.w, -In.tangToWorld2.w ); 
	float3 worldNormal = float3( dot(In.tangToWorld0.xyz, N), dot(In.tangToWorld1.xyz, N), dot(In.tangToWorld2.xyz, N) );
	float3 reflVect = reflect( worldEyeVec, worldNormal ); 

	float4 ReflectionMap = _cubeSample4( reflVect); 

	ColorMap.rgb = ColorMap.rgb * ReflectionMap.rgb;  
	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	saturate(totalLight);
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap.rgb );
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
     if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}
#endif

#ifdef _PShadowSceneT1ReflectMask
pixelOutput PixShadowSceneT1ReflectMask( vertexOutputT1BR In )
{
 	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;
    
	float lightAmount = getLightAmountShadow( In.posView );
	
		
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample4(In.texCoord0);
#endif
	
#if ENABLE_NORMAL_MAP  && !defined(HKG_DEPTH_PEEL)
	#if ENABLE_LIGHTING
		N = _sample7(In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample7(In.texCoord0);
	#endif
#endif	
		
	float3 worldEyeVec = float3( -In.tangToWorld0.w, -In.tangToWorld1.w, -In.tangToWorld2.w ); 
	float3 worldNormal = float3( dot(In.tangToWorld0.xyz, N), dot(In.tangToWorld1.xyz, N), dot(In.tangToWorld2.xyz, N) );
	float3 reflVect = reflect( worldEyeVec, worldNormal ); 

	float4 ReflectionMap = _cubeSample6( reflVect); 

	float4 ReflectionMask = _sample5( In.texCoord0);
	ColorMap.rgb = ( (float3(1,1,1)-ReflectionMask.rgb) + ReflectionMask.rgb*ReflectionMap.rgb )*ColorMap.rgb;  

#if ENABLE_SPEC_MAP
	//XXX g_sSamplerEight..
	SpecMap *= _sample5(In.texCoord0).rgb;
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	saturate(totalLight);
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap.rgb );
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
	   if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}
#endif


#ifdef _PShadowSceneT2ReflectMask
pixelOutput PixShadowSceneT2ReflectMask( vertexOutputT2BR In )
{
 	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;
float lightAmount = getLightAmountShadow( In.posView );
	
		
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
	float2 tc0 = In.texCoord01.xy;
	float2 tc1 = In.texCoord01.zw;
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample4(tc0);
#endif
		
#if ENABLE_NORMAL_MAP && !defined(HKG_DEPTH_PEEL)
	#if ENABLE_LIGHTING
		N = _sample7(tc0).xyz*2.0 - 1.0;
		N = normalize(N);
	#else
		ColorMap = _sample7(tc0);
	#endif
#endif

	float3 worldEyeVec = float3( -In.tangToWorld0.w, -In.tangToWorld1.w, -In.tangToWorld2.w ); 
	float3 worldNormal = float3( dot(In.tangToWorld0.xyz, N), dot(In.tangToWorld1.xyz, N), dot(In.tangToWorld2.xyz, N) );
	float3 reflVect = reflect( worldEyeVec, worldNormal ); 

	float4 ReflectionMap = _cubeSample6( reflVect); 

	float4 ReflectionMask = _sample5(tc1);
	ColorMap.rgb = (1-ReflectionMask.rgb)*ColorMap.rgb + ReflectionMask.rgb*ReflectionMap.rgb*ColorMap.rgb;  
	

#if ENABLE_SPEC_MAP
	//XX
	SpecMap *= _sample5(tc0).rgb;
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );


	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	saturate(totalLight);
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap.rgb );

	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.


    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
