/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//
// One or Two diffuse maps, along with a normal and specular map, with and without shadows. The most common demo shaders 
// with 'proper' assets. These will currently also allow loading of a gloss map, but will ignore it
//
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 DEFINE:TEX_COORD0 DEFINE:HKG_CUBEMAP_SLOT1
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 DEFINE:TEX_COORD0 DEFINE:USE_SHADOWS DEFINE:HKG_CUBEMAP_SLOT5
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1ReflectMask LD* T1 DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 DEFINE:TEX_COORD0 DEFINE:HKG_CUBEMAP_SLOT2
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1ReflectMask LD* T1 SHADOWMAP DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 DEFINE:TEX_COORD0 DEFINE:USE_SHADOWS DEFINE:HKG_CUBEMAP_SLOT6
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT2ReflectMask LD* T2 DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 DEFINE:TEX_COORD0 DEFINE:TEX_COORD1 DEFINE:HKG_CUBEMAP_SLOT2
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT2ReflectMask LD* T2 SHADOWMAP DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 DEFINE:TEX_COORD0 DEFINE:TEX_COORD1 DEFINE:USE_SHADOWS DEFINE:HKG_CUBEMAP_SLOT6
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1ReflectNoDiff LD* T1 REFLECTION NORMAL0 SPECULAR0 DEFINE:TEX_COORD0 DEFINE:NO_DIFF DEFINE:HKG_CUBEMAP_SLOT0
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP REFLECTION NORMAL0 SPECULAR0 DEFINE:TEX_COORD0 DEFINE:NO_DIFF  DEFINE:USE_SHADOWS DEFINE:HKG_CUBEMAP_SLOT4
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 REFLECTION NORMAL0  DEFINE:TEX_COORD0 DEFINE:NO_DIFF DEFINE:NO_SPEC DEFINE:HKG_CUBEMAP_SLOT0
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP REFLECTION NORMAL0 DEFINE:TEX_COORD0 DEFINE:NO_DIFF DEFINE:NO_SPEC DEFINE:USE_SHADOWS DEFINE:HKG_CUBEMAP_SLOT4
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0  DEFINE:TEX_COORD0 DEFINE:NO_SPEC DEFINE:HKG_CUBEMAP_SLOT1
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 DEFINE:TEX_COORD0 DEFINE:NO_SPEC DEFINE:USE_SHADOWS DEFINE:HKG_CUBEMAP_SLOT5

//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:HKG_CUBEMAP_SLOT1
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:USE_SHADOWS DEFINE:HKG_CUBEMAP_SLOT5
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1ReflectMask LD* T1 DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:HKG_CUBEMAP_SLOT2
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1ReflectMask LD* T1 SHADOWMAP DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:USE_SHADOWS  DEFINE:HKG_CUBEMAP_SLOT6
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT2ReflectMask LD* T2 DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1 DEFINE:HKG_CUBEMAP_SLOT2
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT2ReflectMask LD* T2 SHADOWMAP DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1 DEFINE:USE_SHADOWS DEFINE:HKG_CUBEMAP_SLOT6
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 REFLECTION NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:NO_DIFF  DEFINE:HKG_CUBEMAP_SLOT0
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP REFLECTION NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:NO_DIFF  DEFINE:USE_SHADOWS DEFINE:HKG_CUBEMAP_SLOT4
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 REFLECTION NORMAL0 SKINNED DEFINE:HKG_SKINNING  DEFINE:TEX_COORD0 DEFINE:NO_DIFF DEFINE:NO_SPEC DEFINE:HKG_CUBEMAP_SLOT0
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP REFLECTION NORMAL0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:NO_DIFF DEFINE:NO_SPEC DEFINE:USE_SHADOWS DEFINE:HKG_CUBEMAP_SLOT4
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SKINNED DEFINE:HKG_SKINNING  DEFINE:TEX_COORD0 DEFINE:NO_SPEC DEFINE:HKG_CUBEMAP_SLOT1
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SKINNED DEFINE:HKG_SKINNING  DEFINE:TEX_COORD0 DEFINE:NO_SPEC DEFINE:USE_SHADOWS DEFINE:HKG_CUBEMAP_SLOT5

//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:HKG_CUBEMAP_SLOT1
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:USE_SHADOWS DEFINE:HKG_CUBEMAP_SLOT5
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1ReflectMask LD* T1 DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:HKG_CUBEMAP_SLOT2
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1ReflectMask LD* T1 SHADOWMAP DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:USE_SHADOWS DEFINE:HKG_CUBEMAP_SLOT6
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT2ReflectMask LD* T2 DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1  DEFINE:HKG_CUBEMAP_SLOT2
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT2ReflectMask LD* T2 SHADOWMAP DIFFUSE0 REFLECTION REFLECTION NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1 DEFINE:USE_SHADOWS DEFINE:HKG_CUBEMAP_SLOT6
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 REFLECTION NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:NO_DIFF  DEFINE:HKG_CUBEMAP_SLOT0
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP REFLECTION NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:NO_DIFF DEFINE:USE_SHADOWS DEFINE:HKG_CUBEMAP_SLOT4
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 REFLECTION NORMAL0 INSTANCED DEFINE:HKG_INSTANCING  DEFINE:TEX_COORD0 DEFINE:NO_DIFF DEFINE:NO_SPEC DEFINE:HKG_CUBEMAP_SLOT0
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP REFLECTION NORMAL0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:NO_DIFF DEFINE:NO_SPEC DEFINE:USE_SHADOWS DEFINE:HKG_CUBEMAP_SLOT4
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 INSTANCED DEFINE:HKG_INSTANCING  DEFINE:TEX_COORD0 DEFINE:NO_SPEC DEFINE:HKG_CUBEMAP_SLOT1
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixShadowSceneT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:NO_SPEC DEFINE:USE_SHADOWS DEFINE:HKG_CUBEMAP_SLOT5


#pragma include(CommonHeader.glslh)
#pragma include(CommonVertexShaders.glslh)


// Pixel Shaders

#ifdef ENTRYPOINT_PixT1Reflect
varying HIGHP vec4 VOutTexCoord0;

varying HIGHP vec3 VOutLightDir0TS;
varying HIGHP vec3 VOutLightDir1TS;
varying HIGHP vec3 VOutEyeDirTS;
varying HIGHP vec3 VOutPosView; 

varying HIGHP vec4 VOutReflect0;
varying HIGHP vec4 VOutReflect1;
varying HIGHP vec4 VOutReflect2;

void main()
{
	vec4 ColorMap = vec4(1.0,1.0,1.0,1.0);
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0.0,0.0,1.0); 
	
#ifndef NO_DIFF
    ColorMap = texture2D(g_sSamplerZero, VOutTexCoord0.xy);
	N = texture2D(g_sSamplerTwo, VOutTexCoord0.xy).xyz*2.0 - 1.0;
#else
	N = texture2D(g_sSamplerOne, VOutTexCoord0.xy).xyz*2.0 - 1.0;
#endif
	
	N = normalize(N);

	vec3 worldEyeVec = vec3( -VOutReflect0.w, -VOutReflect1.w, -VOutReflect2.w ); 
	vec3 worldNormal = vec3( dot(VOutReflect0.xyz, N), dot(VOutReflect1.xyz, N), dot(VOutReflect2.xyz, N) );
	vec3 reflVect = reflect( worldEyeVec, worldNormal ); 
#ifndef NO_DIFF
	vec4 ReflectionMap = textureCube(g_sSamplerOneCube, reflVect); 
#else
	vec4 ReflectionMap = textureCube(g_sSamplerZeroCube, reflVect); 
#endif

  
#ifndef NO_SPEC
	#ifndef NO_DIFF
		SpecMap *= texture2D(g_sSamplerThree, VOutTexCoord0.xy).rgb;
	#else
		SpecMap *= texture2D(g_sSamplerTwo, VOutTexCoord0.xy).rgb;
	#endif
#endif

	ColorMap.rgb += SpecMap.rgb*ReflectionMap.rgb;  

	ColorMap *= g_cDiffuseColor;
	
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, N, VOutLightDir0TS, VOutLightDir1TS, VOutEyeDirTS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb;
	totalLight = clamp(totalLight,0.0,1.0);
	vec3 negLight = vec3(1.0,1.0,1.0) - totalLight;
	
	gl_FragColor.rgb = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*SpecMap;
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	
	COMPUTE_FOG

}
#endif

#ifdef ENTRYPOINT_PixT1ReflectMask
varying HIGHP vec4 VOutTexCoord0;

varying HIGHP vec3 VOutLightDir0TS;
varying HIGHP vec3 VOutLightDir1TS;
varying HIGHP vec3 VOutEyeDirTS;
varying HIGHP vec3 VOutPosView; 

varying HIGHP vec4 VOutReflect0;
varying HIGHP vec4 VOutReflect1;
varying HIGHP vec4 VOutReflect2;
void main()
{
	vec4 ColorMap = vec4(1.0,1.0,1.0,1.0);
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0.0,0.0,1.0); 
	
#ifndef NO_DIFF
    ColorMap = texture2D(g_sSamplerZero, VOutTexCoord0.xy);
	N = texture2D(g_sSamplerThree, VOutTexCoord0.xy).xyz*2.0 - 1.0;
#else
	N = texture2D(g_sSamplerTwo, VOutTexCoord0.xy).xyz*2.0 - 1.0;
#endif

	N = normalize(N);

	vec3 worldEyeVec = vec3( -VOutReflect0.w, -VOutReflect1.w, -VOutReflect2.w ); 
	vec3 worldNormal = vec3( dot(VOutReflect0.xyz, N), dot(VOutReflect1.xyz, N), dot(VOutReflect2.xyz, N) );
	vec3 reflVect = reflect( worldEyeVec, worldNormal ); 
#ifndef NO_DIFF
	vec4 ReflectionMap = textureCube(g_sSamplerTwoCube, reflVect); 
	vec4 ReflectionMask = texture2D(g_sSamplerOne, VOutTexCoord0.xy); 
#else
	vec4 ReflectionMap = textureCube(g_sSamplerOneCube, reflVect); 
	vec4 ReflectionMask = texture2D(g_sSamplerZero, VOutTexCoord0.xy); 
#endif

	ColorMap.rgb = (1.0-ReflectionMask.rgb)*ColorMap.rgb + ReflectionMask.rgb*ReflectionMap.rgb*ColorMap.rgb;  
		
#ifndef NO_SPEC 
	#ifndef NO_DIFF
		SpecMap *= texture2D(g_sSamplerFour, VOutTexCoord0.xy).rgb;
	#else
		SpecMap *= texture2D(g_sSamplerThree, VOutTexCoord0.xy).rgb;
	#endif
#endif
	ColorMap *= g_cDiffuseColor;
	
	
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, N, VOutLightDir0TS, VOutLightDir1TS, VOutEyeDirTS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb;
	totalLight = clamp(totalLight,0.0,1.0);
	vec3 negLight = vec3(1.0,1.0,1.0) - totalLight;
	
	gl_FragColor.rgb = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight.rgb*ColorMap.rgb + light0.www*SpecMap;
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	
	COMPUTE_FOG

}
#endif

#ifdef ENTRYPOINT_PixT2ReflectMask
varying HIGHP vec4 VOutTexCoord0;

varying HIGHP vec3 VOutLightDir0TS;
varying HIGHP vec3 VOutLightDir1TS;
varying HIGHP vec3 VOutEyeDirTS;
varying HIGHP vec3 VOutPosView; 

varying HIGHP vec4 VOutReflect0;
varying HIGHP vec4 VOutReflect1;
varying HIGHP vec4 VOutReflect2;
void main()
{
	vec4 ColorMap = vec4(1.0,1.0,1.0,1.0);
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0.0,0.0,1.0); 
	
    ColorMap = texture2D(g_sSamplerZero, VOutTexCoord0.xy);
	N = (texture2D(g_sSamplerThree, VOutTexCoord0.xy)*2.0 - 1.0).xyz;
	N = normalize(N);
	
	vec3 worldEyeVec = vec3( -VOutReflect0.w, -VOutReflect1.w, -VOutReflect2.w ); 
	vec3 worldNormal = vec3( dot(VOutReflect0.xyz, N), dot(VOutReflect1.xyz, N), dot(VOutReflect2.xyz, N) );
	vec3 reflVect = reflect( worldEyeVec, worldNormal ); 
	vec4 ReflectionMap = textureCube(g_sSamplerTwoCube, reflVect); 
	vec4 ReflectionMask = texture2D(g_sSamplerOne, VOutTexCoord0.zw); 
	ColorMap.rgb = (1.0-ReflectionMask.rgb)*ColorMap.rgb + ReflectionMask.rgb*ReflectionMap.rgb*ColorMap.rgb;  

	SpecMap *= texture2D(g_sSamplerFour, VOutTexCoord0.xy).rgb;

	ColorMap *= g_cDiffuseColor;

	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, N, VOutLightDir0TS, VOutLightDir1TS, VOutEyeDirTS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb;
	totalLight = clamp(totalLight,0.0,1.0);
	vec3 negLight = vec3(1.0,1.0,1.0) - totalLight;
	
	gl_FragColor.rgb = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight.rgb*ColorMap.rgb + light0.www*SpecMap;
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	
	COMPUTE_FOG

}
#endif

#ifdef ENTRYPOINT_PixShadowSceneT1Reflect
varying HIGHP vec4 VOutTexCoord0;

varying HIGHP vec3 VOutLightDir0TS;
varying HIGHP vec3 VOutLightDir1TS;
varying HIGHP vec3 VOutEyeDirTS;
varying HIGHP vec3 VOutPosView; 

varying HIGHP vec4 VOutReflect0;
varying HIGHP vec4 VOutReflect1;
varying HIGHP vec4 VOutReflect2;
void main()
{
    float lightAmount = getLightAmountShadow( VOutPosView );
  		
	vec4 ColorMap = vec4(1.0,1.0,1.0,1.0);
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0,0,1); 
	
#ifndef NO_DIFF
    ColorMap = texture2D(g_sSamplerFour, VOutTexCoord0.xy);
	N = texture2D(g_sSamplerSix, VOutTexCoord0.xy).xyz*2.0 - 1.0;
#else
	N = texture2D(g_sSamplerFive, VOutTexCoord0.xy).xyz*2.0 - 1.0;
#endif
		
	N = normalize(N);

	vec3 worldEyeVec = vec3( -VOutReflect0.w, -VOutReflect1.w, -VOutReflect2.w ); 
	vec3 worldNormal = vec3( dot(VOutReflect0.xyz, N), dot(VOutReflect1.xyz, N), dot(VOutReflect2.xyz, N) );
	vec3 reflVect = reflect( worldEyeVec, worldNormal ); 
	#ifndef NO_DIFF
		vec4 ReflectionMap = textureCube(g_sSamplerFiveCube, reflVect); 
	#else
		vec4 ReflectionMap = textureCube(g_sSamplerFourCube, reflVect); 
	#endif
	
	

#ifndef NO_SPEC
	#ifndef NO_DIFF
		SpecMap *= texture2D(g_sSamplerSeven, VOutTexCoord0.xy).rgb;
	#else
		SpecMap *= texture2D(g_sSamplerSix, VOutTexCoord0.xy).rgb;
	#endif	
#endif

	ColorMap.rgb += SpecMap.rgb*ReflectionMap.rgb;  

	ColorMap *= g_cDiffuseColor;

	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, N, VOutLightDir0TS, VOutLightDir1TS, VOutEyeDirTS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	totalLight = clamp(totalLight,0.0,1.0);
	gl_FragColor.rgb = (1.0-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap );
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
	COMPUTE_FOG

}
#endif

#ifdef ENTRYPOINT_PixShadowSceneT1ReflectMask
varying HIGHP vec4 VOutTexCoord0;

varying HIGHP vec3 VOutLightDir0TS;
varying HIGHP vec3 VOutLightDir1TS;
varying HIGHP vec3 VOutEyeDirTS;
varying HIGHP vec3 VOutPosView; 

varying HIGHP vec4 VOutReflect0;
varying HIGHP vec4 VOutReflect1;
varying HIGHP vec4 VOutReflect2;
void main()
{
  
    float lightAmount = getLightAmountShadow( VOutPosView ); 
		
	vec4 ColorMap = vec4(1.0,1.0,1.0,1.0);
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0.0,0.0,1.0); 
	
    ColorMap = texture2D(g_sSamplerFour, VOutTexCoord0.xy);
	N = texture2D(g_sSamplerSeven, VOutTexCoord0.xy).xyz*2.0 - 1.0;
	N = normalize(N);
		
	vec3 worldEyeVec = vec3( -VOutReflect0.w, -VOutReflect1.w, -VOutReflect2.w ); 
	vec3 worldNormal = vec3( dot(VOutReflect0.xyz, N), dot(VOutReflect1.xyz, N), dot(VOutReflect2.xyz, N) );
	vec3 reflVect = reflect( worldEyeVec, worldNormal ); 
	vec4 ReflectionMap = textureCube(g_sSamplerSixCube, reflVect); 
	vec4 ReflectionMask = texture2D(g_sSamplerFive, VOutTexCoord0.xy);
	ColorMap.rgb = ( (vec3(1.0,1.0,1.0)-ReflectionMask.rgb) + ReflectionMask.rgb*ReflectionMap.rgb )*ColorMap.rgb;  

	//SpecMap *= texture2D(g_sSamplerEight, VOutTexCoord0.xy).rgb;

	ColorMap *= g_cDiffuseColor;

	// interp will not preserve length
	
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, N, VOutLightDir0TS, VOutLightDir1TS, VOutEyeDirTS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	totalLight = clamp(totalLight,0.0,1.0);
	gl_FragColor.rgb = (1.0-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap );
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
	COMPUTE_FOG

}
#endif

#ifdef ENTRYPOINT_PixShadowSceneT2ReflectMask
varying HIGHP vec4 VOutTexCoord0;

varying HIGHP vec3 VOutLightDir0TS;
varying HIGHP vec3 VOutLightDir1TS;
varying HIGHP vec3 VOutEyeDirTS;
varying HIGHP vec3 VOutPosView; 

varying HIGHP vec4 VOutReflect0;
varying HIGHP vec4 VOutReflect1;
varying HIGHP vec4 VOutReflect2;
void main()
{
    float lightAmount = getLightAmountShadow( VOutPosView ); 
		
	vec4 ColorMap = vec4(1.0,1.0,1.0,1.0);
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0.0,0.0,1.0); 
	
	vec2 tc0 = VOutTexCoord0.xy;
	vec2 tc1 = VOutTexCoord0.zw;
	
    ColorMap = texture2D(g_sSamplerFour, tc0);
		
	N = texture2D(g_sSamplerSeven, tc0).xyz*2.0 - 1.0;
	N = normalize(N);

	vec3 worldEyeVec = vec3( -VOutReflect0.w, -VOutReflect1.w, -VOutReflect2.w ); 
	vec3 worldNormal = vec3( dot(VOutReflect0.xyz, N), dot(VOutReflect1.xyz, N), dot(VOutReflect2.xyz, N) );
	vec3 reflVect = reflect( worldEyeVec, worldNormal ); 
	vec4 ReflectionMap = textureCube(g_sSamplerSixCube, reflVect); 
	vec4 ReflectionMask = texture2D(g_sSamplerFive, tc1);
	ColorMap.rgb = (1.0-ReflectionMask.rgb)*ColorMap.rgb + ReflectionMask.rgb*ReflectionMap.rgb*ColorMap.rgb;  
	
	//SpecMap *= texture2D(g_sSamplerEight, tc0).rgb;

	ColorMap *= g_cDiffuseColor;

	
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, N, VOutLightDir0TS, VOutLightDir1TS, VOutEyeDirTS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	totalLight = clamp(totalLight,0.0,1.0);
	gl_FragColor.rgb = (1.0-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap );
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
	COMPUTE_FOG

}
#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
