/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION DEFINE:HKG_CUBEMAP_SLOT1 
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION DEFINE:HKG_CUBEMAP_SLOT5 
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION OPACITY0 DEFINE:HKG_CUBEMAP_SLOT1
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION OPACITY0 DEFINE:HKG_CUBEMAP_SLOT5

//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_CUBEMAP_SLOT1
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_CUBEMAP_SLOT5
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION OPACITY0 SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_CUBEMAP_SLOT1
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION OPACITY0 SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_CUBEMAP_SLOT5
 
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION INSTANCED DEFINE:HKG_INSTANCING DEFINE:HKG_CUBEMAP_SLOT1
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION INSTANCED DEFINE:HKG_INSTANCING DEFINE:HKG_CUBEMAP_SLOT5
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION OPACITY0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:HKG_CUBEMAP_SLOT1
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION OPACITY0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:HKG_CUBEMAP_SLOT5

//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION IRRADIANCE DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION IRRADIANCE DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION IRRADIANCE SKINNED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SKINNING DEFINE:NO_SPEC
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION IRRADIANCE SKINNED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SKINNING DEFINE:NO_SPEC
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION IRRADIANCE RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SKINNING DEFINE:NO_SPEC
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION IRRADIANCE RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SKINNING DEFINE:NO_SPEC
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION IRRADIANCE INSTANCED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_INSTANCING DEFINE:NO_SPEC
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION IRRADIANCE INSTANCED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_INSTANCING DEFINE:NO_SPEC
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION IRRADIANCE INSTANCED SKINNED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:NO_SPEC
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION IRRADIANCE INSTANCED SKINNED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:NO_SPEC
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION IRRADIANCE INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:NO_SPEC
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION IRRADIANCE INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:NO_SPEC

#include "CommonHeader.hlslh"
#include "CommonVertexShaders.hlslh"

#ifndef HKG_IRRADIANCE_MAPS
	struct vertexOutputT1NR {
		float4 position    : SV_Position; 
		float3 normal	   : TEXCOORD0;   
		float3 posView	   : TEXCOORD1;   
		float2 texCoord0   : TEXCOORD2;
		float3 toLightDir0OS : TEXCOORD3; 
		float3 toLightDir1OS : TEXCOORD4; 
		float3 eyeDirOS      : TEXCOORD5; 
		
		float3 normalWorld	: TEXCOORD6; 
		float3 eyeDirWorld	: TEXCOORD7;
	};
#else
	struct vertexOutputT1NR {
		float4 position    : SV_Position; 
		float3 normal	   : TEXCOORD0;   
		float3 posView	   : TEXCOORD1;   
		float2 texCoord0   : TEXCOORD2;		
		float3 normalWorld	: TEXCOORD3; 
		float3 eyeDirWorld	: TEXCOORD4;
	};
#endif
	
vertexOutputT1NR VertNoBumpN(vertexInputT1 In) 
{
    vertexOutputT1NR Out;
	
	float3 position = In.position.xyz;
    float3 normal = In.normal;
	
#ifdef HKG_INSTANCING
	float3x4 world;
   	world[0] = In.transformRow0;
   	world[1] = In.transformRow1;
   	world[2] = In.transformRow2;
	
   	#if defined(HKG_DX10) && defined(HKG_SKINNING)
	{
		// Get the skinning matrix
		uint vecsPerInst		= (uint)g_vectorsPerInstance;
		uint bufferStart		= vecsPerInst * In.instanceId;
		float3x4 objFromBones	= computeInstanceSkinMatrix(bufferStart, In.blendWeights, (int4)In.blendIndices);		

		// Skin position and normal
		position 	= mul(objFromBones, float4(position, 1));
		normal		= mul((float3x3)objFromBones, normal);
	}
	#endif
	
   	float3 worldVertPos = mul(world , float4(position.xyz, 1) ).xyz;
	float4 viewPos = mul( float4(worldVertPos, 1.0), g_mView);
	float3 toLight0 = g_vLightDir.xyz;
	if (lightZeroIsOmniOrSpot())
	{
			toLight0 = normalize(g_vLightPos.xyz - worldVertPos.xyz);
	}
#ifndef HKG_IRRADIANCE_MAPS 	
	float3 lightVec = mul( toLight0, (float3x3)world ); 
	float3 lightVec1 = mul( g_vLight1Dir.xyz, (float3x3)world );  // rev mult order 
#endif
	float3 eyeVec = g_mViewInv[3].xyz - worldVertPos.xyz; // world space eye vector
	
	eyeVec = normalize(eyeVec);
	Out.eyeDirWorld = eyeVec;
	Out.normalWorld = mul((float3x3)world, normal );
	
	eyeVec = mul(eyeVec, (float3x3) world );  // transform back to object space	
		
#else
    
#ifdef HKG_SKINNING   
    float4 blendWeightsArray = In.blendWeights;    
	#if defined(HKG_DX10)
		int4  indexArray = (int4)In.blendIndices;    
	#else
		int4  indexArray = D3DCOLORtoUBYTE4(In.blendIndices);
	#endif
    skinPositionNormal( In.position.xyz, In.normal.xyz, blendWeightsArray, indexArray, position, normal );     
#endif 

	float3 worldVertPos = mul(float4(position, 1.0), g_mWorld).xyz;
	float4 viewPos = mul( float4(position, 1.0), g_mWorldView);	
	float3 toLight0 = g_vLightDir.xyz;
	if (lightZeroIsOmniOrSpot())
	{
		toLight0 = normalize(g_vLightPos.xyz - worldVertPos.xyz);
	}
#ifndef HKG_IRRADIANCE_MAPS 	
	float3 lightVec = mul( toLight0, (float3x3)g_mWorldInv ); 
	float3 lightVec1 = mul( g_vLight1Dir.xyz, (float3x3)g_mWorldInv ).xyz;  
#endif
	float3 eyeVec = g_mViewInv[3].xyz - worldVertPos.xyz; // world space eye vector
	
	eyeVec = normalize(eyeVec);
	Out.eyeDirWorld = eyeVec;
	Out.normalWorld = mul(normal, (float3x3)g_mWorld);
	
	eyeVec = mul(eyeVec, (float3x3) g_mWorldInv );  // transform back to object space
	
#endif
	
	// transform position to clip space
	Out.position = mul( viewPos, g_mProj);
	Out.normal = normal;
  
#ifndef HKG_IRRADIANCE_MAPS  
	// light vector
	Out.toLightDir0OS = lightVec; 
	Out.toLightDir1OS = lightVec1; 
	
	// eye vector
	Out.eyeDirOS = eyeVec;
#endif
	Out.posView = viewPos.xyz;
	
	Out.texCoord0 = In.texCoord0;
	
//	//calculate our vectors N, E, L, and H
//	float3 worldEyePos = g_mViewInv[3].xyz;
//	float3 worldEye = normalize(worldVertPos.xyz - worldEyePos.xyz);

	return Out;
}
 
 #ifdef HKG_CUBEMAP_SLOT1
 
// Used with say VertBumpReflect
pixelOutput eyesPS( vertexOutputT1NR In )
{
	HKG_TEST_DEPTH_PEEL

	pixelOutput Output;
    
    float4 ColorMap = _sample0(In.texCoord0);
	
	float3 vNormalWorld	= normalize(In.normalWorld);
	float3 vView		= normalize(In.eyeDirWorld);
	
	float fNdotV 				= saturate(dot(vNormalWorld, vView));
	float3 vReflection 			= 2 * vNormalWorld * fNdotV - vView;
	float3x3 rotWorldToEnv 		= (float3x3)g_mWorldToEnv;
	float3 envReflection  		= mul(vReflection, rotWorldToEnv);

	float4 ReflectionMap 		= _cubeSample1(envReflection); 
	
	ColorMap.rgb += ReflectionMap.rgb;
	ColorMap *= g_cDiffuseColor;

	float3 litColor;
#ifdef HKG_IRRADIANCE_MAPS
	{
		float3 shadowedColor;
		float3 SpecMap = g_cSpecularColor.rgb;
		LightPixelWithCubeMap(ColorMap, SpecMap, vNormalWorld, vView, shadowedColor, litColor);
	}
#else
	float4 light0 = 1;
	float3 light1 = 0;
	LightPixel( In.posView, normalize(In.normal), In.toLightDir0OS, In.toLightDir1OS, In.eyeDirOS, light0, light1);
	
	float3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity  );
	
	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;
	litColor = negLight * g_cAmbientColor.rgb * ColorMap.rgb + totalLight * ColorMap.rgb + specularLight;
#endif
	
	Output.color.rgb = litColor;
	Output.color.a = ColorMap.a;
	
	clip( Output.color.a - ALPHA_DISCARD_TOLERANCE );

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
	
	if ( getColorRangeCorrectionEnabled() )
	{
		Output.color.rgb *= getExposurePow2();
		Output.color.rgb = pow(Output.color.rgb, getInvGamma() ); 
	}
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
	Output.pzDepth.a = Output.color.a;

    return Output; 
}

#endif


#ifdef HKG_CUBEMAP_SLOT5

pixelOutput eyesShadowPS( vertexOutputT1NR In )
{
 	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;
    
	float lightAmount = getLightAmountShadow( In.posView );
	
    float4 ColorMap = _sample4(In.texCoord0);
	
	
	float3 vNormalWorld	= normalize(In.normalWorld);
	float3 vView		= normalize(In.eyeDirWorld);
	
	float fNdotV 				= saturate(dot(vNormalWorld, vView));
	float3 vReflection 			= 2 * vNormalWorld * fNdotV - vView;
	float3x3 rotWorldToEnv 		= (float3x3)g_mWorldToEnv;
	float3 envReflection  		= mul(vReflection, rotWorldToEnv);

	float4 ReflectionMap 		= _cubeSample5(envReflection); 
	
	ColorMap.rgb += ReflectionMap.rgb;
	ColorMap *= g_cDiffuseColor;
	
	float3 shadowedColor, litColor;
#ifdef HKG_IRRADIANCE_MAPS
	{
		float3 SpecMap = g_cSpecularColor.rgb;
		LightPixelWithCubeMap(ColorMap, SpecMap, vNormalWorld, vView, shadowedColor, litColor);
	}
#else
	{
		float4 light0 = 1;
		float3 light1 = 0;
	#if ENABLE_LIGHTING
		LightPixel( In.posView, normalize(In.normal), In.toLightDir0OS, In.toLightDir1OS, In.eyeDirOS, light0, light1);
	#endif
		
		float reflLuminosity = (ReflectionMap.r*0.33 + ReflectionMap.g*0.59 + ReflectionMap.b*0.11);
		reflLuminosity = saturate( reflLuminosity  );
		
		float3 specularLight = light0.www*g_cSpecularColor.rgb;
		float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
		saturate(totalLight);
		
		shadowedColor 	= (light1.rgb + g_cAmbientColor.rgb) * ColorMap.rgb;
		litColor		= totalLight*ColorMap.rgb + specularLight;
		ColorMap.a 		= saturate(ColorMap.a + reflLuminosity); // modulate alpha as is, shadow doesn't affect it.
	}
#endif

	Output.color.rgb 	= (1 - lightAmount) * shadowedColor + lightAmount * litColor;
	Output.color.a 		= ColorMap.a;
	
	clip( Output.color.a - ALPHA_DISCARD_TOLERANCE );
	
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
	
	if ( getColorRangeCorrectionEnabled() )
	{
		Output.color.rgb *= getExposurePow2();
		Output.color.rgb = pow(Output.color.rgb, getInvGamma() ); 
	}
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
