/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION DEFINE:TEX_COORD0
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION DEFINE:TEX_COORD0
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION OPACITY0 DEFINE:TEX_COORD0
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION OPACITY0 DEFINE:TEX_COORD0

//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION OPACITY0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION OPACITY0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0

//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesPS LD* T1 DIFFUSE0 REFLECTION OPACITY0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0
//:STYLE VertNoBumpN HK_NULL HK_NULL HK_NULL eyesShadowPS LD* T1 SHADOWMAP DIFFUSE0 REFLECTION OPACITY0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0

#pragma include(CommonHeader.glslh)

uniform mat4 g_mWorld;
uniform mat4 g_mWorldInv;
uniform mat4 g_mWorldView;	
uniform mat4 g_mProj;	
uniform mat4 g_mWorldViewProj;
uniform mat4 g_mViewProj;		
uniform mat4 g_mViewInv	;	
uniform mat4 g_mView;	
		
#ifdef ENTRYPOINT_VertNoBumpN
attribute HIGHP vec3 InPosition;  
#ifdef TEX_COORD0
attribute HIGHP vec2 InTexCoord0;
#endif
#ifdef TEX_COORD1
attribute HIGHP vec2 InTexCoord1;
#endif
attribute HIGHP vec3 InNormal;
attribute HIGHP vec3 InTangent;
attribute HIGHP vec3 InBinormal;
#ifdef HKG_SKINNING
attribute ivec4 InBlendIndices;
attribute HIGHP vec3 InBlendWeights;
#endif
#ifdef HKG_INSTANCING
attribute HIGHP vec4 InTransformRow0;
attribute HIGHP vec4 InTransformRow1;
attribute HIGHP vec4 InTransformRow2;
#endif

#ifdef TEX_COORD0
varying HIGHP vec2 VOutTexCoord0;
#endif
#ifdef TEX_COORD1
varying HIGHP vec2 VOutTexCoord1;
#endif
varying HIGHP vec3 VOutTexCoord2;//L
varying HIGHP vec3 VOutTexCoord3;//H

//XXX add rest 
varying HIGHP vec3 VOutNormal;
varying HIGHP vec3 VOutWorldReflDir ; // eye
varying HIGHP vec3 VOutPosView;

void main()
{
	vec4 position = vec4(InPosition.xyz,1.0);
    vec3 normal = InNormal;

#if defined(HKG_INSTANCING)

	mat4 worldTranspose;
  	worldTranspose[0] = InTransformRow0; 
   	worldTranspose[1] = InTransformRow1; 
   	worldTranspose[2] = InTransformRow2; 
	worldTranspose[3] = vec4(0.0, 0.0, 0.0, 1.0); 
	vec4 worldVertPos =  vec4(InPosition, 1.0) * worldTranspose; // since we swap row and col above we reverse order here
	mat3 worldInvRot = mat3(worldTranspose);
	
#else

	#if defined(HKG_SKINNING)
		skinPositionNormal( position, normal, InBlendWeights,  InBlendIndices, position, normal );
	#endif

	mat3 worldInvRot = mat3(g_mWorldInv);
	vec4 worldVertPos = g_mWorld * position; 
		
#endif

	gl_Position = g_mViewProj * worldVertPos;
	VOutPosView = (g_mView * worldVertPos).xyz;

#ifdef TEX_COORD0
	VOutTexCoord0 = InTexCoord0;
#endif
#ifdef TEX_COORD1
	VOutTexCoord1 = InTexCoord1;
#endif

	//XXX cleanup this mess

	vec3 L =  worldInvRot * g_vLightDir;  // transform back to object space
	VOutTexCoord2.xyz = L; 
	
	// eye vector
	vec3 worldEye = g_mViewInv[3].xyz - worldVertPos.xyz; // world space eye vector
	vec3 objEyeVec = worldInvRot * worldEye;  // transform back to object space
	objEyeVec = normalize(objEyeVec);
	
	// half-angle vector
	vec3 H = normalize(L + objEyeVec);
	VOutTexCoord3.xyz = H;
	
	vec3 worldNormal = normal * worldInvRot;
	VOutWorldReflDir = reflect( worldEye, worldNormal ).xyz;
	VOutNormal = normal;
}
#endif

vec2 reflectDirTo2DTexCoords(vec3 worldDir)
{
	
	vec3 X = vec3( 1.0,0.0,0.0 );
	vec3 Z = vec3( 0.0,0.0,1.0 );
	
	vec2 tex;
	tex.y = dot( normalize(worldDir), Z );
	worldDir.z = 0;
	tex.x = dot( normalize(worldDir), X ) * 0.5;
	if (worldDir.y >= 0.0)
	{
		tex = (tex + 1.0) * 0.5;
	}
	else // back
	{
		tex.y = (tex.y + 1.0) * 0.5;
		tex.x = (tex.x * -0.5) + 1.0;
	}
	//xx gl  fixme
	tex.y = 1 - tex.y;
	return tex;
}
 
 //XX add shadow ver etc
#if defined(ENTRYPOINT_eyesShadowPS) || defined(ENTRYPOINT_eyesPS)

#ifdef TEX_COORD0
varying HIGHP vec2 VOutTexCoord0;//tc
#endif

varying HIGHP vec3 VOutTexCoord2;//L
varying HIGHP vec3 VOutTexCoord3;//H
varying HIGHP vec3 VOutPosView;

varying HIGHP vec3 VOutNormal;
varying HIGHP vec3 VOutWorldReflDir ; // eye

void main()
{
	#ifdef ENTRYPOINT_eyesShadowPS
		float lightAmount = getLightAmountShadow( VOutPosView ); 
		vec4 ReflectionMap = vec4(texture2D(g_sSamplerFive, reflectDirTo2DTexCoords(VOutWorldReflDir)).rgb, 0.0); 
		vec4 ColorMap = texture2D(g_sSamplerFour, VOutTexCoord0.xy);
	#else
		float lightAmount = 1.0;
		vec4 ReflectionMap = vec4(texture2D(g_sSamplerOne, reflectDirTo2DTexCoords(VOutWorldReflDir)).rgb, 0.0); 
		vec4 ColorMap = texture2D(g_sSamplerZero, VOutTexCoord0.xy);
	#endif	
	
	vec3 SpecMap = g_cSpecularColor.rgb;
	ColorMap += ReflectionMap;
	ColorMap *= g_cDiffuseColor;
	
	vec3 L = normalize(VOutTexCoord2.xyz);
	vec3 H = normalize(VOutTexCoord3.xyz);
	float NdotL = dot(VOutNormal, L);
	float NdotH = dot(VOutNormal, H);
	vec4 light = lightAmount * Phong(NdotL, NdotH, g_cSpecularPower) * vec4(g_cLightColor.rgb,1.0);
	
	gl_FragColor.rgb = (1.0-light.rgb)*g_cAmbientColor.rgb*ColorMap.rgb + light.rgb*ColorMap.rgb + light.www*g_cSpecularColor.rgb;
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.

	COMPUTE_FOG

}
#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
