/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//
// [None, one or two] diffuse maps, no normal map, with and without shadows. Vertex lit with one or two lights

//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 OPACITY0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 OPACITY0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 OPACITY0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 OPACITY0 INSTANCED DEFINE:HKG_INSTANCING
 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 OPACITY1 DEFINE:HAVE_OPACITY1 DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT2 LD* T2 SHADOWMAP DIFFUSE0 OPACITY1 DEFINE:HAVE_OPACITY1 DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 OPACITY1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:HAVE_OPACITY1 DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT2 LD* T2 SHADOWMAP DIFFUSE0 OPACITY1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:HAVE_OPACITY1 DEFINE:TWO_TCOORDS

//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT0 LD* T0 DEFINE:NO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT0 LD* T0 SHADOWMAP DEFINE:NO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 SPECULAR0 DEFINE:USE_SPEC 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 SPECULAR0 DEFINE:USE_SPEC 
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 DIFFUSE0 LIGHTMAP1 DEFINE:TWO_TCOORDS DEFINE:LIGHTMAP
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T3 DIFFUSE0 LIGHTMAP1 NORMAL2 DEFINE:TWO_TCOORDS DEFINE:LIGHTMAP
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT2LM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 DEFINE:TWO_TCOORDS DEFINE:LIGHTMAP
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT2LM LD* T3 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL2 DEFINE:TWO_TCOORDS DEFINE:LIGHTMAP

//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 OPACITY0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 OPACITY0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 OPACITY0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 OPACITY0 SKINNED DEFINE:HKG_SKINNING

//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT0 LD* T0 SKINNED DEFINE:HKG_SKINNING DEFINE:NO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT0 LD* T0 SHADOWMAP SKINNED DEFINE:HKG_SKINNING DEFINE:NO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING

//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 DIFFUSE0 LIGHTMAP1 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:LIGHTMAP
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT2LM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:LIGHTMAP

//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT0 LD* T0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:NO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT0 LD* T0 SHADOWMAP INSTANCED DEFINE:HKG_INSTANCING DEFINE:NO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 DIFFUSE0 LIGHTMAP1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:LIGHTMAP
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT2LM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:LIGHTMAP

//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT0 LD* T0 INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:NO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT0 LD* T0 SHADOWMAP INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:NO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING

//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT0 LD* T0 IRRADIANCE DEFINE:NO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT0 LD* T0 SHADOWMAP IRRADIANCE DEFINE:NO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS DEFINE:NO_SPEC

//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT0 LD* T0 IRRADIANCE SKINNED DEFINE:HKG_SKINNING DEFINE:NO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT0 LD* T0 SHADOWMAP IRRADIANCE SKINNED DEFINE:HKG_SKINNING DEFINE:NO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT0 LD* T0 IRRADIANCE RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:NO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT0 LD* T0 SHADOWMAP IRRADIANCE RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:NO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT0 LD* T0 IRRADIANCE INSTANCED DEFINE:HKG_INSTANCING DEFINE:NO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT0 LD* T0 SHADOWMAP IRRADIANCE INSTANCED DEFINE:HKG_INSTANCING DEFINE:NO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT0 LD* T0 IRRADIANCE INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:NO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT0 LD* T0 SHADOWMAP IRRADIANCE INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:NO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 IRRADIANCE SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 IRRADIANCE SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT0 LD* T0 IRRADIANCE INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:NO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT0 LD* T0 SHADOWMAP IRRADIANCE INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:NO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 IRRADIANCE RIGID SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 IRRADIANCE RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 IRRADIANCE INSTANCED DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 IRRADIANCE INSTANCED DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 IRRADIANCE INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 IRRADIANCE INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 IRRADIANCE INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneT1 LD* T1 SHADOWMAP DIFFUSE0 IRRADIANCE INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS DEFINE:NO_SPEC

//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixBlend LD* T2 DIFFUSE0 DIFFUSE0 DIFFUSE1 DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneBlend LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE0 DIFFUSE1 DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixBlend LD* T2 DIFFUSE0 DIFFUSE0 DIFFUSE1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneBlend LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE0 DIFFUSE1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixBlend LD* T2 DIFFUSE0 DIFFUSE0 DIFFUSE1 INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneBlend LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE0 DIFFUSE1 INSTANCED SKINNED DEFINE:HKG_INSTANCING DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixBlend LD* T2 DIFFUSE0 DIFFUSE0 DIFFUSE1 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneBlend LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE0 DIFFUSE1 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixBlend LD* T2 DIFFUSE0 DIFFUSE0 DIFFUSE1 RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneBlend LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE0 DIFFUSE1 RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixBlend LD* T2 DIFFUSE0 DIFFUSE0 DIFFUSE1 INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixShadowSceneBlend LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE0 DIFFUSE1 INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_INSTANCING DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS

#include "CommonHeader.hlslh"
#include "CommonVertexShaders.hlslh"

#ifdef HKG_IRRADIANCE_MAPS
pixelOutput PixShadowSceneT0( vertexOutputT0NDim In )
#else
pixelOutput PixShadowSceneT0( vertexOutputT0N In )
#endif
{
 	HKG_TEST_DEPTH_PEEL

	pixelOutput Output;
	
    float lightAmount = getLightAmountShadow( In.posView );
	
	float3 shadowedColor, litColor;
#ifdef HKG_IRRADIANCE_MAPS
	{
		float3 vNormalWorld	= normalize(In.normalWorld);
		float3 vView		= normalize(In.eyeDirWorld);
		float3 SpecMap		= 1;
		LightPixelWithCubeMap(g_cDiffuseColor, SpecMap, vNormalWorld, vView, shadowedColor, litColor);
		
		Output.color.a = g_cDiffuseColor.a; 
	}
#else
	{
		float4 light0 = 1;
		float3 light1 = 0;
		LightPixel( In.posView, normalize(In.normal), In.toLightDir0OS, In.toLightDir1OS, In.eyeDirOS, light0, light1);
		
		float3 specularLight = light0.www*g_cSpecularColor.rgb;
		float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
		specLuminosity = saturate( specLuminosity * lightAmount );
		
		float3 totalLight 	= light0.rgb + light1.rgb + g_cAmbientColor.rgb;
		shadowedColor		= (light1.rgb + g_cAmbientColor.rgb) * g_cDiffuseColor.rgb;
		litColor			= totalLight * g_cDiffuseColor.rgb + specularLight;
		Output.color.a 		= saturate(g_cDiffuseColor.a + specLuminosity); // a few neweer demos use rhe fact that specular is aditional on alpha channel
	}
#endif

	Output.color.rgb = (1 - lightAmount) * shadowedColor + lightAmount * litColor;

	clip( Output.color.a - getAlphaClipTolerance() );

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
	
	if ( getColorRangeCorrectionEnabled() )
	{
		Output.color.rgb *= getExposurePow2();
		Output.color.rgb = pow(Output.color.rgb, getInvGamma() ); 
	}

	Output.pzDepth.rgba = In.posView.z * g_iDepthParams.x ;
    
    return Output;
}

#ifdef HKG_IRRADIANCE_MAPS
pixelOutput PixShadowSceneT1( vertexOutputT1NDim In )
#else
pixelOutput PixShadowSceneT1( vertexOutputT1N In )
#endif
{
  	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;

    float lightAmount = getLightAmountShadow( In.posView );
	
	float4 texel = _sample4(In.texCoord0 );

    float4 SpecMap = 1;
#ifdef USE_SPEC 
    SpecMap = _sample5(In.texCoord0);
#endif

	float4 colorMap = g_cDiffuseColor * texel;
	
	float3 shadowedColor, litColor;
#ifdef HKG_IRRADIANCE_MAPS
	{
		float3 vNormalWorld	= normalize(In.normalWorld);
		float3 vView		= normalize(In.eyeDirWorld);
		LightPixelWithCubeMap(colorMap, SpecMap.xyz, vNormalWorld, vView, shadowedColor, litColor);
		
		Output.color.a = colorMap.a; 
	}
#else
	{
		float4 light0 = 1;
		float3 light1 = 0;
		LightPixel( In.posView, normalize(In.normal), In.toLightDir0OS, In.toLightDir1OS, In.eyeDirOS, light0, light1);
		
		float3 specularLight = light0.www*g_cSpecularColor.rgb*SpecMap.rgb;
		float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
		specLuminosity = saturate( specLuminosity * lightAmount  );
		
		float3 totalLight 	= light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
		shadowedColor		= (light1.rgb + g_cAmbientColor.rgb) * colorMap.rgb;
		litColor 			= totalLight * colorMap.rgb + specularLight;
		Output.color.a 		= saturate(colorMap.a + specLuminosity); // a few neweer demos use rhe fact that specular is aditional on alpha channel
	}
#endif

	Output.color.rgb = (1 - lightAmount) * shadowedColor + lightAmount * litColor;
	
	clip( Output.color.a - getAlphaClipTolerance() );

    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
	
	if ( getColorRangeCorrectionEnabled() )
	{
		Output.color.rgb *= getExposurePow2();
		Output.color.rgb = pow(Output.color.rgb, getInvGamma() ); 
	}
	
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

pixelOutput PixShadowSceneT2( vertexOutputT2N In )
{
 	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;

    float lightAmount = getLightAmountShadow( In.posView );
	
	float4 texel0 = _sample4(In.texCoord01.xy );
  #ifdef HAVE_OPACITY1
	float texelAlpha = _sample5(In.texCoord01.zw ).r;
	float3 texelTotal = texel0.rgb;
  #else
    float4 texel1 = _sample5(In.texCoord01.zw );
    float3 texelTotal = (texel0.rgb + (texel1.rgb * 0.6));
	float texelAlpha = texel0.a * texel1.a;
   #endif
	 
	float4 light0 = 1;
	float3 light1 = 0;
	LightPixel( In.posView, normalize(In.normal), In.toLightDir0OS, In.toLightDir1OS, In.eyeDirOS, light0, light1);
	
	float3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity * lightAmount  );
	
	float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	float3 colorMap = g_cDiffuseColor.rgb * texelTotal;
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*colorMap.rgb + lightAmount*( totalLight*colorMap.rgb + specularLight );
	Output.color.a = saturate( texelAlpha*g_cDiffuseColor.a 
	#ifndef HAVE_OPACITY1
	   + specLuminosity // a few neweer demos use rhe fact that specular is aditional on alpha channel
	 #endif
	 ); 
	 
   	clip( Output.color.a - getAlphaClipTolerance() );
	 if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

pixelOutput PixShadowSceneBlend( vertexOutputT2N In )
{
 	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;

    float lightAmount = getLightAmountShadow( In.posView );
	
	float4 texel0 = _sample4(In.texCoord01.xy );
	float4 texel1 = _sample5(In.texCoord01.xy );
#if defined(HKG_DX10) || defined(HKG_DX11)	
	float clrD = _sample6(In.texCoord01.zw).r;	//Auto-generated decal map
#elif defined(HKG_PLATFORM_XBOX360)
	float clrD = _sample6(In.texCoord01.zw).a;
#else
	float clrD = _sample6(In.texCoord01.zw).b;
#endif
	float4 texelTotal = lerp(texel1, texel0, clrD);
	 
	float4 light0 = 1;
	float3 light1 = 0;
	LightPixel( In.posView, normalize(In.normal), In.toLightDir0OS, In.toLightDir1OS, In.eyeDirOS, light0, light1);
	
	float3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity * lightAmount  );
	
	float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	float3 colorMap = g_cDiffuseColor.rgb * texelTotal.rgb;
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*colorMap.rgb + lightAmount*( totalLight*colorMap.rgb + specularLight );
	Output.color.a = saturate( texelTotal.a*g_cDiffuseColor.a 
	#ifndef HAVE_OPACITY1
	   + specLuminosity // a few neweer demos use rhe fact that specular is aditional on alpha channel
	 #endif
	 ); 
	 
   	clip( Output.color.a - getAlphaClipTolerance() );
	 if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

pixelOutput PixShadowSceneT2LM( vertexOutputT2N In ) 
{ 
  	HKG_TEST_DEPTH_PEEL

	float lightAmount = getLightAmountShadow( In.posView );
	
    pixelOutput Output;
    float4 texel0 = _sample4(In.texCoord01.xy );
	float3 LightMap = _sample5(In.texCoord01.zw ).rgb;
	float texelAlpha = texel0.a;
	
	float3 gammaCorrectLight = texel0.rgb*LightMap.rgb;
	gammaCorrectLight *= (1 + lightAmount); // ColorMap is already gamma corrected , but LightMap is not and came from a EXR say in Max. Doing proper 2.2 gamma etc on it seems to wash it out, just *2 looks ok for now	
	// Darkens in places that have dynamic shadow. Assumes landscape not in the shadow maps given.
	
	//gammaCorrectLight *= getExposurePow2();
	//gammaCorrectLight = pow(gammaCorrectLight, getInvGamma() ); 
	
	Output.color.rgb = gammaCorrectLight; 
	float specLuminosity = 0;//xx
	
	Output.color.a = saturate( texelAlpha*g_cDiffuseColor.a + specLuminosity /* a few neweer demos use rhe fact that specular is aditional on alpha channel */ ); 

	clip( Output.color.a - getAlphaClipTolerance() );

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
	Output.pzDepth.a = Output.color.a;
    
    return Output;
}

#ifdef HKG_IRRADIANCE_MAPS
pixelOutput PixT0( vertexOutputT0NDim In ) 
#else
pixelOutput PixT0( vertexOutputT0N In ) 
#endif
{ 
 	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;
	
	float3 litColor;
#ifdef HKG_IRRADIANCE_MAPS
	{
		float3 shadowedColor;
		float3 vNormalWorld	= normalize(In.normalWorld);
		float3 vView		= normalize(In.eyeDirWorld);
		float3 SpecMap		= 1;
		LightPixelWithCubeMap(g_cDiffuseColor, SpecMap, vNormalWorld, vView, shadowedColor, litColor);
		
		Output.color.a = g_cDiffuseColor.a; 
	}
#else
	{
		float4 light0 = 1;
		float3 light1 = 0;
		LightPixel( In.posView, normalize(In.normal), In.toLightDir0OS, In.toLightDir1OS, In.eyeDirOS, light0, light1);
		
		float3 totalLight = light0.rgb + light1.rgb;
		saturate(totalLight);
		float3 negLight = float3(1,1,1) - totalLight;
		
		float3 specularLight = light0.www*g_cSpecularColor.rgb;
		float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
		specLuminosity 	= saturate( specLuminosity  );
		litColor		= negLight*g_cAmbientColor.rgb*g_cDiffuseColor.rgb + totalLight*g_cDiffuseColor.rgb + specularLight;
		Output.color.a 	= saturate( g_cDiffuseColor.a + specLuminosity); // a few neweer demos use rhe fact that specular is aditional on alpha channel
	}
#endif
	
	Output.color.rgb = litColor;
	
   	clip( Output.color.a - getAlphaClipTolerance() );
	
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
	
	if ( getColorRangeCorrectionEnabled() )
	{
		Output.color.rgb *= getExposurePow2();
		Output.color.rgb = pow(Output.color.rgb, getInvGamma() ); 
	}

    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

#ifdef HKG_IRRADIANCE_MAPS
pixelOutput PixT1( vertexOutputT1NDim In ) 
#else
pixelOutput PixT1( vertexOutputT1N In ) 
#endif
{ 
  	HKG_TEST_DEPTH_PEEL

   pixelOutput Output;
    float4 texel = _sample0(In.texCoord0); 

    float4 SpecMap = 1;
#ifdef USE_SPEC 
    SpecMap = _sample1(In.texCoord0);
#endif

	float4 colorMap = g_cDiffuseColor * texel;

	float3 litColor;
#ifdef HKG_IRRADIANCE_MAPS
	{
		float3 shadowedColor;
		float3 vNormalWorld	= normalize(In.normalWorld);
		float3 vView		= normalize(In.eyeDirWorld);
		LightPixelWithCubeMap(colorMap, SpecMap.xyz, vNormalWorld, vView, shadowedColor, litColor);
		
		Output.color.a = colorMap.a; 
	}
#else
	{
		float4 light0 = 1;
		float3 light1 = 0;
		LightPixel( In.posView, normalize(In.normal), In.toLightDir0OS, In.toLightDir1OS, In.eyeDirOS, light0, light1);
		
		float3 totalLight = light0.rgb + light1.rgb;
		saturate(totalLight);
		float3 negLight = float3(1,1,1) - totalLight;
		float3 specularLight = light0.www*g_cSpecularColor.rgb*SpecMap.rgb;
		float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
		specLuminosity = saturate( specLuminosity  );
		
		litColor = negLight*g_cAmbientColor.rgb*colorMap.rgb + totalLight*colorMap.rgb + specularLight;
		
		Output.color.a = saturate( colorMap.a + specLuminosity); // a few neweer demos use rhe fact that specular is aditional on alpha channel
	}
#endif
	
	Output.color.rgb = litColor;
	
    clip( Output.color.a - getAlphaClipTolerance() );
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
	
	if ( getColorRangeCorrectionEnabled() )
	{
		Output.color.rgb *= getExposurePow2();
		Output.color.rgb = pow(Output.color.rgb, getInvGamma() ); 
	}
		
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a; 
	return Output;
}

pixelOutput PixT2( vertexOutputT2N In ) 
{ 
  	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;
    float4 texel0 = _sample0(In.texCoord01.xy );
#if defined(HAVE_OPACITY1)
    float texelAlpha = _sample1(In.texCoord01.zw ).r;
	float3 texelTotal = texel0.rgb;
#else
	float4 texel1 = _sample1(In.texCoord01.zw );
    float3 texelTotal = texel0.rgb + (texel1.rgb * 0.6);
	float texelAlpha = texel0.a*texel1.a;
#endif
	
	float4 light0 = 1;
	float3 light1 = 0;
	LightPixel( In.posView, normalize(In.normal), In.toLightDir0OS, In.toLightDir1OS, In.eyeDirOS, light0, light1);
	
	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;
	
	float3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity  );
	
	float3 colorMap = g_cDiffuseColor.rgb * texelTotal;
	Output.color.rgb = negLight*g_cAmbientColor.rgb*colorMap.rgb + totalLight*colorMap.rgb + specularLight;
	
	Output.color.a = saturate( texelAlpha*g_cDiffuseColor.a 
	#ifndef HAVE_OPACITY1
			+ specLuminosity /* a few neweer demos use rhe fact that specular is aditional on alpha channel */
	#endif
			); 

	clip( Output.color.a - getAlphaClipTolerance() );

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
	Output.pzDepth.a = Output.color.a;
    
    return Output;
}

pixelOutput PixBlend( vertexOutputT2N In ) 
{ 
  	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;
    float4 texel0 = _sample0(In.texCoord01.xy);
	float4 texel1 = _sample1(In.texCoord01.xy);
		
#if defined(HKG_DX10) || defined(HKG_DX11)	
	float clrD = _sample2(In.texCoord01.zw).r;	//Auto-generated decal map
#elif defined(HKG_PLATFORM_XBOX360)
	float clrD = _sample2(In.texCoord01.zw).a;
#else
	float clrD = _sample2(In.texCoord01.zw).b;
#endif
	float4 texelTotal = lerp(texel1, texel0, clrD);
		
	float4 light0 = 1;
	float3 light1 = 0;
	LightPixel( In.posView, normalize(In.normal), In.toLightDir0OS, In.toLightDir1OS, In.eyeDirOS, light0, light1);
	
	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;
	
	float3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity  );
	
	float3 colorMap = g_cDiffuseColor.rgb * texelTotal.rgb;
	Output.color.rgb = negLight*g_cAmbientColor.rgb*colorMap.rgb + totalLight*colorMap.rgb + specularLight;
	
	Output.color.a = saturate( texelTotal.a*g_cDiffuseColor.a 
	#ifndef HAVE_OPACITY1
			+ specLuminosity /* a few neweer demos use rhe fact that specular is aditional on alpha channel */
	#endif
			); 

	clip( Output.color.a - getAlphaClipTolerance() );

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
	Output.pzDepth.a = Output.color.a;
    
    return Output;
}


pixelOutput PixT2LM( vertexOutputT2N In ) 
{ 
  	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;
    float4 texel0 = _sample0(In.texCoord01.xy );
	float3 LightMap = _sample1(In.texCoord01.zw ).rgb;
	float texelAlpha = texel0.a;
	
	float3 gammaCorrectLight = texel0.rgb*LightMap.rgb;
	gammaCorrectLight *= 2; // ColorMap is already gamma corrected , but LightMap is not and came from a EXR say in Max. Doing proper 2.2 gamma etc on it seems to wash it out, just *2 looks ok for now	
	//gammaCorrectLight *= getExposurePow2();
	//gammaCorrectLight = pow(gammaCorrectLight, getInvGamma() ); 
	
	Output.color.rgb = gammaCorrectLight; 
	float specLuminosity = 0;//xx
	
	Output.color.a = saturate( texelAlpha*g_cDiffuseColor.a + specLuminosity /* a few neweer demos use rhe fact that specular is aditional on alpha channel */ ); 

	clip( Output.color.a - getAlphaClipTolerance() );

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
	Output.pzDepth.a = Output.color.a;
    
    return Output;
}

pixelOutput PixDecalT2( vertexOutputT2N In ) 
{ 
 	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;
	
	// Sample textures: original, fractured, and decal map
	float4 	clrOrig 	= _sample0(In.texCoord01.xy);
	float4	clrBroken 	= _sample1(In.texCoord01.xy);
	float	clrD		= _sample2(In.texCoord01.zw).r;	//Auto-generated decal map
	
	clrD = clamp(2.5f * (clrD - 0.2f), -0.5f, .5f);
	
	// Modulate	
    float4 texelTotal = lerp(clrBroken, clrOrig, 0.5f + clrD);
    
	float4 light0 = 1;
	float3 light1 = 0;
	LightPixel( In.posView, normalize(In.normal), In.toLightDir0OS, In.toLightDir1OS, In.eyeDirOS, light0, light1);
	
	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;
	
	float3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity   );
	
	float4 colorMap = g_cDiffuseColor * texelTotal;
	Output.color.rgb = negLight*g_cAmbientColor.rgb*colorMap.rgb + totalLight*colorMap.rgb + specularLight;
	Output.color.a = saturate( colorMap.a + specLuminosity); // a few neweer demos use rhe fact that specular is aditional on alpha channel

	clip( Output.color.a - getAlphaClipTolerance() );

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
	Output.pzDepth.a = Output.color.a;
    
    return Output;
}

pixelOutput PixShadowDecalT2( vertexOutputT2N In )
{
 	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;

	float lightAmount = getLightAmountShadow( In.posView );
	
	// Sample textures: original, fractured, and decal map
	float4 	clrOrig 	= _sample4(In.texCoord01.xy);
	float4	clrBroken 	= _sample5(In.texCoord01.xy);
	float	clrD		= _sample6(In.texCoord01.zw).r;	//Auto-generated decal map
	
	clrD = clamp(2.5f * (clrD - 0.2f), -0.5f, .5f);
	
	// Modulate	
    float4 texelTotal = lerp(clrBroken, clrOrig, 0.5f + clrD);
     
	float4 light0 = 1;
	float3 light1 = 0;
	LightPixel( In.posView, normalize(In.normal), In.toLightDir0OS, In.toLightDir1OS, In.eyeDirOS, light0, light1);
	
	float3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity * lightAmount  );
	
	float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	float4 colorMap = g_cDiffuseColor * texelTotal;
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*colorMap.rgb + lightAmount*( totalLight*colorMap.rgb + specularLight );
	Output.color.a = saturate( colorMap.a + specLuminosity); // a few neweer demos use rhe fact that specular is aditional on alpha channel

  	clip( Output.color.a - getAlphaClipTolerance() );
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

pixelOutput PixDecorT2( vertexOutputT2N In ) 
{ 
 	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;
	
	// Sample textures: original and decor map
	float4 	clrDecor 	= _sample0(In.texCoord01.xy);
	float	clrD		= _sample1(In.texCoord01.zw).r;	//Auto-generated decal map
	
	clrD = clamp(2.5f * (clrD - 0.2f), -0.5f, .5f);
		
	// Apply a threshold
	clrD = (clrD > 0.0f) ? 1.0f : 0.0f;
	float 	alpha 	= clrDecor.a * (1.0f - clrD);
    float4 texelTotal = float4(clrDecor.rgb, alpha);
    
	float4 light0 = 1;
	float3 light1 = 0;
	LightPixel( In.posView, normalize(In.normal), In.toLightDir0OS, In.toLightDir1OS, In.eyeDirOS, light0, light1);
	
	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;
	
	float3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity  );
	
	float4 colorMap = g_cDiffuseColor * texelTotal;
	Output.color.rgb = negLight*g_cAmbientColor.rgb*colorMap.rgb + totalLight*colorMap.rgb + specularLight;
	Output.color.a = saturate( colorMap.a + specLuminosity); // a few neweer demos use rhe fact that specular is aditional on alpha channel

	clip( Output.color.a - getAlphaClipTolerance() );

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
	Output.pzDepth.a = Output.color.a;
    
    return Output;
}

pixelOutput PixShadowDecorT2( vertexOutputT2N In )
{
 	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;

	float lightAmount = getLightAmountShadow( In.posView );
	
	// Sample textures: original and decor map
	float4 	clrDecor 	= _sample4(In.texCoord01.xy);
	float	clrD		= _sample5(In.texCoord01.zw).r;	//Auto-generated decal map
	
	clrD = clamp(2.5f * (clrD - 0.2f), -0.5f, .5f);
	
	// Apply a threshold
	clrD = (clrD > 0.0f) ? 1.0f : 0.0f;
	float 	alpha 	= clrDecor.a * (1.0f - clrD);
    float4 texelTotal = float4(clrDecor.rgb, alpha);
     
	float4 light0 = 1;
	float3 light1 = 0;
	LightPixel( In.posView, normalize(In.normal), In.toLightDir0OS, In.toLightDir1OS, In.eyeDirOS, light0, light1);
	
	float3 specularLight = light0.www*g_cSpecularColor.rgb;
	float specLuminosity = (specularLight.r*0.33 + specularLight.g*0.59 + specularLight.b*0.11);
	specLuminosity = saturate( specLuminosity * lightAmount  );
	
	float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	float4 colorMap = g_cDiffuseColor * texelTotal;
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*colorMap.rgb + lightAmount*( totalLight*colorMap.rgb + specularLight );
	Output.color.a = saturate( colorMap.a + specLuminosity); // a few neweer demos use rhe fact that specular is aditional on alpha channel

   	clip( Output.color.a - getAlphaClipTolerance() );
	 if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
