/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//
// One or Two diffuse maps, along with a normal and specular map, with and without shadows. The most common demo shaders 
// with 'proper' assets. These will currently also allow loading of a gloss map, but will ignore it
// 

//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 EMISSIVE0 DEFINE:HKG_CUBEMAP_SLOT1
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 EMISSIVE0 DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:USE_SHADOWS
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 EMISSIVE0 DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:USE_SPEC_MAP
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 EMISSIVE0 DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:USE_SHADOWS DEFINE:USE_SPEC_MAP

//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 EMISSIVE0 SKINNED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:HKG_SKINNING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 EMISSIVE0 SKINNED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:HKG_SKINNING DEFINE:USE_SHADOWS
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 EMISSIVE0 SKINNED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:HKG_SKINNING DEFINE:USE_SPEC_MAP
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 EMISSIVE0 SKINNED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:HKG_SKINNING DEFINE:USE_SHADOWS DEFINE:USE_SPEC_MAP

//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 EMISSIVE0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:HKG_INSTANCING
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 EMISSIVE0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:HKG_INSTANCING DEFINE:USE_SHADOWS
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 EMISSIVE0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:HKG_INSTANCING DEFINE:USE_SPEC_MAP
//:STYLE VertBumpReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 EMISSIVE0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:HKG_INSTANCING DEFINE:USE_SHADOWS DEFINE:USE_SPEC_MAP

#include "CommonHeader.hlslh"
#include "CommonVertexShaders.hlslh"

// Pixel Shader
pixelOutput PixT1Reflect( vertexOutputT1BR In )
{
 	HKG_TEST_DEPTH_PEEL

	#ifdef USE_SHADOWS
		float lightAmount = getLightAmountShadow( In.posView );
		float4 ColorMap = _sample4( In.texCoord0);
		float3 N = _sample6(In.texCoord0).xyz*2.0 - 1.0;
		#ifdef USE_SPEC_MAP
			float3 SpecMap = _sample7(In.texCoord0).rgb;
			float3 EmitMap = _sample8(In.texCoord0).rgb;
		#else
			float3 SpecMap = float3(1,1,1);
			float3 EmitMap = _sample7(In.texCoord0).rgb;
		#endif
	#else
		float lightAmount = 1;
		float4 ColorMap = _sample0( In.texCoord0);
		float3 N = _sample2(In.texCoord0).xyz*2.0 - 1.0;
		#ifdef USE_SPEC_MAP
			float3 SpecMap = _sample3(In.texCoord0).rgb;
			float3 EmitMap = _sample4(In.texCoord0).rgb;
		#else
			float3 SpecMap = float3(1,1,1);
			float3 EmitMap = _sample3(In.texCoord0).rgb;
		#endif

	#endif
	
	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );
	
	N = normalize(N);
	float3 worldEyeVec = float3( -In.tangToWorld0.w, -In.tangToWorld1.w, -In.tangToWorld2.w ); 
	float3 worldNormal = float3( dot(In.tangToWorld0.xyz, N), dot(In.tangToWorld1.xyz, N), dot(In.tangToWorld2.xyz, N) );
	float3 reflVect = reflect( worldEyeVec, worldNormal ); 

	#ifdef USE_SHADOWS
		float4 ReflectionMap = _cubeSample5(reflVect); 
	#else
		float4 ReflectionMap = _cubeSample1(reflVect); 
	#endif

	#ifdef USE_SPEC_MAP
		ColorMap.rgb += SpecMap*ReflectionMap.rgb;
	#else
		float emitLuminosity = (EmitMap.r*0.33 + EmitMap.g*0.59 + EmitMap.b*0.11);
		ColorMap.rgb = ColorMap.rgb + ( (1-emitLuminosity)*ReflectionMap.rgb); // so that emmisive areas not so shiney  
	#endif
	
	float4 light0 = 1;
	float3 light1 = 0;
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
		
	pixelOutput Output;
	float3 totalLight = light0.rgb + light1.rgb + g_cAmbientColor.rgb;
	saturate(totalLight);
	
	Output.color.rgb = EmitMap.rgb + (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*g_cSpecularColor.rgb*SpecMap );
	Output.color.a = ColorMap.a; // modulate alpha as is, light etc doesn't affect it.

	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
