/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//
// One or Two diffuse maps, along with a normal and specular map, with and without shadows. The most common demo shaders 
// with 'proper' assets. These will currently also allow loading of a gloss map, but will ignore it
// 

//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 EMISSIVE0 DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:TEX_COORD0
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 EMISSIVE0 DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:USE_SHADOWS DEFINE:TEX_COORD0
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 EMISSIVE0 DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:TEX_COORD0 DEFINE:USE_SPECMAP
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 EMISSIVE0 DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:USE_SHADOWS DEFINE:TEX_COORD0 DEFINE:USE_SPECMAP

//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 EMISSIVE0 SKINNED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:HKG_SKINNING DEFINE:TEX_COORD0
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 EMISSIVE0 SKINNED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:HKG_SKINNING DEFINE:USE_SHADOWS DEFINE:TEX_COORD0
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 EMISSIVE0 SKINNED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:USE_SPECMAP
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 EMISSIVE0 SKINNED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:HKG_SKINNING DEFINE:USE_SHADOWS DEFINE:TEX_COORD0 DEFINE:USE_SPECMAP

//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 EMISSIVE0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 EMISSIVE0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:HKG_INSTANCING DEFINE:USE_SHADOWS DEFINE:TEX_COORD0
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 EMISSIVE0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT1 DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:USE_SPECMAP
//:STYLE VertOneLightReflect HK_NULL HK_NULL HK_NULL PixT1Reflect LD* T1 SHADOWMAP DIFFUSE0 REFLECTION NORMAL0 SPECULAR0 EMISSIVE0 INSTANCED DEFINE:HKG_CUBEMAP_SLOT5 DEFINE:HKG_INSTANCING DEFINE:USE_SHADOWS DEFINE:TEX_COORD0 DEFINE:USE_SPECMAP

#pragma include(CommonHeader.glslh)
#pragma include(CommonVertexShaders.glslh)

#ifdef USE_SHADOWS
uniform sampler2D g_sSamplerEight; 
#endif

 // extra textures

#ifdef ENTRYPOINT_PixT1Reflect
varying HIGHP vec4 VOutTexCoord0;//tc
varying HIGHP vec3 VOutLightDir0TS;
varying HIGHP vec3 VOutLightDir1TS;
varying HIGHP vec3 VOutEyeDirTS;
varying HIGHP vec3 VOutPosView;
varying HIGHP vec4 VOutReflect0;
varying HIGHP vec4 VOutReflect1;
varying HIGHP vec4 VOutReflect2;

void main()
{
    #ifdef USE_SHADOWS
		float lightAmount = getLightAmountShadow( VOutPosView );
		vec4 ColorMap = texture2D(g_sSamplerFour, VOutTexCoord0.xy);
		vec3 N = texture2D(g_sSamplerSix, VOutTexCoord0.xy).xyz*2.0 - 1.0;
		#ifdef USE_SPECMAP
		vec3 SpecMap = texture2D(g_sSamplerSeven, VOutTexCoord0.xy).rgb;
		vec3 EmitMap = texture2D(g_sSamplerEight, VOutTexCoord0.xy).rgb;
		#else
		vec3 SpecMap = vec3(1.0,1.0,1.0);
		vec3 EmitMap = texture2D(g_sSamplerSeven, VOutTexCoord0.xy).rgb;
		#endif
	#else
		float lightAmount = 1.0;
		vec4 ColorMap = texture2D(g_sSamplerZero, VOutTexCoord0.xy);
		vec3 N = texture2D(g_sSamplerTwo, VOutTexCoord0.xy).xyz*2.0 - 1.0;
		#ifdef USE_SPECMAP
		vec3 SpecMap = texture2D(g_sSamplerThree, VOutTexCoord0.xy).rgb;
		vec3 EmitMap = texture2D(g_sSamplerFour, VOutTexCoord0.xy).rgb;
		#else
		vec3 SpecMap = vec3(1.0,1.0,1.0);
		vec3 EmitMap = texture2D(g_sSamplerThree, VOutTexCoord0.xy).rgb;
		#endif
	#endif
	
	ColorMap *= g_cDiffuseColor;
 	
	N = normalize(N);
	vec3 worldEyeVec = vec3( -VOutReflect0.w, -VOutReflect1.w, -VOutReflect2.w ); 
	vec3 worldNormal = vec3( dot(VOutReflect0.xyz, N), dot(VOutReflect1.xyz, N), dot(VOutReflect2.xyz, N) );
	vec3 reflVect = reflect( worldEyeVec, worldNormal ); 

	#ifdef USE_SHADOWS
		vec4 ReflectionMap = textureCube(g_sSamplerFiveCube, reflVect); 
	#else
		vec4 ReflectionMap =  textureCube(g_sSamplerOneCube, reflVect); 
	#endif

	#ifdef USE_SPECMAP
		ColorMap.rgb += SpecMap*ReflectionMap.rgb; 
	#else
		float emitLuminosity = (EmitMap.r*0.33 + EmitMap.g*0.59 + EmitMap.b*0.11);
		ColorMap.rgb = ColorMap.rgb + ( (1.0-emitLuminosity)*ReflectionMap.rgb); // so that emmisive areas not so shiney  
	#endif
	
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, N, VOutLightDir0TS, VOutLightDir1TS, VOutEyeDirTS, light0, light1);
	
	#ifdef USE_SHADOWS
		vec3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
		totalLight = clamp(totalLight,0.0,1.0);
		gl_FragColor.rgb = EmitMap.rgb + (1.0-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*g_cSpecularColor.rgb );
	#else
		vec3 totalLight = light0.rgb + light1.rgb;
		totalLight = clamp(totalLight,0.0,1.0);
		vec3 negLight = vec3(1.0,1.0,1.0) - totalLight;
		gl_FragColor.rgb = EmitMap.rgb + negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*g_cSpecularColor.rgb;
	#endif
	
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, light etc doesn't affect it.

	if ( g_iFogParams.x > 0.0)
    {
		gl_FragColor.rgba = computeFog( VOutPosView.z, gl_FragColor.rgba );
    }
}
#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
