/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//
// One diffuse map along with a normal map, with and without shadows. A common demo shader
// with 'proper' assets 
//
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 OPACITY0
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 OPACITY0

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1BumpND LD* T1 NORMAL0
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1BumpND LD* T1 SHADOWMAP NORMAL0

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1BumpND LD* T1 NORMAL0 INSTANCED DEFINE:HKG_INSTANCING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1BumpND LD* T1 SHADOWMAP NORMAL0 INSTANCED DEFINE:HKG_INSTANCING

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1BumpND LD* T1 NORMAL0 SKINNED DEFINE:HKG_SKINNING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1BumpND LD* T1 SHADOWMAP NORMAL0 SKINNED DEFINE:HKG_SKINNING

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T2 DIFFUSE0 NORMAL1 DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T2 SHADOWMAP DIFFUSE0 NORMAL1 DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T2 DIFFUSE0 NORMAL1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T2 SHADOWMAP DIFFUSE0 NORMAL1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 IRRADIANCE DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 IRRADIANCE DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 IRRADIANCE INSTANCED DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 IRRADIANCE INSTANCED DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 IRRADIANCE SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 IRRADIANCE SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 IRRADIANCE INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 IRRADIANCE INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 IRRADIANCE RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 IRRADIANCE RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 IRRADIANCE INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:NO_SPEC
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 IRRADIANCE INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS DEFINE:NO_SPEC

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixBumpBlend LD* T2 DIFFUSE0 DIFFUSE0 DIFFUSE1 NORMAL0 NORMAL0 DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneBumpBlend LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE0 DIFFUSE1 NORMAL0 NORMAL0 DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixBumpBlend LD* T2 DIFFUSE0 DIFFUSE0 DIFFUSE1 NORMAL0 NORMAL0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneBumpBlend LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE0 DIFFUSE1 NORMAL0 NORMAL0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixBumpBlend LD* T2 DIFFUSE0 DIFFUSE0 DIFFUSE1 NORMAL0 NORMAL0 INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneBumpBlend LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE0 DIFFUSE1 NORMAL0 NORMAL0 INSTANCED SKINNED DEFINE:HKG_INSTANCING DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixBumpBlend LD* T2 DIFFUSE0 DIFFUSE0 DIFFUSE1 NORMAL0 NORMAL0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneBumpBlend LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE0 DIFFUSE1 NORMAL0 NORMAL0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixBumpBlend LD* T2 DIFFUSE0 DIFFUSE0 DIFFUSE1 NORMAL0 NORMAL0 RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneBumpBlend LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE0 DIFFUSE1 NORMAL0 NORMAL0 RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixBumpBlend LD* T2 DIFFUSE0 DIFFUSE0 DIFFUSE1 NORMAL0 NORMAL0 INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneBumpBlend LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE0 DIFFUSE1 NORMAL0 NORMAL0 INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_INSTANCING DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS

#include "CommonHeader.hlslh"
#include "CommonVertexShaders.hlslh"

// Pixel shaders
#ifdef TWO_TCOORDS
pixelOutput PixT1Bump( vertexOutputT2B In )
#else
#	ifdef HKG_IRRADIANCE_MAPS
pixelOutput PixT1Bump( vertexOutputT1BDim In )
#	else
pixelOutput PixT1Bump( vertexOutputT1B In )
#	endif
#endif
{

	HKG_TEST_DEPTH_PEEL

	pixelOutput Output;
	
	float4 ColorMap = float4(1,1,1,1);
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP
	#ifdef TWO_TCOORDS
		 ColorMap = _sample0( In.texCoord01.xy);
	#else
		 ColorMap = _sample0( In.texCoord0.xy);
	#endif	
#endif

#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		#ifdef TWO_TCOORDS
			N = _sample1(In.texCoord01.zw).xyz*2.0 - 1.0;
		#else
			N = _sample1(In.texCoord0.xy).xyz*2.0 - 1.0;
		#endif
		N = normalize(N);
	#endif
#endif
	
	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - getAlphaClipTolerance() );

	float3 litColor;
#ifdef HKG_IRRADIANCE_MAPS
	{
		float3 SpecMap = 1, shadowedColor;
		LightPixelWithCubeMap(ColorMap, SpecMap, N, In.tangToWorld0, In.tangToWorld1, In.tangToWorld2, shadowedColor, litColor);
	}
#else
	{
		float4 light0 = 1;
		float3 light1 = 0;
	#if ENABLE_LIGHTING
		LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
	#endif
		
		float3 totalLight = light0.rgb + light1.rgb;
		saturate(totalLight);
		float3 negLight = float3(1,1,1) - totalLight;
		litColor = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*g_cSpecularColor.rgb;
	}
#endif

	Output.color.rgb 	= litColor;
	Output.color.a 		= ColorMap.a; // modulate alpha as is, light doesn't affect it.
	
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
	
	if ( getColorRangeCorrectionEnabled() )
	{
		Output.color.rgb *= getExposurePow2();
		Output.color.rgb = pow(Output.color.rgb, getInvGamma() ); 
	}

	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}

pixelOutput PixBumpBlend( vertexOutputT2B In )
{

	HKG_TEST_DEPTH_PEEL

	pixelOutput Output;
	
	float4 ColorMap = float4(1,1,1,1);
	float3 N = float3(0,0,1);

	// Get the blend factor
	float fBlend = 1.0;
	{
#if defined(HKG_DX10) || defined(HKG_DX11)	
		fBlend = _sample2(In.texCoord01.zw).r;	//Auto-generated decal map
#elif defined(HKG_PLATFORM_XBOX360)
		fBlend = _sample2(In.texCoord01.zw).a;
#else
		fBlend = _sample2(In.texCoord01.zw).b;
#endif
	}
	
#if ENABLE_DIFFUSE_MAP
	{
		float4 texel0 = _sample0(In.texCoord01.xy);
		float4 texel1 = _sample1(In.texCoord01.xy);
		ColorMap = lerp(texel1, texel0, fBlend);
	}
#endif

#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
	{
		float3 nrm0	= _sample3(In.texCoord01.xy).rgb;
		float3 nrm1	= _sample4(In.texCoord01.xy).rgb;
		N = normalize(lerp(nrm1, nrm0, fBlend) * 2.0 - 1.0);		
	}
	#endif
#endif
	
	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - getAlphaClipTolerance() );

	float3 litColor;
	{
		float4 light0 = 1;
		float3 light1 = 0;
	#if ENABLE_LIGHTING
		LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
	#endif
		
		float3 totalLight = light0.rgb + light1.rgb;
		saturate(totalLight);
		float3 negLight = float3(1,1,1) - totalLight;
		litColor = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*g_cSpecularColor.rgb;
	}

	Output.color.rgb 	= litColor;
	Output.color.a 		= ColorMap.a; // modulate alpha as is, light doesn't affect it.
	
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
	
	if ( getColorRangeCorrectionEnabled() )
	{
		Output.color.rgb *= getExposurePow2();
		Output.color.rgb = pow(Output.color.rgb, getInvGamma() ); 
	}

	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}

// Pixel shaders
pixelOutput PixT1BumpND( vertexOutputT1B In )
{
	HKG_TEST_DEPTH_PEEL

	float4 ColorMap = g_cDiffuseColor;
	clip( ColorMap.a - getAlphaClipTolerance() );

	float3 N = float3(0,0,1); 
	
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample0(In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#endif
#endif
	
	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	pixelOutput Output;
	float3 totalLight = light0.rgb + light1.rgb;
	saturate(totalLight);
	float3 negLight = float3(1,1,1) - totalLight;
	
	Output.color.rgb = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*g_cSpecularColor.rgb;
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
	
	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}
 
#ifdef TWO_TCOORDS
pixelOutput PixShadowSceneT1Bump( vertexOutputT2B In )
#else
#	ifdef HKG_IRRADIANCE_MAPS
pixelOutput PixShadowSceneT1Bump( vertexOutputT1BDim In )
#	else
pixelOutput PixShadowSceneT1Bump( vertexOutputT1B In )
#	endif
#endif
{
	HKG_TEST_DEPTH_PEEL

	pixelOutput Output;
    	  
	float lightAmount = getLightAmountShadow( In.posView );
		
	float4 ColorMap = float4(1,1,1,1);
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP
	#ifdef TWO_TCOORDS
		ColorMap = _sample4(In.texCoord01.xy);
	#else
		ColorMap = _sample4(In.texCoord0);
	#endif
#endif

#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		#ifdef TWO_TCOORDS
			N = _sample5(In.texCoord01.zw).xyz*2.0 - 1.0;
		#else
			N = _sample5(In.texCoord0).xyz*2.0 - 1.0;
		#endif	
		N = normalize(N);
	#endif
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - getAlphaClipTolerance() );

	// Lighting
	float3 shadowedColor, litColor;
#ifdef HKG_IRRADIANCE_MAPS
	{
		float3 SpecMap = 1;
		LightPixelWithCubeMap(ColorMap, SpecMap, N, In.tangToWorld0, In.tangToWorld1, In.tangToWorld2, shadowedColor, litColor);
	}
#else
	{
		float4 light0 = 1;
		float3 light1 = 0;
	#if ENABLE_LIGHTING
		LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
	#endif
		
		float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
		saturate(totalLight);
		
		shadowedColor	= (light1.rgb + g_cAmbientColor.rgb) * ColorMap.rgb;
		litColor		= totalLight * ColorMap.rgb + light0.www * g_cSpecularColor.rgb;
	}
#endif	
	
	Output.color.rgb 	= (1 - lightAmount) * shadowedColor + lightAmount * litColor;
	Output.color.a 		= ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
	
	if ( getColorRangeCorrectionEnabled() )
	{
		Output.color.rgb *= getExposurePow2();
		Output.color.rgb = pow(Output.color.rgb, getInvGamma() ); 
	}
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

pixelOutput PixShadowSceneBumpBlend( vertexOutputT2B In )
{
	HKG_TEST_DEPTH_PEEL

	pixelOutput Output;
    	  
	float lightAmount = getLightAmountShadow( In.posView );
		
	float4 ColorMap = float4(1,1,1,1);
	float3 N = float3(0,0,1); 
	
	// Get the blend factor
	float fBlend = 1.0;
	{
#if defined(HKG_DX10) || defined(HKG_DX11)	
		fBlend = _sample6(In.texCoord01.zw).r;	//Auto-generated decal map
#elif defined(HKG_PLATFORM_XBOX360)
		fBlend = _sample6(In.texCoord01.zw).a;
#else
		fBlend = _sample6(In.texCoord01.zw).b;
#endif
	}
	
#if ENABLE_DIFFUSE_MAP
	{
		float4 texel0 = _sample4(In.texCoord01.xy);
		float4 texel1 = _sample5(In.texCoord01.xy);
		ColorMap = lerp(texel1, texel0, fBlend);
	}
#endif

#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
	{
		float3 nrm0	= _sample7(In.texCoord01.xy).rgb;
		float3 nrm1	= _sample8(In.texCoord01.xy).rgb;
		N = normalize(lerp(nrm1, nrm0, fBlend) * 2.0 - 1.0);		
	}
	#endif
#endif
	
	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - getAlphaClipTolerance() );

	// Lighting
	float3 shadowedColor, litColor;
	{
		float4 light0 = 1;
		float3 light1 = 0;
	#if ENABLE_LIGHTING
		LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
	#endif
		
		float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
		saturate(totalLight);
		
		shadowedColor	= (light1.rgb + g_cAmbientColor.rgb) * ColorMap.rgb;
		litColor		= totalLight * ColorMap.rgb + light0.www * g_cSpecularColor.rgb;
	}
	
	Output.color.rgb 	= (1 - lightAmount) * shadowedColor + lightAmount * litColor;
	Output.color.a 		= ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
	
	if ( getColorRangeCorrectionEnabled() )
	{
		Output.color.rgb *= getExposurePow2();
		Output.color.rgb = pow(Output.color.rgb, getInvGamma() ); 
	}
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

pixelOutput PixShadowSceneT1BumpND( vertexOutputT1B In )
{
	HKG_TEST_DEPTH_PEEL

	pixelOutput Output;
    
    float lightAmount = getLightAmountShadow( In.posView );
    	
	float4 ColorMap = g_cDiffuseColor;
	clip( ColorMap.a - getAlphaClipTolerance() );

	float3 N = float3(0,0,1); 
	
#if ENABLE_NORMAL_MAP
	#if ENABLE_LIGHTING
		N = _sample4(In.texCoord0).xyz*2.0 - 1.0;
		N = normalize(N);
	#endif
#endif

	
	float4 light0 = 1;
	float3 light1 = 0;
#if ENABLE_LIGHTING
	LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
#endif
	
	float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	saturate(totalLight);
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*g_cSpecularColor.rgb );
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
    if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
    
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
