/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBump LD* T2 DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBump LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBumpNS LD* T2 DIFFUSE0 NORMAL0 NORMAL1 DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBumpNS LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBump LD* T2 DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBump LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBumpNS LD* T2 DIFFUSE0 NORMAL0 NORMAL1 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBumpNS LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBump LD* T2 DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBump LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBumpNS LD* T2 DIFFUSE0 NORMAL0 NORMAL1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBumpNS LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBump LD* T2 DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 INSTANCED SKINNED DEFINE:HKG_INSTANCING DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBump LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 INSTANCED SKINNED DEFINE:HKG_INSTANCING DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBumpNS LD* T2 DIFFUSE0 NORMAL0 NORMAL1 INSTANCED SKINNED DEFINE:HKG_INSTANCING DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBumpNS LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 INSTANCED SKINNED DEFINE:HKG_INSTANCING DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBump LD* T2 DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 IRRADIANCE DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBump LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 IRRADIANCE DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14  DEFINE:HKG_SHADOWS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBumpNS LD* T2 DIFFUSE0 NORMAL0 NORMAL1 IRRADIANCE DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBumpNS LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 IRRADIANCE DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14  DEFINE:HKG_SHADOWS

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBump LD* T2 DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 IRRADIANCE SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBump LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 IRRADIANCE SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBumpNS LD* T2 DIFFUSE0 NORMAL0 NORMAL1 IRRADIANCE SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBumpNS LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 IRRADIANCE SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBump LD* T2 DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 IRRADIANCE RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBump LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 IRRADIANCE RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBumpNS LD* T2 DIFFUSE0 NORMAL0 NORMAL1 IRRADIANCE RIGID SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_RIGID_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBumpNS LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 IRRADIANCE RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS 

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBump LD* T2 DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 IRRADIANCE INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBump LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 IRRADIANCE INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBumpNS LD* T2 DIFFUSE0 NORMAL0 NORMAL1 IRRADIANCE INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBumpNS LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 IRRADIANCE INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS

//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBump LD* T2 DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 IRRADIANCE INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBump LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 IRRADIANCE INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBumpNS LD* T2 DIFFUSE0 NORMAL0 NORMAL1 IRRADIANCE INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBumpNS LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 IRRADIANCE INSTANCED SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBump LD* T2 DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 IRRADIANCE INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBump LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 SPECULAR0 IRRADIANCE INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixT2DoubleBumpNS LD* T2 DIFFUSE0 NORMAL0 NORMAL1 IRRADIANCE INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 
//:STYLE VertBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2DoubleBumpNS LD* T2 SHADOWMAP DIFFUSE0 NORMAL0 NORMAL1 IRRADIANCE INSTANCED RIGID SKINNED DEFINE:HKG_RIGID_SKINNING DEFINE:HKG_SKINNING DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_IRRADIANCE_MAPS DEFINE:HKG_CUBEMAP_SLOT13 DEFINE:HKG_CUBEMAP_SLOT14 DEFINE:HKG_SHADOWS

#include "CommonHeader.hlslh"
#include "CommonVertexShaders.hlslh"

// Pixel shaders
#ifdef HKG_IRRADIANCE_MAPS
pixelOutput PixT2DoubleBump( vertexOutputT2BDim In )
#else
pixelOutput PixT2DoubleBump( vertexOutputT2B In )
#endif
{
	HKG_TEST_DEPTH_PEEL

	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP
    ColorMap = _sample0(In.texCoord01.xy);
#endif
	
#if ENABLE_NORMAL_MAP
	float3 N0 = _sample1(In.texCoord01.xy).xyz*4.0 - 2.0;
	float3 N1 = _sample2(In.texCoord01.zw).xyz*2.0 - 1.0;
	N = normalize(N0+N1);
#endif

#if ENABLE_SPEC_MAP
	SpecMap *= _sample3(In.texCoord01.xy).rgb;
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float3 litColor;
#ifdef HKG_IRRADIANCE_MAPS
		{
			float3 shadowedColor;
			LightPixelWithCubeMap(ColorMap, SpecMap, N, In.tangToWorld0, In.tangToWorld1, In.tangToWorld2, shadowedColor, litColor);
		}
#else

		float4 light0 = 1;
		float3 light1 = 0;
	#if ENABLE_LIGHTING
		LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
	#endif
		
		float3 totalLight = light0.rgb + light1.rgb;
		saturate(totalLight);
		float3 negLight = float3(1,1,1) - totalLight;
		litColor = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*SpecMap;
#endif

	pixelOutput Output;	
	Output.color.rgb = litColor;

	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;
    
	return Output; 
}

#ifdef HKG_IRRADIANCE_MAPS
pixelOutput PixT2DoubleBumpNS( vertexOutputT2BDim In )
#else
pixelOutput PixT2DoubleBumpNS( vertexOutputT2B In )
#endif
{
	HKG_TEST_DEPTH_PEEL

	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP
    ColorMap = _sample0(In.texCoord01.xy);
#endif
	
#if ENABLE_NORMAL_MAP
	float3 N0 = _sample1( In.texCoord01.xy).xyz*4.0 - 2.0;
	float3 N1 = _sample2( In.texCoord01.zw).xyz*2.0 - 1.0;
	N = normalize(N0+N1);
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float3 litColor;
#ifdef HKG_IRRADIANCE_MAPS
		{
			float3 shadowedColor;
			LightPixelWithCubeMap(ColorMap, SpecMap, N, In.tangToWorld0, In.tangToWorld1, In.tangToWorld2, shadowedColor, litColor);
		}
#else
		float4 light0 = 1;
		float3 light1 = 0;
	#if ENABLE_LIGHTING
		LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
	#endif
		
		float3 totalLight = light0.rgb + light1.rgb;
		saturate(totalLight);
		float3 negLight = float3(1,1,1) - totalLight;
		litColor = negLight.rgb*g_cAmbientColor.rgb*ColorMap.rgb + totalLight.rgb*ColorMap.rgb + light0.www*SpecMap.rgb;
#endif

	pixelOutput Output;
	Output.color.rgb = litColor;
	Output.color.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}

#ifdef HKG_IRRADIANCE_MAPS
pixelOutput PixShadowSceneT2DoubleBump( vertexOutputT2BDim In )
#else
pixelOutput PixShadowSceneT2DoubleBump( vertexOutputT2B In )
#endif
{
 	HKG_TEST_DEPTH_PEEL

	pixelOutput Output;
    
    float lightAmount = getLightAmountShadow( In.posView );
	
		
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample4(In.texCoord01.xy);
#endif
		
#if ENABLE_NORMAL_MAP
	float3 N0 = _sample5(In.texCoord01.xy).xyz*4.0 - 2.0;
	float3 N1 = _sample6(In.texCoord01.zw).xyz*2.0 - 1.0;
	N = normalize(N0+N1);
#endif

#if ENABLE_SPEC_MAP && !defined(HKG_DEPTH_PEEL)
	SpecMap *= _sample7(In.texCoord01.xy).rgb;
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float3 shadowedColor, litColor;
#ifdef HKG_IRRADIANCE_MAPS
		{
			LightPixelWithCubeMap(ColorMap, SpecMap, N, In.tangToWorld0, In.tangToWorld1, In.tangToWorld2, shadowedColor, litColor);
		}
#else
		float4 light0 = 1;
		float3 light1 = 0;
	#if ENABLE_LIGHTING
		LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
	#endif
		
		float3 totalLight = light0.rgb + light1.rgb;
		saturate(totalLight);
		litColor = totalLight*ColorMap.rgb + light0.www*SpecMap.rgb;
		shadowedColor = (light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb; 
#endif

	Output.color.rgb = (1 - lightAmount) * shadowedColor + lightAmount * litColor;
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }
	
    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

#ifdef HKG_IRRADIANCE_MAPS
pixelOutput PixShadowSceneT2DoubleBumpNS( vertexOutputT2BDim In )
#else
pixelOutput PixShadowSceneT2DoubleBumpNS( vertexOutputT2B In )
#endif
{
	HKG_TEST_DEPTH_PEEL

    pixelOutput Output;
    
  float lightAmount = getLightAmountShadow( In.posView );
	
		
	float4 ColorMap = float4(1,1,1,1);
	float3 SpecMap = g_cSpecularColor.rgb;
	float3 N = float3(0,0,1); 
	
#if ENABLE_DIFFUSE_MAP0
    ColorMap = _sample4(In.texCoord01.xy);
#endif
		
#if ENABLE_NORMAL_MAP
	float3 N0 = _sample5( In.texCoord01.xy).xyz*4.0 - 2.0;
	float3 N1 = _sample6( In.texCoord01.zw).xyz*2.0 - 1.0;
	N = normalize(N0+N1);
#endif

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float3 shadowedColor, litColor;
#ifdef HKG_IRRADIANCE_MAPS
		{
			LightPixelWithCubeMap(ColorMap, SpecMap, N, In.tangToWorld0, In.tangToWorld1, In.tangToWorld2, shadowedColor, litColor);
		}
#else
		float4 light0 = 1;
		float3 light1 = 0;
	#if ENABLE_LIGHTING
		LightPixel( In.posView, N, In.toLightDir0TS, In.toLightDir1TS, In.eyeDirTS, light0, light1);
	#endif
		
		float3 totalLight = light0.rgb + light1.rgb;
		saturate(totalLight);
		shadowedColor = (light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb;
		litColor = totalLight*ColorMap.rgb + light0.www*SpecMap.rgb;
		
#endif
	
	Output.color.rgb = (1 - lightAmount) * shadowedColor + lightAmount * litColor;
	Output.color.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

    Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x;
    Output.pzDepth.a = Output.color.a;

    return Output;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
