/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//
// One or Two diffuse maps, along with a specular map, so flat shiney pre lit things mostly, with and without shadows. The most common demo shaders 
// with 'proper' assets. 
// Normal:
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 SPECULAR0 DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 SPECULAR0 DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 DIFFUSE0 SPECULAR0 DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 DIFFUSE0 LIGHTMAP1 SPECULAR0 DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 SPECULAR0 DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 SPECULAR0 DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 SPECULAR0 DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 SPECULAR0 DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 SPECULAR0 SPECULAR0 DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 SPECULAR0 SPECULAR0 DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 DIFFUSE0 SPECULAR0 SPECULAR0 DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 DIFFUSE0 LIGHTMAP1 SPECULAR0 SPECULAR0 DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 SPECULAR0 SPECULAR0 DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 SPECULAR0 SPECULAR0 DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 SPECULAR0 SPECULAR0 DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 SPECULAR0 SPECULAR0 DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 DIFFUSE0 LIGHTMAP1 OPACITY0 DEFINE:TWO_TCOORDS DEFINE:OPACITY
// Skinned:
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 DIFFUSE0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 DIFFUSE0 LIGHTMAP1 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 SPECULAR0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 SPECULAR0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 DIFFUSE0 SPECULAR0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 DIFFUSE0 LIGHTMAP1 SPECULAR0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 SPECULAR0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 SPECULAR0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 SPECULAR0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 SPECULAR0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR
// Skinned:
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 SPECULAR0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 SPECULAR0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 DIFFUSE0 SPECULAR0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 DIFFUSE0 LIGHTMAP1 SPECULAR0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 SPECULAR0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 SPECULAR0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 SPECULAR0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 SPECULAR0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 SPECULAR0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 SPECULAR0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 DIFFUSE0 SPECULAR0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 DIFFUSE0 LIGHTMAP1 SPECULAR0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 SPECULAR0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 SPECULAR0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 SPECULAR0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 SPECULAR0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR



#include "CommonHeader.hlslh"
#include "CommonSampleHeader.hlslh"
#include "CommonVertexShaders.hlslh"

// Pixel shaders
 
 // Pixel shaders
pixelOutput PixT1( vertexOutputT1N In )
{
	HKG_TEST_DEPTH_PEEL

	float lightAmount = 1;
	#ifdef HKG_SHADOWS
		lightAmount = getLightAmountShadow( In.posView );
	#endif
	
#ifndef IGNORE_DIFFUSE
	#ifndef HKG_SHADOWS
		float4 ColorMap = _sample0(In.texCoord0.xy);
		ColorMap = ColorMap + (_sample1(In.texCoord0.xy) * 0.6);
	#else
		float4 ColorMap = _sample4(In.texCoord0.xy);
		ColorMap = ColorMap + (_sample5(In.texCoord0.xy) * 0.6);
	#endif
	ColorMap *= g_cDiffuseColor;
#else
	float4 ColorMap = g_cDiffuseColor;
#endif
	
#ifdef SPECULAR
	#ifndef HKG_SHADOWS
		float3 SpecMap = g_cSpecularColor.rgb * _sample2( In.texCoord0.xy).rgb;
	#else
		float3 SpecMap = g_cSpecularColor.rgb * _sample6( In.texCoord0.xy).rgb;
	#endif
#else
	float3 SpecMap = g_cSpecularColor.rgb;
#endif
	
	
	float4 light0 = 1;
	float3 light1 = 0;
	LightPixel( In.posView, normalize(In.normal), In.toLightDir0OS, In.toLightDir1OS, In.eyeDirOS, light0, light1);

	
	float3 specularLight = light0.www*SpecMap;
	
	float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	pixelOutput Output;
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + specularLight );
	Output.color.a = ColorMap.a; // a few neweer demos use rhe fact that specular is aditional on alpha channel
	
	clip( Output.color.a - ALPHA_DISCARD_TOLERANCE );
	
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
	}

	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;
	 return Output; 
}


pixelOutput PixT2( vertexOutputT2N In )
{
	
	HKG_TEST_DEPTH_PEEL
  
    float lightAmount = 1;
	#ifdef HKG_SHADOWS
		lightAmount = getLightAmountShadow( In.posView );
	#endif
	
#ifndef HKG_SHADOWS
    float4 ColorMap = _sample0(In.texCoord01.xy);
	ColorMap = ColorMap + (_sample1(In.texCoord01.zw) * 0.6);
#else
    float4 ColorMap = _sample4(In.texCoord01.xy);
	ColorMap = ColorMap + (_sample5(In.texCoord01.zw) * 0.6);
#endif

#ifdef SPECULAR
	#ifndef HKG_SHADOWS
		float3 SpecMap = g_cSpecularColor.rgb * _sample2( In.texCoord01.xy).rgb;
	#else
		float3 SpecMap = g_cSpecularColor.rgb * _sample6( In.texCoord01.xy).rgb;
	#endif
#else
	float3 SpecMap = g_cSpecularColor.rgb;
#endif
	ColorMap *= g_cDiffuseColor;

	float4 light0 = 1;
	float3 light1 = 0;
	LightPixel( In.posView, normalize(In.normal), In.toLightDir0OS, In.toLightDir1OS, In.eyeDirOS, light0, light1);

	float3 specularLight = light0.www*SpecMap;
	
	float3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	pixelOutput Output;
	Output.color.rgb = (1-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + specularLight );
	Output.color.a = ColorMap.a; // a few neweer demos use rhe fact that specular is aditional on alpha channel
	
	
	clip( Output.color.a - ALPHA_DISCARD_TOLERANCE );
	
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
	}

	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}


// Pixel shaders
pixelOutput PixT2LM( vertexOutputT2N In )
{
	HKG_TEST_DEPTH_PEEL

//	#ifdef HKG_SHADOWS
//		float lightAmount = getLightAmountShadow( In.posView );
//	#endif
		
	float3 SpecMap = g_cSpecularColor.rgb;
#ifndef HKG_SHADOWS
    float4 ColorMap= _sample0( In.texCoord01.xy);
	float3 LightMap = _sample1( In.texCoord01.zw).rgb;
#else
    float4 ColorMap= _sample4( In.texCoord01.xy);
	float3 LightMap = _sample5( In.texCoord01.zw).rgb;
#endif

#ifdef SPECULAR
	#ifndef HKG_SHADOWS
		SpecMap *= _sample2(In.texCoord01.xy).rgb;
	#else
		SpecMap *= _sample6(In.texCoord01.xy).rgb;
	#endif	
#elif defined(OPACITY)
	#ifndef HKG_SHADOWS
		ColorMap.a = _sample2(In.texCoord01.xy).r;
	#else
		ColorMap.a = _sample6(In.texCoord01.xy).r;
	#endif
#endif	

	ColorMap *= g_cDiffuseColor;
	clip( ColorMap.a - ALPHA_DISCARD_TOLERANCE );

	float4 light0 = 1;
	float3 light1 = 0;
	LightPixel( In.posView, normalize(In.normal), In.toLightDir0OS, In.toLightDir1OS, In.eyeDirOS, light0, light1);
	
	// Green == 59% of the perceived luminosity, while the red and blue channels account for just 30% and 11%
	float luminosity = (LightMap.r*0.33 + LightMap.g*0.59 + LightMap.b*0.11);
	float lightMapLum = saturate( luminosity );
	float3 specularLight = lightMapLum*light0.www*g_cSpecularColor.rgb*SpecMap.rgb;
	
	float3 gammaCorrectLight = ColorMap.rgb*LightMap.rgb;
	//gammaCorrectLight *= 1+lightAmount; // ColorMap is already gamma corrected , but LightMap is not and came from a EXR say in Max. Doing proper 2.2 gamma etc on it seems to wash it out, just *2 looks ok for now	
	//gammaCorrectLight *= getExposurePow2();
	//gammaCorrectLight = pow(gammaCorrectLight, getInvGamma() ); 
	
	pixelOutput Output;
	Output.color.rgb = gammaCorrectLight.rgb + specularLight;
	Output.color.a = ColorMap.a ; 
	
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
    }

	Output.pzDepth.rgb = In.posView.z * g_iDepthParams.x ;
    Output.pzDepth.a = Output.color.a;

    return Output; 
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
