/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//
// One or Two diffuse maps, along with a specular map, so flat shiney pre lit things mostly, with and without shadows. The most common demo shaders 
// with 'proper' assets. 
//
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 SPECULAR0 DEFINE:SPECULAR DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 SPECULAR0 DEFINE:TWO_TCOORDS DEFINE:SPECULAR DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 DIFFUSE0 DEFINE:NO_SPEC DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 DEFINE:TWO_TCOORDS DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 DIFFUSE0 SPECULAR0 DEFINE:TWO_TCOORDS DEFINE:SPECULAR DEFINE:TEX_COORD0 DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 DIFFUSE0 LIGHTMAP1 SPECULAR0 DEFINE:TWO_TCOORDS DEFINE:SPECULAR DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 DIFFUSE0 LIGHTMAP1 OPACITY0 DEFINE:TWO_TCOORDS DEFINE:OPACITY DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 SPECULAR0 DEFINE:HKG_SHADOWS DEFINE:SPECULAR DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 DEFINE:NO_SPEC DEFINE:HKG_SHADOWS DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 SPECULAR0 DEFINE:HKG_SHADOWS DEFINE:SPECULAR DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 SPECULAR0 DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 SPECULAR0 DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 OPACITY0 DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:OPACITY DEFINE:TEX_COORD0 DEFINE:TEX_COORD1

//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:SPECULAR DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:SPECULAR DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 DIFFUSE0 SKINNED DEFINE:HKG_SKINNING DEFINE:NO_SPEC DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 DIFFUSE0 SKINNED DEFINE:HKG_SKINNING SPECULAR0 DEFINE:TWO_TCOORDS DEFINE:SPECULAR DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 DIFFUSE0 LIGHTMAP1 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:SPECULAR DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 DIFFUSE0 LIGHTMAP1 OPACITY0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:OPACITY DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_SHADOWS DEFINE:SPECULAR DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 SKINNED DEFINE:HKG_SKINNING DEFINE:NO_SPEC DEFINE:HKG_SHADOWS DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:HKG_SHADOWS DEFINE:SPECULAR DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 OPACITY0 SKINNED DEFINE:HKG_SKINNING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:OPACITY DEFINE:TEX_COORD0 DEFINE:TEX_COORD1

//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 DIFFUSE0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:SPECULAR DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:SPECULAR DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T1 DIFFUSE0 DIFFUSE0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:NO_SPEC DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 DIFFUSE0 DIFFUSE1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T1 DIFFUSE0 DIFFUSE0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING  DEFINE:SPECULAR DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 DIFFUSE0 LIGHTMAP1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 DIFFUSE0 LIGHTMAP1 OPACITY0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:OPACITY DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:HKG_SHADOWS DEFINE:SPECULAR DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:NO_SPEC DEFINE:HKG_SHADOWS  DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT1 LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:HKG_SHADOWS DEFINE:SPECULAR DEFINE:TEX_COORD0
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2 LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:SPECULAR DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertNoBumpPP HK_NULL HK_NULL HK_NULL PixT2LM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 OPACITY0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TWO_TCOORDS DEFINE:HKG_SHADOWS DEFINE:OPACITY DEFINE:TEX_COORD0 DEFINE:TEX_COORD1

#pragma include(CommonHeader.glslh)
#pragma include(CommonVertexShaders.glslh)


// Pixel shaders
#ifdef ENTRYPOINT_PixT1
varying HIGHP vec4 VOutTexCoord0;

varying HIGHP vec3 VOutNormal;
varying HIGHP vec3 VOutPosView;
varying HIGHP vec3 VOutLightDir0OS;
varying HIGHP vec3 VOutLightDir1OS;
varying HIGHP vec3 VOutEyeDirOS;

void main()
{
 
#ifndef HKG_SHADOWS
	float lightAmount = 1.0;
    vec4 ColorMap = texture2D(g_sSamplerZero,VOutTexCoord0.xy);
	ColorMap = ColorMap + (texture2D(g_sSamplerOne,VOutTexCoord0.xy) * 0.6);
#else
    float lightAmount = getLightAmountShadow( VOutPosView ); 
	vec4 ColorMap = texture2D(g_sSamplerFour,VOutTexCoord0.xy);
	ColorMap = ColorMap + (texture2D(g_sSamplerFive,VOutTexCoord0.xy) * 0.6);
#endif
	
#ifdef SPECULAR
	#ifndef HKG_SHADOWS
		vec3 SpecMap = g_cSpecularColor.rgb * texture2D(g_sSamplerTwo, VOutTexCoord0.xy).rgb;
	#else
		vec3 SpecMap = g_cSpecularColor.rgb * texture2D(g_sSamplerSix, VOutTexCoord0.xy).rgb;
	#endif
#else
	vec3 SpecMap = g_cSpecularColor.rgb;
#endif
	
	ColorMap *= g_cDiffuseColor;
	
	vec3 N = normalize(VOutNormal);
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, N, VOutLightDir0OS, VOutLightDir1OS, VOutEyeDirOS, light0, light1);
	
	#ifndef HKG_SHADOWS
		vec3 totalLight = light0.rgb + light1.rgb;
		totalLight = clamp(totalLight,0.0,1.0);
		vec3 negLight = vec3(1.0,1.0,1.0) - totalLight;
		gl_FragColor.rgb = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*SpecMap.rgb;
	#else
		vec3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
		totalLight = clamp(totalLight,0.0,1.0);
		gl_FragColor.rgb = (1.0-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap.rgb );
	#endif

	gl_FragColor.a= ColorMap.a; // a few neweer demos use rhe fact that specular is aditional on alpha channel
	
	COMPUTE_FOG
}
#endif

#ifdef ENTRYPOINT_PixT2
varying HIGHP vec4 VOutTexCoord0;

varying HIGHP vec3 VOutNormal;
varying HIGHP vec3 VOutPosView;
varying HIGHP vec3 VOutLightDir0OS;
varying HIGHP vec3 VOutLightDir1OS;
varying HIGHP vec3 VOutEyeDirOS;
void main()
{

#ifndef HKG_SHADOWS
    float lightAmount = 1.0;
	vec4 ColorMap = texture2D(g_sSamplerZero,VOutTexCoord0.xy);
	ColorMap = ColorMap + (texture2D(g_sSamplerOne,VOutTexCoord0.zw) * 0.6);
#else
    float lightAmount = getLightAmountShadow( VOutPosView ); 
	vec4 ColorMap = texture2D(g_sSamplerFour,VOutTexCoord0.xy);
	ColorMap = ColorMap + (texture2D(g_sSamplerFive,VOutTexCoord0.zw) * 0.6);
#endif

#ifdef SPECULAR
	#ifndef HKG_SHADOWS
		vec3 SpecMap = g_cSpecularColor.rgb * texture2D(g_sSamplerTwo, VOutTexCoord0.xy).rgb;
	#else
		vec3 SpecMap = g_cSpecularColor.rgb * texture2D(g_sSamplerSix, VOutTexCoord0.xy).rgb;
	#endif
#else
	vec3 SpecMap = g_cSpecularColor.rgb;
#endif
	ColorMap *= g_cDiffuseColor;

	vec3 N = normalize(VOutNormal);
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, N, VOutLightDir0OS, VOutLightDir1OS, VOutEyeDirOS, light0, light1);
	
	#ifndef HKG_SHADOWS
		vec3 totalLight = light0.rgb + light1.rgb;
		totalLight = clamp(totalLight,0.0,1.0);
		vec3 negLight = vec3(1.0,1.0,1.0) - totalLight;
		gl_FragColor.rgb = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*SpecMap.rgb;
	#else
		vec3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
		totalLight = clamp(totalLight,0.0,1.0);
		gl_FragColor.rgb = (1.0-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap.rgb );
	#endif
	
	gl_FragColor.a= ColorMap.a; // a few neweer demos use rhe fact that specular is aditional on alpha channel
	
	COMPUTE_FOG
}
#endif

#ifdef ENTRYPOINT_PixT2LM
varying HIGHP vec4 VOutTexCoord0;

varying HIGHP vec3 VOutNormal;
varying HIGHP vec3 VOutPosView;
varying HIGHP vec3 VOutLightDir0OS;
varying HIGHP vec3 VOutLightDir1OS;

varying HIGHP vec3 VOutEyeDirOS;

// Pixel shaders
void main()
{
	vec3 SpecMap = g_cSpecularColor.rgb;
#ifndef HKG_SHADOWS
    float lightAmount = 1.0;
	vec4 ColorMap= texture2D(g_sSamplerZero, VOutTexCoord0.xy);
	vec3 LightMap = texture2D(g_sSamplerOne, VOutTexCoord0.zw).rgb;
#else
    float lightAmount = getLightAmountShadow( VOutPosView ); 
	vec4 ColorMap= texture2D(g_sSamplerFour, VOutTexCoord0.xy);
	vec3 LightMap = texture2D(g_sSamplerFive,VOutTexCoord0.zw).rgb;
#endif

#ifdef SPECULAR
	#ifndef HKG_SHADOWS
		SpecMap *= texture2D(g_sSamplerTwo,VOutTexCoord0.xy).rgb;
	#else
		SpecMap *= texture2D(g_sSamplerSix,VOutTexCoord0.xy).rgb;
	#endif	
#elif defined(OPACITY)
	#ifndef HKG_SHADOWS
		ColorMap.a = texture2D(g_sSamplerTwo,VOutTexCoord0.xy).r;
	#else
		ColorMap.a = texture2D(g_sSamplerSix,VOutTexCoord0.xy).r;
	#endif
#endif	

	ColorMap *= g_cDiffuseColor;
	
	vec3 N = normalize(VOutNormal);
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(0.0,0.0,0.0);
	LightPixel( VOutPosView, N, VOutLightDir0OS, VOutLightDir1OS, VOutEyeDirOS, light0, light1);
	
	// Green == 59% of the perceived luminosity, while the red and blue channels account for just 30% and 11%
	float luminosity = (LightMap.r*0.33 + LightMap.g*0.59 + LightMap.b*0.11);
	float lightMapLum = clamp( luminosity,0.0,1.0 );
	vec3 specularLight = lightMapLum*light0.www*g_cSpecularColor.rgb*SpecMap.rgb;
	
	gl_FragColor.rgb = ColorMap.rgb*LightMap.rgb + lightAmount*specularLight;
	gl_FragColor.a = ColorMap.a ; 
	
	COMPUTE_FOG
}
#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
