/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//
// One or Two diffuse maps, along with a normal and specular map, with and without shadows. The most common demo shaders 
// with 'proper' assets. These will currently also allow loading of a gloss map, but will ignore it
//
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 DEFINE:TEX_COORD0 
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0 DEFINE:TEX_COORD0 
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 DEFINE:TEX_COORD0 DEFINE:DECAL
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 DEFINE:TEX_COORD0 DEFINE:DECAL DEFINE:NO_SPEC
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0 DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0 DEFINE:TEX_COORD0 DEFINE:DECAL
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 GLOSS0 DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 DEFINE:TEX_COORD0 
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 NORMAL0 DEFINE:TEX_COORD0 DEFINE:NO_SPEC DEFINE:DECAL
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 DEFINE:TEX_COORD0 DEFINE:DECAL
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0 DEFINE:TEX_COORD0 
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0 DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 GLOSS0 DEFINE:TEX_COORD0 DEFINE:TEX_COORD1

//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:DECAL
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:DECAL
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 GLOSS0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:DECAL
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 GLOSS0 SKINNED DEFINE:HKG_SKINNING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1

//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:DECAL
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT2Bump LD* T2 DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT1Bump LD* T1 DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:DECAL
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixT2BumpLM LD* T2 DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 DIFFUSE0 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:DECAL
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT1Bump LD* T1 SHADOWMAP DIFFUSE0 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2Bump LD* T2 SHADOWMAP DIFFUSE0 DIFFUSE1 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1
//:STYLE VertOneLightBump HK_NULL HK_NULL HK_NULL PixShadowSceneT2BumpLM LD* T2 SHADOWMAP DIFFUSE0 LIGHTMAP1 NORMAL0 SPECULAR0 GLOSS0 INSTANCED DEFINE:HKG_INSTANCING DEFINE:TEX_COORD0 DEFINE:TEX_COORD1

#pragma include(CommonHeader.glslh)
#pragma include(CommonVertexShaders.glslh)


// Pixel shaders
#ifdef ENTRYPOINT_PixT2Bump
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;

varying HIGHP vec3 VOutLightDir0TS;
varying HIGHP vec3 VOutLightDir1TS;
varying HIGHP vec3 VOutEyeDirTS;
varying HIGHP vec3 VOutPosView; 
void main()
{
	vec4 ColorMap = vec4(1.0,1.0,1.0,1.0);
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0.0,0.0,1.0); 
	
    ColorMap = texture2D(g_sSamplerZero, VOutTexCoord0.xy);
	ColorMap = ColorMap + (texture2D(g_sSamplerOne, VOutTexCoord1.xy) * 0.6);
	
	N = texture2D(g_sSamplerTwo, VOutTexCoord0.xy).xyz*2.0 - 1.0;
	N = normalize(N);

#ifndef NO_SPEC	
	SpecMap *= texture2D(g_sSamplerThree, VOutTexCoord0.xy).rgb;
#endif

	ColorMap *= g_cDiffuseColor;
	
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(1.0,1.0,1.0);
	LightPixel( VOutPosView, N, VOutLightDir0TS, VOutLightDir1TS, VOutEyeDirTS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb;
	totalLight = clamp(totalLight,0.0,1.0);
	vec3 negLight = vec3(1.0,1.0,1.0) - totalLight;
	
	gl_FragColor.rgb = negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*SpecMap;
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	
	COMPUTE_FOG
}
#endif


// Pixel shaders
#ifdef ENTRYPOINT_PixT2BumpLM
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;

varying HIGHP vec3 VOutLightDir0TS;
varying HIGHP vec3 VOutLightDir1TS;
varying HIGHP vec3 VOutEyeDirTS;
varying HIGHP vec3 VOutPosView; 
void main()
{
	vec4 ColorMap = vec4(1.0,1.0,1.0,1.0);
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 LightMap = vec3(1.0,1.0,1.0);
	vec3 N = vec3(0.0,0.0,1.0); 
	
    ColorMap = texture2D(g_sSamplerZero, VOutTexCoord0.xy);
	LightMap = texture2D(g_sSamplerOne, VOutTexCoord1.xy).rgb;

	N = texture2D(g_sSamplerTwo, VOutTexCoord0.xy).xyz*2.0 - 1.0;
	N = normalize(N);

#ifndef NO_SPEC	
	SpecMap *= texture2D(g_sSamplerThree, VOutTexCoord0.xy).rgb;
#endif
	
	ColorMap *= g_cDiffuseColor;
	
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(1.0,1.0,1.0);
	LightPixel( VOutPosView, N, VOutLightDir0TS, VOutLightDir1TS, VOutEyeDirTS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb;
	totalLight = clamp(totalLight,0.0,1.0);
	vec3 negLight = vec3(1.0,1.0,1.0) - totalLight;
	
	gl_FragColor.rgb = negLight*g_cAmbientColor.rgb*ColorMap.rgb*LightMap.rgb + totalLight*ColorMap.rgb*LightMap.rgb + light0.www*SpecMap;
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	
	COMPUTE_FOG
}
#endif
 
 // Pixel shaders
#ifdef ENTRYPOINT_PixT1Bump
varying HIGHP vec2 VOutTexCoord0;

varying HIGHP vec3 VOutLightDir0TS;
varying HIGHP vec3 VOutLightDir1TS;
varying HIGHP vec3 VOutEyeDirTS;
varying HIGHP vec3 VOutPosView; 
void main()
{
	vec4 ColorMap = vec4(1.0,1.0,1.0,1.0);
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0.0,0.0,1.0); 
	vec4 DecalMap = vec4(1.0,1.0,1.0,1.0);
    ColorMap = texture2D(g_sSamplerZero, VOutTexCoord0.xy);
	
#ifdef DECAL
	DecalMap = texture2D(g_sSamplerOne, VOutTexCoord0.xy);
	N = texture2D(g_sSamplerTwo, VOutTexCoord0.xy).xyz * 2.0 - 1.0;
#ifndef NO_SPEC	
	SpecMap *= texture2D(g_sSamplerThree, VOutTexCoord0.xy).rgb;
#endif
#else
	N = texture2D(g_sSamplerOne, VOutTexCoord0.xy).xyz * 2.0 - 1.0;
#ifndef NO_SPEC	
	SpecMap *= texture2D(g_sSamplerTwo, VOutTexCoord0.xy).rgb;
#endif
#endif
	N = normalize(N);
	ColorMap *= g_cDiffuseColor;
	
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(1.0,1.0,1.0);
	LightPixel( VOutPosView, N, VOutLightDir0TS, VOutLightDir1TS, VOutEyeDirTS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb;
	totalLight = clamp(totalLight,0.0,1.0);
	vec3 negLight = vec3(1.0,1.0,1.0) - totalLight;
	
	gl_FragColor.rgb = (negLight*g_cAmbientColor.rgb*ColorMap.rgb + totalLight*ColorMap.rgb + light0.www*SpecMap) * (DecalMap.rgb);
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, light doesn't affect it.
	
	COMPUTE_FOG
 }
#endif

#ifdef ENTRYPOINT_PixShadowSceneT2Bump
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;

varying HIGHP vec3 VOutLightDir0TS;
varying HIGHP vec3 VOutLightDir1TS;
varying HIGHP vec3 VOutEyeDirTS;
varying HIGHP vec3 VOutPosView; 
void main()
{
   
 	float lightAmount = getLightAmountShadow( VOutPosView ); 
		
	vec4 ColorMap = vec4(1.0,1.0,1.0,1.0);
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 N = vec3(0.0,0.0,1.0); 
	
    ColorMap = texture2D(g_sSamplerFour, VOutTexCoord0.xy);
	ColorMap = ColorMap + (texture2D(g_sSamplerFive, VOutTexCoord1.xy) * 0.6);
		
	N = texture2D(g_sSamplerSix, VOutTexCoord0.xy).xyz*2.0 - 1.0;
	N = normalize(N);
#ifndef NO_SPEC	
	SpecMap *= texture2D(g_sSamplerSeven, VOutTexCoord0.xy).rgb;
#endif

	ColorMap *= g_cDiffuseColor;
	
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(1.0,1.0,1.0);
	LightPixel( VOutPosView, N, VOutLightDir0TS, VOutLightDir1TS, VOutEyeDirTS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	totalLight = clamp(totalLight,0.0,1.0);
	gl_FragColor.rgb = (1.0-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap );
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
	COMPUTE_FOG
}
#endif

#ifdef ENTRYPOINT_PixShadowSceneT1Bump
varying HIGHP vec2 VOutTexCoord0;

varying HIGHP vec3 VOutLightDir0TS;
varying HIGHP vec3 VOutLightDir1TS;
varying HIGHP vec3 VOutEyeDirTS;
varying HIGHP vec3 VOutPosView; 
void main()
{
    float lightAmount = getLightAmountShadow( VOutPosView ); 
	vec3 N = vec3(0.0,0.0,1.0); 
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec4 DecalMap = vec4(1.0,1.0,1.0,1.0);
	vec4 ColorMap = texture2D(g_sSamplerFour, VOutTexCoord0.xy);	
#ifdef DECAL
	DecalMap = texture2D(g_sSamplerFive, VOutTexCoord0.xy);
	N = texture2D(g_sSamplerSix, VOutTexCoord0.xy).xyz * 2.0 - 1.0;
#ifndef NO_SPEC	
	SpecMap *= texture2D(g_sSamplerSeven, VOutTexCoord0.xy).rgb;
#endif
#else
	N = texture2D(g_sSamplerFive, VOutTexCoord0.xy).xyz * 2.0 - 1.0;
#ifndef NO_SPEC	
	SpecMap *= texture2D(g_sSamplerSix, VOutTexCoord0.xy).rgb;
#endif
#endif
	N = normalize(N);
	
	ColorMap *= g_cDiffuseColor;
	
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(1.0,1.0,1.0);
	LightPixel( VOutPosView, N, VOutLightDir0TS, VOutLightDir1TS, VOutEyeDirTS, light0, light1);
	
	vec3 totalLight = light0.rgb + light1.rgb  + g_cAmbientColor.rgb;
	totalLight = clamp(totalLight,0.0,1.0);
	gl_FragColor.rgb = ((1.0-lightAmount)*(light1.rgb+g_cAmbientColor.rgb)*ColorMap.rgb + lightAmount*( totalLight*ColorMap.rgb + light0.www*SpecMap)) * DecalMap.rgb;
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
	COMPUTE_FOG

}
#endif

#ifdef ENTRYPOINT_PixShadowSceneT2BumpLM
varying HIGHP vec2 VOutTexCoord0;
varying HIGHP vec2 VOutTexCoord1;

varying HIGHP vec3 VOutLightDir0TS;
varying HIGHP vec3 VOutLightDir1TS;
varying HIGHP vec3 VOutEyeDirTS;
varying HIGHP vec3 VOutPosView; 
void main()
{
    float shadowAmount = getLightAmountShadow( VOutPosView ); 
		
	vec4 ColorMap = vec4(1.0,1.0,1.0,1.0);
	vec3 SpecMap = g_cSpecularColor.rgb;
	vec3 LightMap = vec3(1.0,1.0,1.0);
	vec3 N = vec3(0.0,0.0,1.0); 
	
    ColorMap = texture2D(g_sSamplerFour, VOutTexCoord0.xy);
    LightMap = texture2D(g_sSamplerFive, VOutTexCoord1.xy).rgb;
	N = texture2D(g_sSamplerSix, VOutTexCoord0.xy).xyz*2.0 - 1.0;
	N = normalize(N);

#ifndef NO_SPEC	
	SpecMap *= texture2D(g_sSamplerSeven, VOutTexCoord0.xy).rgb;
#endif

	ColorMap *= g_cDiffuseColor;

	// Green == 59% of the perceived luminosity, while the red and blue channels account for just 30% and 11%
	float luminosity = (LightMap.r*0.33 + LightMap.g*0.59 + LightMap.b*0.11);
	luminosity = clamp( luminosity, 0.0, 1.0 );
	
	float lightMapShadow = 1.0 - (luminosity * 0.5); // 1 when in dark areas
	shadowAmount = max( shadowAmount, lightMapShadow ); // don't have dark shadows in dark lightmap areas
	
	// interp will not preserve length
	vec4 light0 = vec4(1.0,1.0,1.0,1.0);
	vec3 light1 = vec3(1.0,1.0,1.0);
	LightPixel( VOutPosView, N, VOutLightDir0TS, VOutLightDir1TS, VOutEyeDirTS, light0, light1);
	
	// Discard normal map and spec map in darker areas
	light0 *= luminosity; // don't want spec etc in dark areas
		
	gl_FragColor.rgb = (1.0-shadowAmount)*ColorMap.rgb*LightMap.rgb*0.3 + shadowAmount*ColorMap.rgb*LightMap.rgb + (light0.www*SpecMap.rgb*shadowAmount);
	gl_FragColor.a = ColorMap.a; // modulate alpha as is, shadow doesn't affect it.
	
	COMPUTE_FOG
	
}
#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
