/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

//:STYLE VertShadowDepth HK_NULL HK_NULL HK_NULL PixShadowDepth LD* T* SHADOWDEPTH 
//:STYLE VertShadowDepth HK_NULL HK_NULL HK_NULL PixShadowDepth LD* T* SHADOWDEPTH SKINNED DEFINE:HKG_SKINNING 
//:STYLE VertShadowDepth HK_NULL HK_NULL HK_NULL PixShadowDepth LD* T* SHADOWDEPTH INSTANCED DEFINE:HKG_INSTANCING 
 
#pragma include(CommonHeader.glslh)

uniform HIGHP mat4 g_mWorld;
uniform HIGHP mat4 g_mViewProj;
uniform HIGHP mat4 g_mWorldViewProj;

uniform HIGHP vec4 g_vLightShadowStartPosWorld; 

#ifdef ENTRYPOINT_VertShadowDepth
attribute HIGHP vec3 InPosition;  
#ifdef HKG_SKINNING
	attribute BLEND_INDICES_DECL InBlendIndices;
	attribute HIGHP vec3 InBlendWeights;
#endif
#ifdef HKG_INSTANCING
	attribute HIGHP vec4 InTransformRow0;
	attribute HIGHP vec4 InTransformRow1;
	attribute HIGHP vec4 InTransformRow2;
#endif

#ifdef ENABLE_ALPHA_SHADOWS
	attribute HIGHP vec2 InTexCoord0;
	varying HIGHP vec2 VOutTexCoord0;
#endif
varying HIGHP vec3 VOutWorldPos;

void main()
{
	vec4 position = vec4(InPosition.xyz,1.0);
	#if defined(HKG_INSTANCING)

		mat4 worldTranspose;
		worldTranspose[0] = InTransformRow0; 
		worldTranspose[1] = InTransformRow1; 
		worldTranspose[2] = InTransformRow2; 
		worldTranspose[3] = vec4(0.0, 0.0, 0.0, 1.0); 
		vec4 worldVertPos =  position * worldTranspose; // since we swap row and col above we reverse order here
			
	#else

		#if defined(HKG_SKINNING)
			skinPosition( position, InBlendWeights,  InBlendIndices, position );
		#endif

		vec4 worldVertPos  = g_mWorld  * position;
		
	#endif

	gl_Position = g_mViewProj * worldVertPos; // Light VP in this case

	#ifdef ENABLE_ALPHA_SHADOWS
		 VOutTexCoord0 = InTexCoord0;
	#endif
	VOutWorldPos.xyz = worldVertPos.xyz;
}
#endif


#ifdef ENTRYPOINT_PixShadowDepth
#ifdef ENABLE_ALPHA_SHADOWS
	varying HIGHP vec2 VOutTexCoord0;
#endif
varying HIGHP vec3 VOutWorldPos;

void main()
{
	#ifdef ENABLE_ALPHA_SHADOWS
	if (g_fShadowMapDistance < 100.0)
	{
		vec4 position = vec4(InPosition.xyz,1.0);
	#ifdef HKG_SKINNING    
		skinPosition( position, InBlendWeights, InBlendIndices, position );
	#endif
	
		vec4 pos = g_mWorldViewProj * position; // Light WVP in this case
		gl_Position = pos;
		VOutTexCoord1 = vec4(pos.zzz, pos.w);
		#ifdef ENABLE_ALPHA_SHADOWS
			VOutTexCoord0 = InTexCoord0;
		#endif
	}
	#endif
	
	vec2 depth;
	//if (lightZeroIsDirectional()) // projected dist
	{
		vec3 lightDir = g_vLightShadowStartPosWorld.xyz - VOutWorldPos;
		depth.x = dot(lightDir.xyz,g_vLightDir.xyz) / g_fShadowMapDistance; 
	}
	//else
	//{
	//	vec3 lightDir = g_vLightPos.xyz - VOutWorldPos.xyz;
	//	depth.x = length(lightDir.xyz) / g_fShadowMapDistance; 
	//}		
	
	if (depth.x < 0.0) depth.x *= -1.0;
	depth.y = depth.x * depth.x;
	gl_FragColor  = vec4(depth.xy, 0.0,1.0);
}
	
#endif

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
