/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
// Used directly by light Car renders, not a generic shaderlib style

#define NAME_SAMPLERS

#include "CommonHeader.hlslh"
#include "CommonVertexShaders.hlslh"

//
// Shader X2, Shader Programming Tips and Tricks with DirectX 9
// Layered Car Paint shader
// Chris Oat, Natalya Tatarchuk, John Isidoro

#define HAS_SPARKLE_TEXTURE 0

struct PSInput 
{
	float4 position     	: SV_Position; 
	float3 posView	    	: TEXCOORD0; 
	float4 texCoord01    	: TEXCOORD1;
	float4 tangToWorld0 	: TEXCOORD2; //worldEye.x in .w
	float4 tangToWorld1 	: TEXCOORD3; //worldEye.y in .w
	float4 tangToWorld2 	: TEXCOORD4; //worldEye.z in .w
};

 
PSInput carVS( vertexInputT1B In )
{
	PSInput Out;
	float3 worldVertPos = mul(float4(In.position.xyz , 1.0), g_mWorld).xyz;
	float4 viewPos = mul( float4(In.position.xyz, 1.0), g_mWorldView);
	float3 eyeVec = g_mViewInv[3].xyz - worldVertPos.xyz; // world space eye vector
	
	eyeVec = normalize(eyeVec);
	Out.tangToWorld0.w = eyeVec.x;
	Out.tangToWorld1.w = eyeVec.y;
	Out.tangToWorld2.w = eyeVec.z;
	eyeVec = mul(eyeVec, (float3x3) g_mWorldInv );  // transform back to object space

	float3x3 objToTangentSpaceInv;
	computeTangentSpace( (float3x3) g_mWorldInv, In.tangent, In.binormal, In.normal, objToTangentSpaceInv, Out.tangToWorld0, Out.tangToWorld1, Out.tangToWorld2);
	
	Out.texCoord01.xy = In.texCoord0;
	Out.texCoord01.zw = float2(0,0); //xx Sparkle texture

	Out.position = mul( viewPos, g_mProj);	    
	Out.posView = viewPos.xyz;

	return Out;
}



pixelOutput carPS( PSInput In )
{
 	HKG_TEST_DEPTH_PEEL
    pixelOutput Output;

	#ifdef HKG_SHADOWS
		float lightAmount = getLightAmountShadow( In.posView );
	#else
		float lightAmount = 1;
	#endif
	
	float4 ColorMap = _sampleDiffuse(In.texCoord01.xy );
	float3 vNormal = _sampleNormal(In.texCoord01.xy ).xyz*2.0 - 1.0;
	float3 SpecMap = _sampleSpecular(In.texCoord01.xy ).rgb * g_cSpecularColor.rgb;

	// HDR env map + diffuse irradiance 

	float envScale  = 0.5f;
	float microflakePerturbationA = 1;
	float microflakePerturbation = 1;
	float brightnessFactor = 1;
	float normalPerturbation = 1;
	float3 paintColor0 = ColorMap.rgb; //float3(0.5,0.5,0.5); //ColorMap.rgb;
	float3 paintColor2 = float3(0.1,0.1,0.1);
	float3 paintColorMid = float3(0.2,0.2,0.1);
	float3 flakeLayerColor = float3(0,0,1);
	
	
	
	// Micro-flakes normal map is a high frequency normalized 
	// vector noise map which is repeated across the surface. 
	// Fetching the value from it for each pixel allows us to 
	// compute perturbed normal for the surface to simulate 
	// appearance of micro-flakes suspended in the coat of paint: 
	float3 vFlakesNormal = vNormal; //float3(0,0,1)*2.0 - 1.0; //XX  tex2D(microflakeNMap, i.SparkleTex); 

	// This shader simulates two layers of micro-flakes suspended in 
	// the coat of paint. To compute the surface normal for the first layer, 
	// the following formula is used: 
	// Np1 = ( a * Np + b * N ) / || a * Np + b * N || where a << b 
	// 
	float3 vNp1 = microflakePerturbationA * vFlakesNormal + normalPerturbation * vNormal ; 

	// To compute the surface normal for the second layer of micro-flakes, which 
	// is shifted with respect to the first layer of micro-flakes, we use this formula: 
	// Np2 = ( c * Np + d * N ) / || c * Np + d * N || where c == d 
	float3 vNp2 = microflakePerturbation * ( vFlakesNormal + vNormal ) ; 

	// The view vector (which is currently in world space) needs to be normalized. 
	// This vector is normalized in the pixel shader to ensure higher precision of 
	// the resulting view vector. For this highly detailed visual effect normalizing 
	// the view vector in the vertex shader and simply interpolating it is insufficient 
	// and produces artifacts.
	float3 eyeDirWorld = float3(In.tangToWorld0.w, In.tangToWorld1.w, In.tangToWorld2.w);
	float3 vView = normalize( eyeDirWorld ); 

	// Transform the surface normal into world space (in order to compute reflection 
	// vector to perform environment map look-up): 
	float3x3 mTangentToWorld = float3x3( In.tangToWorld0.xyz, In.tangToWorld1.xyz, In.tangToWorld2.xyz); 
	float3 vNormalWorld = normalize( mul( mTangentToWorld, vNormal  )); 

	// Compute reflection vector resulted from the clear coat of paint on the metallic 
	// surface: 
	float fNdotV = saturate(dot( vNormalWorld, vView)); 
	float3 vReflection = 2 * vNormalWorld * fNdotV - vView; 

	float3x3 rotWorldToEnv = (float3x3)g_mWorldToEnv;
	float3 envReflection  = mul( vReflection, rotWorldToEnv);
	float3 envNormal  = mul( vNormalWorld, rotWorldToEnv);

	float3 envMap = _cubeSampleReflect(envReflection).rgb ;
	float3 diffuseIrradiance = _cubeSampleDIM(envNormal).rgb;
	float3 specIrradiance = _cubeSampleSIM(envReflection).rgb;
	
	float facingMainLight = max(0, dot(vNormalWorld, g_vLightDir));
	float3 shadowDiffuseIrradiance = lerp(diffuseIrradiance, _cubeSampleDIM(-envNormal ).rgb, facingMainLight);
	
	
	// Here we just use a constant gloss value to bias reading from the environment 
	// map, however, in the real demo we use a gloss map which specifies which 
	// regions will have reflection slightly blurred. 
	float fEnvBias = envScale; 

	// Sample environment map using this reflection vector: 
	//float4 envMap = float4(0,0,0,0); //xxx float(texCUBEbias( showroomMap, float4( vReflection, fEnvBias ) ); 

	// Brighten the environment map sampling result: 
	//envMap.rgb *= brightnessFactor; 

	// Compute modified Fresnel term for reflections from the first layer of 
	// microflakes. First transform perturbed surface normal for that layer into 
	// world space and then compute dot product of that normal with the view vector: 
	float3 vNp1World = normalize( mul( mTangentToWorld, vNp1) ); 
	float fFresnel1 = saturate( dot( vNp1World, vView )); 

	// Compute modified Fresnel term for reflections from the second layer of 
	// microflakes. Again, transform perturbed surface normal for that layer into 
	// world space and then compute dot product of that normal with the view vector: 
	float3 vNp2World = normalize( mul( mTangentToWorld, vNp2 )); 
	float fFresnel2 = saturate( dot( vNp2World, vView )); 

	// Combine all layers of paint as well as two layers of microflakes 
	float fFresnel1Sq = fFresnel1 * fFresnel1; 

	float3 paintColor = fFresnel1 * paintColor0 + 
						fFresnel1Sq * paintColorMid + 
						fFresnel1Sq * fFresnel1Sq * paintColor2 + 
						pow( fFresnel2, 16 ) * flakeLayerColor; 

	// Combine result of environment map reflection with the paint color: 
	
	float fEnvContribution = fEnvBias * (1.0 - 0.5 * fNdotV); 

	Output.color.a = 1.0; 
	Output.color.rgb = (1-lightAmount)*( shadowDiffuseIrradiance*ColorMap.rgb*paintColor) + 
						lightAmount*(diffuseIrradiance*ColorMap.rgb*paintColor + (fEnvContribution*envMap + specIrradiance*paintColor)*SpecMap.r); 
	
	if ( g_iFogParams.x > 0)
    {
		Output.color = computeFog( In.posView.z, Output.color );
	}

	if (getColorRangeCorrectionEnabled())
	{
		Output.color.rgb *= getExposurePow2();
		Output.color.rgb = pow(Output.color.rgb, getInvGamma() ); 
	}
	
	
	Output.pzDepth.rgb = In.posView.z; // always output depth   (was * g_iDepthParams.x);
	Output.pzDepth.a = Output.color.a;

	return Output;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
