/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/Physics2012/UseCase/WindChimes/WindChimesDemo.h>

#include <Physics2012/Collide/Shape/Convex/Cylinder/hkpCylinderShape.h>
#include <Physics/Constraint/Data/Hinge/hkpHingeConstraintData.h>

#include <Physics2012/Dynamics/Collide/Filter/Constraint/hkpConstraintCollisionFilter.h>

#include <Common/Visualize/hkDebugDisplay.h>

#include <Common/Serialize/Util/hkLoader.h>
#include <Demos/DemoCommon/Utilities/Asset/hkAssetManagementUtil.h>
#include <Physics2012/Utilities/Serialize/hkpPhysicsData.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>

struct WindChimesVariant
{
	const char*	m_name;
	int m_numChimes;
	int m_numDifferentChimeSizes;
	const char* m_assetName;
	const char* m_details;
};

#ifdef HK_REAL_IS_DOUBLE
#	define FILE_TYPE ".hkt"
#else
#	define FILE_TYPE ".hkx"
#endif

static const WindChimesVariant g_variants[] =
{
	{ "Circular", 5, 5, HK_ASSET_NAME("Resources/Physics2012/Objects/WindChime" FILE_TYPE), "Wind chimes in a circle" },
	{ "Linear", 8, 4, HK_ASSET_NAME("Resources/Physics2012/Objects/WindChime2" FILE_TYPE), "Wind chimes in a row" }
};

static const char* noteNames[] = {"Do","Re","Mi","Fa","So","La","Ti","Do"};

WindChimesDemo::WindChimesDemo(hkDemoEnvironment* env)
:	hkDefaultPhysics2012Demo(env),
	m_loader(HK_NULL)
{
	const WindChimesVariant& variant =  g_variants[m_variantId];

	//
	// Create the sound manager.
	//
// #ifdef HK_PLATFORM_RVL
// 	m_soundManager = new WiiSoundManager("Resources/Physics2012/Sounds/softchimes.spt", "Resources/Physics2012/Sounds/softchimes.spd");
// #endif

	//
	// Set up the camera
	//
	{
		hkVector4 from(6.0f, 0.0f, 3.0f);
		hkVector4 to  (0.0f, 0.0f, 0.0f);
		hkVector4 up  (0.0f, 0.0f, 1.0f);
		setupDefaultCameras( env, from, to, up );
	}

	hkStringBuf assetFile(variant.m_assetName); hkAssetManagementUtil::getFilePath(assetFile);
	m_loader = new hkLoader();
	hkRootLevelContainer* container = m_loader->load( assetFile.cString() );
	HK_ASSERT2(0xaefe9356, container != HK_NULL , "Could not load asset");
	if ( !container )
	{
		return;
	}

	hkpPhysicsData* physics = static_cast<hkpPhysicsData*>( container->findObjectByType( hkpPhysicsDataClass.getName() ) );
	HK_ASSERT2(0x245982ae, physics != HK_NULL, "Could not find physics data in root level object" );
	{
		m_world = new hkpWorld( *physics->getWorldCinfo() );

		m_world->lock();

		hkpAgentRegisterUtil::registerAllAgents(m_world->getCollisionDispatcher());

		setupGraphics();
	}

	m_world->addPhysicsSystem( physics->getPhysicsSystems()[0] );

	// There are 5 pipes in the circular chimes asset, called Chime0, Chime1...etc.
	for( int i = 0; i < variant.m_numChimes; i++ )
	{
		hkStringBuf chimeName;
		chimeName.printf( "Chime%d", i );
		hkpRigidBody* chime = physics->findRigidBodyByName( chimeName.cString() );
		HK_ASSERT(0x99862353, chime);

// #ifdef HK_PLATFORM_RVL
// 		new WindChimesCollisionListener( chime, m_soundManager, i % variant.m_numDifferentChimeSizes );
// #else
		new WindChimesCollisionListener( chime, i % variant.m_numDifferentChimeSizes );
// #endif
	}
	m_world->unlock();
}

WindChimesDemo::~WindChimesDemo()
{
	if(m_world != HK_NULL)
	{
		m_world->markForWrite();
		m_world->removeReference();
		m_world = HK_NULL;
	}
	if( m_loader != HK_NULL )
	{
		delete m_loader;
	}
// #ifdef HK_PLATFORM_RVL
// 	delete m_soundManager;
// #endif
}

// Our WindChimesCollisionListener class inherits from both hkpContactListener and hkpEntityListener and so implementations for each
// of the virtual methods in both base classes must be present. However, for the purposes of this demo we are only interested
// in the contactPointAddedCallback(...) method. It is within this that we are able to use the newly acquired contact information.
// #ifdef HK_PLATFORM_RVL
// WindChimesCollisionListener::WindChimesCollisionListener(hkpRigidBody* rigidBody, WiiSoundManager * soundManager, int noteIndex)
// :   m_noteIndex(noteIndex),
// 	m_soundManager(soundManager)
// #else
WindChimesCollisionListener::WindChimesCollisionListener(hkpRigidBody* rigidBody, int noteIndex)
:   m_noteIndex(noteIndex)
// #endif
{
	rigidBody->addContactListener( this );
	rigidBody->addEntityListener( this );
	m_uniqueIdCounter = 0;
}

WindChimesCollisionListener::~WindChimesCollisionListener()
{
}

void WindChimesCollisionListener::contactPointCallback( const hkpContactPointEvent& event )
{
	hkReal noteStrength = hkMath::fabs( event.getSeparatingVelocity() );

	hkStringBuf bodyA = event.m_bodies[0]->getName();
	hkStringBuf bodyB = event.m_bodies[1]->getName();

	if( hkString::strCmp(bodyA.cString(),"Gong") == 0 || hkString::strCmp(bodyB.cString(),"Gong") == 0 )
	{
		noteStrength *= 3;
	}

	hkprintf( "%s %f (%s, %s)\n", noteNames[m_noteIndex], noteStrength, bodyA.cString(), bodyB.cString() );

// #ifdef HK_PLATFORM_RVL
// 	m_soundManager->PlaySfx( m_noteIndex, noteStrength );
// #endif
}


//
// entityDeletedCallback
//
void WindChimesCollisionListener::entityDeletedCallback( hkpEntity* entity )
{
	// Remove the collision event listener
	entity->removeContactListener( this ); 

// #ifdef HK_PLATFORM_RVL
// 	m_soundManager->StopSfx( m_noteIndex );
// #endif

	// Now that we're removed from our entity, we can remove ourselves, too.
	delete this;
}

void WindChimesCollisionListener::entityRemovedCallback( hkpEntity* entity )
{
	// Do nothing (we'll remove the collision event listener only when the entity is deleted)
}


static const char helpString[] = "WindChimes";

HK_DECLARE_DEMO_VARIANT_USING_STRUCT( WindChimesDemo, HK_DEMO_TYPE_PHYSICS_2012 | HK_DEMO_TYPE_SERIALIZE, WindChimesVariant, g_variants, helpString );

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
