/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_WELDING_ISSUES_H
#define HK_WELDING_ISSUES_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>
#include <Physics2012/Collide/Shape/Compound/Tree/Mopp/hkpMoppBvTreeShape.h>

extern const class hkClass WeldingIssuesOptionsClass;

class hkpRigidBody;	
class hkpCharacterRigidBody;
class hkLoader;

class WeldingIssues : public hkDefaultPhysics2012Demo
{
	public:
		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		WeldingIssues( class hkDemoEnvironment* env );
		~WeldingIssues( );

		//virtual void postSimulationCallback( hkpWorld* world );

		struct Options
		{
			HK_DECLARE_REFLECTION();
			
			Options()
				:	m_unweldingHeightOffsetFactor( -1.0f )
			{
			}

			hkReal m_unweldingHeightOffsetFactor; //+default(0)
		};

		DEMO_OPTIONS_DECLARE(Options);

	protected:

		hkReal m_time;
		hkLoader* m_loader;
		hkArray< hkpCharacterRigidBody* > m_character;
		
		hkpRigidBody* createSphere( hkVector4Parameter position, const hkEnum< hkpMotion::MotionType, hkInt8 >& motionType, const hkEnum< hkpCollidableQualityType, hkInt8 >& qualityType );
		hkpCharacterRigidBody* createCharacter( hkVector4Parameter position, const hkEnum< hkpMotion::MotionType, hkInt8 >& motionType, const hkEnum< hkpCollidableQualityType, hkInt8 >& qualityType );
		hkpRigidBody* createMopp( const hkVector4* verts, hkUint16 numVerts, const hkUint16* indices, hkUint16 numIndices, hkVector4Parameter pos, hkpWeldingUtility::WeldingType weldingType = hkpWeldingUtility::WELDING_TYPE_ANTICLOCKWISE );
		hkpShapeCollection* createMesh( const hkVector4* verts, hkUint16 numVerts, const hkUint16* indices, hkUint16 numTriangles, hkVector4Parameter pos, hkpShapeCollection::CollectionType collectionType = hkpShapeCollection::COLLECTION_EXTENDED_MESH, hkpWeldingUtility::WeldingType weldingType = hkpWeldingUtility::WELDING_TYPE_ANTICLOCKWISE );
		void createWorld( );
		
		Result stepDemo( );
};

#endif // HK_WELDING_ISSUES_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
