/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Physics2012/Utilities/CharacterControl/CharacterProxy/hkpCharacterProxy.h>
#include <Common/Visualize/hkDebugDisplay.h>

#include <Demos/Physics2012/UseCase/TriggerVolume/TriggerVolumeComparison/TriggerVolumeComparisonDemo.h>

TriggerVolumeComparisonDemo::DemoTriggerVolume::DemoTriggerVolume( hkpRigidBody* triggerBody )
:hkpTriggerVolume( triggerBody )
{
	// Set colours
	m_colourHit   = hkColor::semiTransparent( hkColor::RED );
	m_colourNoHit = hkColor::semiTransparent( hkColor::BLUE );
	
	// Initialize result data
	m_resultBits = new hkBitField(14, hkBitFieldValue::UNINITIALIZED);
	m_resultBits->assignAll(0);
	m_lastEnterEvent = 0.0f;
	m_lastLeaveEvent = 0.0f;

	m_lastEventWasEnter = false;
}

TriggerVolumeComparisonDemo::DemoTriggerVolume::~DemoTriggerVolume()
{
	delete m_resultBits;
}

void TriggerVolumeComparisonDemo::DemoTriggerVolume::triggerEventCallback( hkpRigidBody* body, EventType type )
{
	if ( type & ENTERED_EVENT )
	{
		// Make sure the callbacks are being called in the correct order
		HK_ASSERT2( 0x00001111, !m_lastEventWasEnter, "Two enter events in a row!");
		m_lastEventWasEnter = true;

		// Call the 7.1 enterEvent callback
		enterEvent( body );
	}
	if ( type & LEFT_EVENT )
	{
		// Make sure the callbacks are being called in the correct order
		HK_ASSERT2( 0x00001112,  m_lastEventWasEnter, "Two leave events in a row!");
		m_lastEventWasEnter = false;

		// Call the 7.1 leaveEvent callback
		leaveEvent( body );
	}

}

void TriggerVolumeComparisonDemo::DemoTriggerVolume::triggerEventCallback( hkpCharacterProxy* proxy, EventType type )
{
	if ( type & ENTERED_EVENT )
	{
		// Make sure the callbacks are being called in the correct order
		HK_ASSERT2( 0x00001111, !m_lastEventWasEnter, "Two enter events in a row!");
		m_lastEventWasEnter = true;

		// Register collision in result bitField
		TriggerVolumeComparisonDemo::EntityType volTypeID = (TriggerVolumeComparisonDemo::EntityType)proxy->getShapePhantom()->getUserData();
		addResultToBitField( volTypeID, COLLISION_PHASE_NARROWPHASE, m_resultBits );

		// Set timestamp
		m_lastEnterEvent = m_triggerBody->getWorld()->getCurrentTime();

		HK_SET_OBJECT_COLOR((hkUlong)m_triggerBody->getCollidable(), m_colourHit);
	}
	if ( type & LEFT_EVENT )
	{
		// Make sure the callbacks are being called in the correct order
		HK_ASSERT2( 0x00001112,  m_lastEventWasEnter, "Two leave events in a row!");
		m_lastEventWasEnter = false;

		// Set timestamp
		m_lastLeaveEvent = m_triggerBody->getWorld()->getCurrentTime();

		HK_SET_OBJECT_COLOR((hkUlong)m_triggerBody->getCollidable(), m_colourNoHit);
	}
}


void TriggerVolumeComparisonDemo::DemoTriggerVolume::enterEvent( hkpRigidBody* rb )
{
	// Register collision in result bitField
	TriggerVolumeComparisonDemo::EntityType volTypeID = (TriggerVolumeComparisonDemo::EntityType)rb->getUserData();
	addResultToBitField( volTypeID, COLLISION_PHASE_NARROWPHASE, m_resultBits );

	// Set timestamp
	m_lastEnterEvent = m_triggerBody->getWorld()->getCurrentTime();

	HK_SET_OBJECT_COLOR((hkUlong)m_triggerBody->getCollidable(), m_colourHit);
}

void TriggerVolumeComparisonDemo::DemoTriggerVolume::leaveEvent( hkpRigidBody* rb )
{
	// Set timestamp
	m_lastLeaveEvent = m_triggerBody->getWorld()->getCurrentTime();

	HK_SET_OBJECT_COLOR((hkUlong)m_triggerBody->getCollidable(), m_colourNoHit);
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
