/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Demos/Physics2012/UseCase/TriggerVolume/TriggerVolumeComparison/TriggerVolumeComparisonDemo.h>
#include <Physics2012/Utilities/Dynamics/KeyFrame/hkpKeyFrameUtility.h>

TriggerVolumeComparisonDemo::PingpongAction::PingpongAction ( hkpEntity* entity, const hkVector4& origVelocity, const hkVector4& origPos, const hkVector4& fulcrum )
: hkpUnaryAction(entity)
, m_fulcrum(fulcrum)
, m_velocity(origVelocity)
{
	m_amplitude = origPos.distanceTo3( fulcrum );
}

void TriggerVolumeComparisonDemo::PingpongAction::applyAction(const hkStepInfo& stepInfo)
{
	hkpRigidBody* rb = static_cast<hkpRigidBody*>(m_entity);

	hkVector4 currPos; currPos = rb->getPosition();
	hkVector4 toFulcrum; toFulcrum.setSub4(m_fulcrum,currPos);

	// If it's exceeded its boundary and going the wrong way, flip velocity
	if ( toFulcrum.length3().getReal() > m_amplitude && m_velocity.dot3(toFulcrum).getReal() < 0 )
	{
		m_velocity.setNeg3( m_velocity );
	}

	// Update position with keyframe
	hkVector4 nextPos; nextPos.setAddMul4( currPos, m_velocity, static_cast<hkSimdReal>(stepInfo.m_deltaTime.val()) );
	hkpKeyFrameUtility::applyHardKeyFrame(nextPos, rb->getRotation(), stepInfo.m_invDeltaTime, rb);
}

hkpAction* TriggerVolumeComparisonDemo::PingpongAction::clone( const hkArray<hkpEntity*>& newEntities, const hkArray<hkpPhantom*>& newPhantoms ) const
{
	HK_ERROR(0x0, "Not written yet");
	return HK_NULL;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
