/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#include <Demos/demos.h>
#include <Physics2012/Utilities/VisualDebugger/Viewer/hkpShapeDisplayBuilder.h>
#include <Common/Visualize/hkDebugDisplay.h>

#include <Demos/Physics2012/UseCase/TriggerVolume/TriggerVolumeComparison/TriggerVolumeComparisonDemo.h>

TriggerVolumeComparisonDemo::DemoAabbPhantom::DemoAabbPhantom( const hkAabb& aabb, hkUint32 collisionFilterInfo  )
: hkpAabbPhantom(aabb, collisionFilterInfo)
{
	// Set the colours
	m_broadphaseColourHit   = hkColor::semiTransparent( hkColor::ORANGE );
	m_broadphaseColourNoHit = hkColor::semiTransparent( hkColor::YELLOW );

	// Initialize result data
	m_resultBits = new hkBitField(14, hkBitFieldValue::UNINITIALIZED);
	m_resultBits->assignAll(0);
	m_lastEnterEvent = 0.0f;
	m_lastLeaveEvent = 0.0f;

	// Build a shape for display
	hkVector4 aabbSize; m_aabb.getHalfExtents( aabbSize );
	hkVector4 aabbPos; m_aabb.getCenter( aabbPos );
	hkpShape* aabbShape = new hkpBoxShape( aabbSize, 0 );

	hkTransform aabbTransf; aabbTransf.setIdentity(); aabbTransf.setTranslation( aabbPos );
	m_displayPhantom = new hkpSimpleShapePhantom( aabbShape, aabbTransf );

	hkpShapeDisplayBuilder::addObjectToDebugDisplay( aabbShape, aabbTransf, (hkUlong)m_displayPhantom );
	HK_SET_OBJECT_COLOR((hkUlong)m_displayPhantom, m_broadphaseColourNoHit);

	// For the motion control
	m_origPos = aabbPos;

	// Reference counting
	aabbShape->removeReference();
}

TriggerVolumeComparisonDemo::DemoAabbPhantom::~DemoAabbPhantom()
{
	delete m_resultBits;
	m_displayPhantom->removeReference();
}

void TriggerVolumeComparisonDemo::DemoAabbPhantom::addOverlappingCollidable( hkpCollidable* c )
{
	// Register overlap in result bitField
	TriggerVolumeComparisonDemo::EntityType volTypeID = ENTITY_TYPE_INVALID;
	hkpRigidBody* rb = hkpGetRigidBody( c );
	hkpPhantom* ph = hkpGetPhantom( c );
	if ( rb != HK_NULL )
	{
		volTypeID = (TriggerVolumeComparisonDemo::EntityType)rb->getUserData();
	}
	if (ph != HK_NULL )
	{
		volTypeID = (TriggerVolumeComparisonDemo::EntityType)ph->getUserData();
	}
	addResultToBitField( volTypeID, COLLISION_PHASE_BROADPHASE, m_resultBits );

	// Set timestamp
	m_lastEnterEvent = m_world->getCurrentTime();

	// Set the AABB colour
	HK_SET_OBJECT_COLOR((hkUlong)m_displayPhantom, m_broadphaseColourHit);

	// default hkpAabbPhantom behaviour
	hkpAabbPhantom::addOverlappingCollidable( c );
}

void TriggerVolumeComparisonDemo::DemoAabbPhantom::removeOverlappingCollidable( hkpCollidable* c )
{
	// Retrieve timestamp
	m_lastLeaveEvent = m_world->getCurrentTime();

	// Set the AABB colour
	HK_SET_OBJECT_COLOR((hkUlong)m_displayPhantom, m_broadphaseColourNoHit);

	// default hkpAabbPhantom behaviour
	hkpAabbPhantom::removeOverlappingCollidable( c );
}


void TriggerVolumeComparisonDemo::DemoAabbPhantom::move( hkReal deltaTime )
{
	// Hardcoded oscillation about the fulcrum
	if ( !m_isFixed )
	{
		// Calculate relative position
		hkVector4 currPos; this->getAabb().getCenter( currPos );
		hkVector4 toFulcrum; toFulcrum.setSub4(m_fulcrum,currPos);

		// If it's exceeded its boundary and going the wrong way, flip velocity
		if ( toFulcrum.length3().getReal() > m_amplitude && m_velocity.dot3(toFulcrum).getReal() < 0 )
		{
			m_velocity.setNeg3( m_velocity );
		}

		// Get next position
		hkVector4 nextPos; nextPos.setAddMul4( currPos, m_velocity, deltaTime );

		// Update position and display shape
		hkVector4 aabbHalfExtents; this->getAabb().getHalfExtents( aabbHalfExtents );
		hkVector4 newAabbMin; newAabbMin.setSub4( nextPos, aabbHalfExtents );
		hkVector4 newAabbMax; newAabbMax.setAdd4( nextPos, aabbHalfExtents );
		hkAabb newAabb = hkAabb( newAabbMin, newAabbMax );
		this->setAabb(newAabb);
		m_displayPhantom->setPosition(nextPos);
		hkTransform transf; transf.setIdentity();
		transf.setTranslation( nextPos );
		HK_UPDATE_GEOMETRY( transf, (hkUlong)m_displayPhantom );
	}
}

void TriggerVolumeComparisonDemo::DemoAabbPhantom::setupMotion ( const hkVector4& origVelocity, const hkVector4& fulcrum )
{
	m_velocity = origVelocity;
	m_fulcrum = fulcrum;
	this->getAabb().getCenter( m_origPos );
	m_amplitude = m_origPos.distanceTo3( fulcrum );
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
