/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

// A demo which shows the difference between hkpTriggerVolume, hkpPhantomCallbackShape and hkp[Aabb|Shape]Phantom.
// We want to show 7 things
// 1:	For hkpShapePhantom - how to detect narrowphase overlaps, not just broadphase ones
// 2:	Continuous collision detection - do they detect enter-and-leave events for fast moving objects?
//		How is a body that passes through a trigger within one frame treated?
// 3:	What is the performance impact and memory cost for detecting and maintaining overlaps?
// 4:	How do (large) phantoms affect simulation islands? How should one avoid waking up overlapping bodies?
// 5:	How do they interact with the character proxy and character rigid body?
// 6:	How do they detect overlaps with each other?
// 7:	Which of them is supported on SPU?
//
// This demo is created in response to JIRA item HVK-5418

#ifndef HK_TRIGGERVOLUMECOMPARISONDEMO_H
#define HK_TRIGGERVOLUMECOMPARISONDEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>

#include <Common/Base/Container/BitField/hkBitField.h>
#include <Physics2012/Collide/Query/Collector/BodyPairCollector/hkpAllCdBodyPairCollector.h>

#include <Physics2012/Utilities/Collide/TriggerVolume/hkpTriggerVolume.h>
#include <Physics2012/Collide/Shape/Misc/PhantomCallback/hkpPhantomCallbackShape.h>
#include <Physics2012/Dynamics/Phantom/hkpAabbPhantom.h>
#include <Physics2012/Dynamics/Phantom/hkpSimpleShapePhantom.h>

#include <Physics2012/Dynamics/Action/hkpUnaryAction.h>

#include <Common/Visualize/hkDebugDisplay.h>

class TriggerVolumeComparisonDemo : public hkDefaultPhysics2012Demo
{
	public:
		
		HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DEMO );
		
		TriggerVolumeComparisonDemo( hkDemoEnvironment* env );
		~TriggerVolumeComparisonDemo();

	protected:

		//
		// Trigger volume with some data collection. It also changes colour when it fires a callback.
		//
		class DemoTriggerVolume: public hkpTriggerVolume
		{
			public:
			HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
				DemoTriggerVolume( hkpRigidBody* triggerBody );
				~DemoTriggerVolume();

				// hkpTriggerVolume implementation
	 			virtual void triggerEventCallback( hkpRigidBody* body, EventType type );
				virtual void triggerEventCallback( hkpCharacterProxy* proxy, EventType type );

				// Carried over from the 7.1 interface. Left here for backwards-compatibility with 7.1.
				void enterEvent( hkpRigidBody* handle );
				void leaveEvent( hkpRigidBody* handle );

			public:

				// Display colours
				hkInt32 m_colourHit;
				hkInt32 m_colourNoHit;

				// Result Data
				hkBitField* m_resultBits;
				hkTime m_lastEnterEvent;
				hkTime m_lastLeaveEvent;

				// For keeping track of the order of events firing
				hkBool m_lastEventWasEnter;
		};
		//
		// Phantom Callback Shape with some data collection. It also changes colour when it fires a callback.
		//
		class DemoPhantomCallbackShape: public hkpPhantomCallbackShape
		{
			public:
			HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
				DemoPhantomCallbackShape();
				~DemoPhantomCallbackShape();

				// hkpPhantomCallbackShape implementation
				void phantomEnterEvent( const hkpCollidable* phantomColl, const hkpCollidable* otherColl, const hkpCollisionInput& env );
				void phantomLeaveEvent( const hkpCollidable* phantomColl, const hkpCollidable* otherColl );

			public:

				// Display colours
				hkInt32 m_colourHit;
				hkInt32 m_colourNoHit;

				// Result data
				hkBitField* m_resultBits;
				hkTime m_lastEnterEvent;
				hkTime m_lastLeaveEvent;
		};

		//
		// Shape phantom with some data collection. It also changes AABB colour when there's a broadphase overlap and shape colour on narrowphase overlap
		//
		class DemoShapePhantom: public hkpSimpleShapePhantom
		{
			public:
				HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
				DemoShapePhantom( const hkpShape* shape, const hkTransform& transform, hkUint32 m_collisionFilterInfo = 0 );
				~DemoShapePhantom();

				// Move the phantom according to the motion variables and deltaTime, if m_isFixed != true. 
				void move( hkReal deltaTime );

				// Setup the variables for motion
				void setupMotion( const hkVector4& origVelocity, const hkVector4& fulcrum );

				// Setup the result bits for a narrowphase collision
				void setResultBits( hkpAllCdBodyPairCollector coll );

				// hkpSimpleShapePhantom implementation 
				void addOverlappingCollidable( hkpCollidable* handle );
				void removeOverlappingCollidable( hkpCollidable* handle );

			public:

				// movement variables - needed because one can't apply an action to a phantom
				hkBool	m_isFixed;
				hkVector4 m_fulcrum;
				hkVector4 m_velocity;
				hkVector4 m_origPos;
				hkReal m_amplitude;

				// Colours and a phantom for display
				hkpSimpleShapePhantom* m_displayPhantom;
				hkInt32 m_colourHit;
				hkInt32 m_colourNoHit;
				hkInt32 m_broadphaseColourHit;
				hkInt32 m_broadphaseColourNoHit;

				// Result data
				hkBitField* m_resultBits;
				hkTime m_lastEnterEvent;
				hkTime m_lastLeaveEvent;
		};

		//
		// AABB phantom with data collection and hardcoded movement to match the PingpongAction (optional)
		// 
		class DemoAabbPhantom: public hkpAabbPhantom
		{
			public:
				HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
				DemoAabbPhantom( const hkAabb& aabb, hkUint32 collisionFilterInfo = 0 );
				~DemoAabbPhantom();

				// Move the phantom according to the motion variables and deltaTime, if m_isFixed != true. 
				void move( hkReal deltaTime );

				// Setup the variables for motion
				void setupMotion( const hkVector4& origVelocity, const hkVector4& fulcrum );

				// hkpAabbPhantom implementation
				void addOverlappingCollidable( hkpCollidable* handle );
				void removeOverlappingCollidable( hkpCollidable* handle );

			public:

				// movement variables - needed because one can't apply an action to a phantom
				hkBool	m_isFixed;
				hkVector4 m_fulcrum;
				hkVector4 m_velocity;
				hkVector4 m_origPos;
				hkReal m_amplitude;

				// Colours and a phantom for display
				hkpSimpleShapePhantom* m_displayPhantom;
				hkInt32 m_broadphaseColourHit;
				hkInt32 m_broadphaseColourNoHit;

				// Result data
				hkBitField* m_resultBits;
				hkTime m_lastEnterEvent;
				hkTime m_lastLeaveEvent;
		};

		//
		// Unary action to make the object grid move back and forth through the volumes
		//
		class PingpongAction : public hkpUnaryAction
		{
			public:
				HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
				PingpongAction ( hkpEntity* entity, const hkVector4& origVelocity, const hkVector4& origPos, const hkVector4& fulcrum );

				// hkpUnaryAction implementations
				void applyAction(const hkStepInfo& stepInfo);
				hkpAction* clone( const hkArray<hkpEntity*>& newEntities, const hkArray<hkpPhantom*>& newPhantoms ) const;

			private:
				/// The point around which the object oscillates
				hkVector4	m_fulcrum;

				/// The maximum allowed distance from the fulcrum
				hkReal		m_amplitude;

				/// The current velocity of the object; always +/- original velocity
				hkVector4	m_velocity;
		};

		// Some enums used throughout the demo
		enum DemoVariant
		{
			VARIANT_DETECTION_COMPARISON,
			VARIANT_CONTINUOUS
		};
		enum HitType
		{
			BROADPHASE_RIGIDBODY,
			NARROWPHASE_RIGIDBODY,
			BROADPHASE_TRIGGERVOLUME,
			NARROWPHASE_TRIGGERVOLUME,
			BROADPHASE_PHANTOMCALLBACKSHAPE,
			NARROWPHASE_PHANTOMCALLBACKSHAPE,
			BROADPHASE_SHAPEPHANTOM,
			NARROWPHASE_SHAPEPHANTOM,
			BROADPHASE_AABBPHANTOM,
			NARROWPHASE_AABBPHANTOM,
			BROADPHASE_CHAR_RIGIDBODY,
			NARROWPHASE_CHAR_RIGIDBODY,
			BROADPHASE_CHAR_PROXY,
			NARROWPHASE_CHAR_PROXY,

			//
			INVALID_HIT_TYPE
		};
		enum CollisionPhase
		{
			COLLISION_PHASE_BROADPHASE,
			COLLISION_PHASE_NARROWPHASE
		};
		enum EntityType
		{
			ENTITY_TYPE_INVALID,
			ENTITY_TYPE_RIGIDBODY,
			ENTITY_TYPE_TRIGGERVOLUME,
			ENTITY_TYPE_PHANTOMCALLBACKSHAPE,
			ENTITY_TYPE_SHAPEPHANTOM,
			ENTITY_TYPE_AABBPHANTOM,
			ENTITY_TYPE_CHAR_RIGIDBODY,
			ENTITY_TYPE_CHAR_PROXY
		};

		// Display labels below the fixed volumes
		void displayFixedObjectLabels();

		// Functions for stepDemo to move the entities for which the custom action is incompatible or otherwise unsuitable
		void collideShapePhantoms();
		void moveShapePhantoms();
		void moveAabbPhantoms();
		void moveCharacterRigidBodies();
		void moveCharacterProxies();

		// Functions to add shapes to the grid - just for readability
		void addGridRigidBody( int row, int col );
		void addGridTriggerVolume( int row, int col );
		void addGridPhantomCallbackShape( int row, int col );
		void addGridShapePhantom( int row, int col );
		void addGridAabbPhantom( int row, int col );
		void addGridCharacterRigidBody( int row, int col );
		void addGridCharacterProxy( int row, int col );

		// Creates the array of fixed volumes
		void setupFixedVolumes( hkBool includeRB, hkBool includeTV, hkBool includePCS, hkBool includeSP, hkBool includeAP );

		// Puts a PingpongAction on rigid body Rb, making it go back and forth through the fixed volumes
		void addPingpongAction( hkpRigidBody* Rb, const int& rowIndex, const hkVector4& position );

		// Functions for displaying the results in a text box, one for each variant
		void displayResultsText();

		// Helper functions for displayResultsText, writing the result data into strings
		void formatResultString( const hkBitField* bf, hkStringBuf& outStr );
		void formatTimerString( const hkTime& enterTime, const hkTime& leaveTime, hkStringBuf& outStr );

		// Function for the custom classes to write into the bitString. Static to avoid repetition.
		static void addResultToBitField( const EntityType volTypeID, const CollisionPhase phaseID, hkBitField* bf );

		// hkDefaultPhysics2012Demo implementation
		Result stepDemo( void );
		void setupContexts(hkArray<hkProcessContext*>& contexts);

	protected:

		// Pointers to the fixed volumes
		class DemoTriggerVolume*					m_fixedTriggerVolume;
		class DemoPhantomCallbackShape*				m_fixedPhantomCallbackShape;
		class DemoShapePhantom*						m_fixedShapePhantom;
		class DemoAabbPhantom*						m_fixedAabbPhantom;

		// Arrays of pointers to the movable entities that need more than just the custom action
		hkArray<class DemoShapePhantom*>			m_shapePhantoms;
		hkArray<class DemoAabbPhantom*>				m_aabbPhantoms;
		hkArray<class hkpCharacterRigidBody*>		m_characterRigidBodies;
		hkArray<class hkpCharacterProxy*>			m_characterProxies;

		// Shapes and cInfo used for multiple objects
		hkpConvexShape*								m_sphereShape;
		hkpShape*									m_charControlShape;
		hkpRigidBodyCinfo							m_sphereInfo;

		// Dimensions of the shape grid
		int											m_numRows;
		int											m_numCols;
		hkVector4									m_gridOrigin;
		hkVector4									m_gridHorizontalOffset;
		hkVector4									m_gridVerticalOffset;
		hkVector4									m_gridVelocity;

};
#endif // HK_TRIGGERVOLUMECOMPARISONDEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
