/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_LAUNCH_PAD_LISTENER_H
#define HK_LAUNCH_PAD_LISTENER_H

#include <Physics2012/Dynamics/Collide/ContactListener/hkpContactListener.h>

class LaunchPadListener : public hkReferencedObject, public hkpContactListener
{
	public:
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
			/// Constructor for "basic" launchpad (launches along contact normal)
		LaunchPadListener( hkReal forceMagnitude = 1.0f ) :
		  m_forceMagnitude( forceMagnitude ), m_targetPosition( hkVector4::getZero() ) {}

			/// Constructor for launchpad which launches toward a target
		LaunchPadListener( const hkVector4& targetPosition ) :
		  m_forceMagnitude( 0.0f ), m_targetPosition( targetPosition ) {}

		virtual void contactPointCallback( const hkpContactPointEvent& event );

	private:
		hkReal m_forceMagnitude;
		const hkVector4& m_targetPosition;
};

#endif  // HK_LAUNCH_PAD_LISTENER_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
