/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#include <Demos/demos.h>
#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>
#include <Common/Visualize/hkDebugDisplay.h>
#include <Graphics/Common/Window/hkgWindow.h>

#include <Demos/Physics2012/UseCase/ImportedMeshMaterial/ImportedMeshMaterialDemo.h>

// Shape types
#include <Physics2012/Collide/Shape/Compound/Collection/StorageExtendedMesh/hkpStorageExtendedMeshShape.h>
#include <Physics2012/Collide/Shape/Compound/Collection/SimpleMesh/hkpSimpleMeshShape.h>
#include <Physics2012/Collide/Shape/Deprecated/CompressedMesh/hkpCompressedMeshShape.h>
#include <Common/Base/Reflection/Registry/hkVtableClassRegistry.h>

// Ray casting
#include <Physics2012/Collide/Query/CastUtil/hkpWorldRayCastInput.h>
#include <Physics2012/Collide/Query/CastUtil/hkpWorldRayCastOutput.h>

// Asset loading 
#include <Common/Serialize/Util/hkLoader.h>
#include <Common/Serialize/Util/hkRootLevelContainer.h>
#include <Common/SceneData/Scene/hkxScene.h>
#include <Graphics/Bridge/SceneData/hkgSceneDataConverter.h>
#include <Physics2012/Utilities/Serialize/hkpPhysicsData.h>
#include <Demos/DemoCommon/Utilities/Asset/hkAssetManagementUtil.h>

DEMO_OPTIONS_DEFINE( ImportedMeshMaterialDemo, Options );

ImportedMeshMaterialDemo::ImportedMeshMaterialDemo(hkDemoEnvironment* env) : hkDefaultPhysics2012Demo(env)
{
	m_castPos.set( 0, 0, 15 );

	// new world
	hkpWorldCinfo info;
	{
		info.m_gravity.set( 0, 0, -10 );
		m_world = new hkpWorld( info );
	}

	m_world->lock();
	{	
		// Camera and graphics
		{
			hkVector4 from( 0, 40, 40 );
			hkVector4   to( 0,  0,  0 );
			hkVector4   up( 0,  0,  1 );
			setupDefaultCameras( env, from, to, up );
			setupGraphics();			
		}

		m_loader = new hkLoader();
		{
			hkReal translateDistance = 25.0f;

			const char* assetFiles[2] = 
			{
				"Resources/Physics2012/UseCase/ImportedMeshMaterial/namedMaterials.hkt",
				"Resources/Physics2012/UseCase/ImportedMeshMaterial/namedSelections.hkt",
			};
			
			for(int af = 0 ; af < (int)HK_COUNT_OF(assetFiles) ; af++)
			{
				const char* assetFile = assetFiles[af];
				//hkAssetManagementUtil::getFilePath(assetFile);

				hkRootLevelContainer* container = m_loader->load( HK_GET_DEMOS_ASSET_FILENAME(assetFile) );

				HK_ASSERT2(0x27343437, container != HK_NULL , "Could not load asset");
				hkxScene* scene = reinterpret_cast<hkxScene*>( container->findObjectByType( hkxSceneClass.getName() ));

				HK_ASSERT2(0x27343635, scene, "No scene loaded");

				env->m_sceneConverter->convert( scene, hkgAssetConverter::NO_MESHES );

				hkpPhysicsData* physics = reinterpret_cast<hkpPhysicsData*>( container->findObjectByType( hkpPhysicsDataClass.getName() ));
				HK_ASSERT2(0x27343635, physics, "No physics loaded");

				// Physics
				if (physics)
				{
					const hkArray<hkpPhysicsSystem*>& psys = physics->getPhysicsSystems();

					for(int i = 0 ; i < psys.getSize() ; i++)
					{
						const hkArray<hkpRigidBody*>& rbs = psys[i]->getRigidBodies();
						for(int j = 0; j < rbs.getSize(); j++ )
						{
							hkVector4 translateBodies;
							translateBodies.setZero4();
							translateBodies.add4(hkVector4( ( hkReal( af )- ( hkReal( HK_COUNT_OF(assetFiles) - 1 ) * 0.5f ) ) * translateDistance, 0, -30 ) );
							rbs[j]->setPosition(translateBodies);
							m_world->addEntity(rbs[j]);
							HK_SET_OBJECT_COLOR( (hkUlong)rbs[j]->getCollidable(), hkColor::WHITE );
						}
					}
				}
			}

		}
	}
	m_world->unlock();
}

ImportedMeshMaterialDemo::~ImportedMeshMaterialDemo()
{			
	m_world->markForWrite();

	// need to delete world before we wipe the loader
	if(m_world)
	{
		m_world->removeReference();
		m_world = HK_NULL;
	}

	delete m_loader;
}


hkDemo::Result ImportedMeshMaterialDemo::stepDemo()
{
	hkpWorldRayCastInput input;
	hkpWorldRayCastOutput output;
	m_world->lock();
	{		
		input.m_from = m_castPos;
		input.m_to.setAdd4( m_castPos, hkVector4( 0, 0 , -20 ) );		  
		m_world->castRay(input, output);
		setGraphicsState(HKG_ENABLED_WIREFRAME, m_options.m_wireframe);
	}
	m_world->unlock();

	if( output.hasHit() )
	{
		hkpShapeKey key = getLastShapeKeyFromHierarchy( &output.m_shapeKeys[0] );

		// Show normal
		{
			hkVector4 dir; dir.setSub4( input.m_to, input.m_from );
			hkVector4 hit; hit.setAddMul4( input.m_from, dir, output.m_hitFraction );
			hkVector4 norm; norm.setAddMul4( hit, output.m_normal, 10 );
			HK_DISPLAY_LINE( hit, norm, 0xff00ffff);
			HK_DISPLAY_LINE( input.m_from, hit, 0xffffffff);  
		}

		hkpShapeCollection* collection = HK_NULL;
		const hkpShapeType type = output.m_rootCollidable->getShape()->getType();		
		if ( type == hkcdShapeType::MOPP )
		{
			const hkpMoppBvTreeShape* moppBv = (const hkpMoppBvTreeShape*)output.m_rootCollidable->getShape();
			collection =  const_cast<hkpShapeCollection*>(moppBv->getShapeCollection());			
		}
		else if( type == hkcdShapeType::TRIANGLE_COLLECTION || type == hkcdShapeType::EXTENDED_MESH || type == hkcdShapeType::COMPRESSED_MESH )
		{
			collection =  const_cast<hkpShapeCollection*>( reinterpret_cast<const hkpShapeCollection*>(output.m_rootCollidable->getShape()) );
		}

		if( collection )
		{
			hkStringBuf materialName("Unnamed");

			const hkClass* shapeClass = hkVtableClassRegistry::getInstance().getClassFromVirtualInstance( collection );
			extern const hkClass hkpStorageExtendedMeshShapeClass;
			extern const hkClass hkpCompressedMeshShapeClass;
			extern const hkClass hkpSimpleMeshShapeClass;
			if( shapeClass == &hkpStorageExtendedMeshShapeClass )
			{
				hkpStorageExtendedMeshShape* exMeshShape = (hkpStorageExtendedMeshShape*)collection;
				hkpNamedMeshMaterial* namedMaterial = (hkpNamedMeshMaterial*)const_cast<hkpMeshMaterial*>(exMeshShape->getMeshMaterial( key ));


				if( namedMaterial )
				{
					materialName = namedMaterial->m_name;
				}
			}
			else if( shapeClass == &hkpCompressedMeshShapeClass )
			{
				hkpCompressedMeshShape* compMeshShape = (hkpCompressedMeshShape*)collection;

				hkpNamedMeshMaterial* namedMaterial = (hkpNamedMeshMaterial*)const_cast<hkpMeshMaterial*>(compMeshShape->getMaterial( key ));

				if( namedMaterial )
				{
					materialName = namedMaterial->m_name;
				}
			}
			else if( shapeClass == &hkpSimpleMeshShapeClass )
			{
				hkpSimpleMeshShape* simpleMeshShape = (hkpSimpleMeshShape*)collection;
				const hkArray<hkUint8>& matInd = simpleMeshShape->m_materialIndices;					
				if( matInd.getSize() )
				{						
					materialName.printf( "%d" , matInd[key] );
				}
			}

			hkQuadRealUnion p;
			{
				p.q = input.m_from.getQuad();
			}

			hkStringBuf s; s.printf( "ShapeKey: %i\nMaterialName: %s" , key, materialName.cString() );
			m_env->m_textDisplay->outputText3D( s.cString(), float(p.r[0]), float(p.r[1]+1), float(p.r[2]) );
		}
	}
	else
	{
		HK_DISPLAY_LINE( input.m_from, input.m_to, 0xffffffff);  
	}

	const hkgPad* pad = m_env->m_gamePad;
	hkVector4 delta; delta.setZero4();
	delta(0) += (pad->getButtonState() & HKG_PAD_DPAD_LEFT) ? 2 : 0;
	delta(0) -= (pad->getButtonState() & HKG_PAD_DPAD_RIGHT) ? 2 : 0;
	delta(1) -= (pad->getButtonState() & HKG_PAD_DPAD_UP) ? 2 : 0;
	delta(1) += (pad->getButtonState() & HKG_PAD_DPAD_DOWN) ? 2 : 0;
	m_castPos.addMul4(0.1f, delta);

	return hkDefaultPhysics2012Demo::stepDemo();
}

// This function returns the shapekey which was returned by the older non-hierarchical raycast
hkpShapeKey ImportedMeshMaterialDemo::getLastShapeKeyFromHierarchy( hkpShapeKey* keys )
{
	hkpShapeKey key = HK_INVALID_SHAPE_KEY;
	for( int i = 0; i < hkpShapeRayCastOutput::MAX_HIERARCHY_DEPTH && keys[i] != HK_INVALID_SHAPE_KEY; ++i )
	{
		key = keys[i];
	}
	return key;
}



static const char helpString[] = \
"This demo shows how to extract named mesh materials from imported meshes.\n"
"\n"
"Move the ray using the D-pad to select the mesh triangle and it's named material.\n"
"Both meshes (left and right) have been assigned material names in the modeler.\n"
"The mesh on the left has been assigned material names using the triangle selections from the Havok Mesh Channel Toolbox.\n"
"The mesh on the right has been assigned material names using mesh materials.\n";


HK_DECLARE_DEMO( ImportedMeshMaterialDemo, HK_DEMO_TYPE_PHYSICS_2012, "Shows how to import named mesh materials", helpString);

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
