/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#include <Demos/demos.h>

#include <Physics2012/Utilities/Serialize/hkpHavokSnapshot.h>
#include <Physics2012/Utilities/Serialize/hkpPhysicsData.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Physics2012/Collide/Shape/Misc/Bv/hkpBvShape.h>

#include <Physics2012/Collide/Query/CastUtil/hkpWorldRayCastInput.h>
#include <Physics2012/Collide/Query/CastUtil/hkpWorldRayCastOutput.h>

#include <Physics2012/Dynamics/World/BroadPhaseBorder/hkpBroadPhaseBorder.h>

// We need to display the results of the raycast to confirm correctness.
#include <Common/Visualize/hkDebugDisplay.h>

#include <Physics2012/Collide/Query/Collector/RayCollector/hkpClosestRayHitCollector.h>
#include <Demos/Physics2012/UseCase/CustomCollectors/FirstRayHitCollector/FirstRayHitCollector.h>

//#include <Physics2012/Internal/PreProcess/ConvexHull/hkpGeometryUtility.h>

#include <Physics2012/Dynamics/Collide/Filter/Constraint/hkpConstraintCollisionFilter.h>

#include <Physics2012/Utilities/Dynamics/KeyFrame/hkpKeyFrameUtility.h>

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>
#include <Common/Serialize/Resource/hkResource.h>

class hkpRigidBody;
class hkpMoppBvTreeShape;

struct FirstRayHitCollectorDemo : public hkDefaultPhysics2012Demo
{
	HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

	FirstRayHitCollectorDemo(hkDemoEnvironment* env);
	~FirstRayHitCollectorDemo();
	Result stepDemo(); 

	hkpPhysicsData* m_physicsData;
	hkResource* m_loadedData;

	hkpRigidBody* m_hemisphereRb;
	hkpRigidBody* m_boxRb;

	void doRaycast(hkpRigidBody* rb1, hkpRigidBody* rb2);

	int m_counter;
};


FirstRayHitCollectorDemo::FirstRayHitCollectorDemo(hkDemoEnvironment* env)
:	hkDefaultPhysics2012Demo(env)
,	m_physicsData(HK_NULL)
,	m_loadedData(HK_NULL)
,	m_hemisphereRb(HK_NULL)
,	m_boxRb(HK_NULL)
,	m_counter(0)
{
	//
	// Setup the camera.
	//
	{
		hkVector4 from( 7.0f, 3.0f, -10.0f);
		hkVector4 to  ( 0.0f, 0.0f, 0.0f);
		hkVector4 up  ( 0.0f, 1.0f,  0.0f);
		setupDefaultCameras(env, from, to, up);
	}

	//
	// Create the world.
	//
	{
		hkStringBuf filename; // We have a different binary file depending on the compiler and platform
#ifdef HK_REAL_IS_DOUBLE
		filename = HK_ASSET_NAME("Resources/Physics2012/Objects/hemisphere.hkt");
#else
		filename.printf("Resources/Physics2012/Objects/hemisphere_L%d%d%d%d.hkx",
			hkStructureLayout::HostLayoutRules.m_bytesInPointer,
			hkStructureLayout::HostLayoutRules.m_littleEndian? 1 : 0,
			hkStructureLayout::HostLayoutRules.m_reusePaddingOptimization? 1 : 0,
			hkStructureLayout::HostLayoutRules.m_emptyBaseClassOptimization? 1 : 0);
#endif
		hkIstream infile( filename.cString() );
		HK_ASSERT( 0x215d080c, infile.isOk() );
		m_physicsData = hkpHavokSnapshot::load(infile.getStreamReader(), &m_loadedData);
		if ( !m_physicsData )
		{
			return;
		}

		m_boxRb = m_physicsData->findRigidBodyByName("box");
		m_hemisphereRb = m_physicsData->findRigidBodyByName("hemisphere");
		m_hemisphereRb->setMotionType(hkpMotion::MOTION_KEYFRAMED);
		m_hemisphereRb->setMaxLinearVelocity(1000.0f);

		hkpWorldCinfo *info = m_physicsData->getWorldCinfo();
 		info->setupSolverInfo(hkpWorldCinfo::SOLVER_TYPE_4ITERS_MEDIUM);
 		info->m_simulationType = hkpWorldCinfo::SIMULATION_TYPE_CONTINUOUS;

		// Set gravity to zero so body floats.
		info->m_gravity.set(0.0f, 0.0f, 0.0f);	
		info->setBroadPhaseWorldSize( 1000.0f );
		info->m_broadPhaseBorderBehaviour = hkpWorldCinfo::BROADPHASE_BORDER_DO_NOTHING;

		m_world = m_physicsData->createWorld();
		m_world->lock();
		m_world->markForWrite();

		hkpConstraintCollisionFilter* collisionFilter = new hkpConstraintCollisionFilter();
		m_world->setCollisionFilter(collisionFilter);
		collisionFilter->removeReference();
		
		// for drawing purposes
		hkpBroadPhaseBorder* border = new hkpBroadPhaseBorder( m_world, hkpWorldCinfo::BROADPHASE_BORDER_DO_NOTHING );
		m_world->setBroadPhaseBorder(border);
		border->removeReference();

		setupGraphics();

		m_world->unmarkForWrite();
		m_world->unlock();
	}

}

FirstRayHitCollectorDemo::~FirstRayHitCollectorDemo()
{
	if ( m_world )
	{
		m_world->markForWrite();
		m_world->removeReference();
		m_world = HK_NULL;
	}

	if ( m_physicsData )
	{
		m_physicsData->removeReference();
		m_physicsData = HK_NULL;
	}
	
	if ( m_loadedData )
	{
		m_loadedData->removeReference();
		m_loadedData = HK_NULL;
	}
}


hkDemo::Result FirstRayHitCollectorDemo::stepDemo()
{
	if ( m_world )
	{
		m_world->lock();
		m_world->markForRead();

		{
			hkpWorldRayCastInput input;
			input.m_from = hkVector4(2, -2, -2);
			input.m_to = hkVector4(-2, 2, 2);

			hkpFirstRayHitCollector output;
			m_world->castRay(input, output );

			hkColor::Argb color = output.hasHit() ? hkColor::LIME : hkColor::RED;

			hkVector4 difference;
			difference.setSub4(input.m_to, input.m_from);
			if (output.hasHit())
			{
				difference.mul4(output.getHit().m_hitFraction);
			}

			HK_DISPLAY_ARROW(input.m_from, difference, color);
		}

		{
			hkpWorldRayCastInput input;
			input.m_from = hkVector4(-2, -2, -2);
			input.m_to = hkVector4(2, 2, 2);

			hkpClosestRayHitCollector output;
			m_world->castRay(input, output );

			hkColor::Argb color = output.hasHit() ? hkColor::YELLOW : hkColor::RED;

			hkVector4 difference;
			difference.setSub4(input.m_to, input.m_from);
			if (output.hasHit())
			{
				difference.mul4(output.getHit().m_hitFraction);
			}

			HK_DISPLAY_ARROW(input.m_from, difference, color);
		}

		m_world->unmarkForRead();

		m_world->markForWrite();
		{
			// Move the hemisphere back and forth around the cube
			hkReal z = 1.6f + 3.0f * hkMath::cos(m_counter++ / 60.0f);
			hkpKeyFrameUtility::applyHardKeyFrame(hkVector4(0,0,z), m_hemisphereRb->getRotation(), 1.0f / m_timestep, m_hemisphereRb);
		}
		m_world->unmarkForWrite();
		m_world->unlock();
	}

	return hkDefaultPhysics2012Demo::stepDemo();
}


HK_DECLARE_DEMO(FirstRayHitCollectorDemo, HK_DEMO_TYPE_PHYSICS_2012, "Shows difference between 'first' and 'closest' ray hit.", "Yellow arrow = hkpClosestRayHitCollector\nGreen arrow = FirstRayHitCollector\nFirst hit is not always the closest as broadphase sorting isn't enough to give a perfect result in all situations.");

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
