/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_CREATURES_DEMO_H
#define HK_CREATURES_DEMO_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>
#include "Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h"

extern const class hkClass CreaturesDemoOptionsClass;

class hkpRigidBody;
class hkpHingeConstraintData;
class hkpLimitedHingeConstraintData;
class hkpConstraintInstance;

class CreaturesDemo : public hkDefaultPhysics2012Demo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		CreaturesDemo(hkDemoEnvironment* env);
		~CreaturesDemo();

		Result stepDemo();

		enum
		{
			LAYER_GROUND = 1,
			LAYER_PHANTOM,
			// This must be last, up to LAYER_SNAKE + NUM_SNAKES are created
			LAYER_SNAKE,
		};

		struct Leg
		{
			HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,CreaturesDemo::Leg);
			hkReal m_lenA;
			hkReal m_lenB;
			class hkpConstraintChainInstance* m_constraint;
		};

		struct LeggedCreatureLayout
		{
			hkVector4 m_bodyHalfExtents;
			hkVector4 m_legHalfExtents;
			int m_numLegs;
			int m_filterInfo;
		};

		struct LeggedCreatureData
		{
			HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,CreaturesDemo::LeggedCreatureData);
			LeggedCreatureLayout m_layout;
			hkArray<Leg> m_legs;
			hkReal m_velocity;
			hkReal m_leftFactor;
			hkReal m_rightFactor;
			hkReal m_time;
			int m_creatureType;
			hkpRigidBody* m_center;
		};

		hkArray<LeggedCreatureData> m_leggedCreatureData;
		

		struct LeglessCreatureData
		{
			HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,CreaturesDemo::LeglessCreatureData);
			hkArray< hkpLimitedHingeConstraintData* > m_muscles;
			hkArray< hkpHingeConstraintData* > m_wheels;
			hkReal m_waveFront;
			hkReal m_segmentLength;
			hkReal m_steering;
			hkReal m_waveLength; //+default(4), +absmin(1), +absmax(10)
			hkReal m_wavePeriod; //+default(1.5), +absmin(.25), +absmax(3)
			hkReal m_waveAmplitude; //+default(1), +absmin(.25), +absmax(3)

			int m_creatureType;
		};

		hkArray<LeglessCreatureData> m_snakeData;

		enum CreatureType
		{
			SPIDER = 0,
			CENTIPEDE, 
			SNAKE,
			NUM_CREATURE_TYPES
		};
		
	protected:
		void createLeggedCreature( hkpWorld* world, LeggedCreatureData& insectData, const hkVector4* requestCenter );
		void moveLeg( LeggedCreatureData& insectData, CreaturesDemo::Leg& leg, hkReal z, hkReal xf, hkReal time, hkReal vel );
		void moveLeggedCreature( LeggedCreatureData& insectData);

		struct calcLegMatrizesIn
		{
			hkVector4 m_from;
			hkVector4 m_to;
			hkVector4 m_up;
			hkReal    m_lenA;
			hkReal    m_lenB;
		};
		static void HK_CALL doLegIk( const calcLegMatrizesIn& in, hkVector4& pivotOut, hkRotation& mAOut, hkRotation& mBOut );
		static void HK_CALL buildLeg( hkpWorld* world, hkpRigidBody* rootBody, const calcLegMatrizesIn& in, int filterInfo, Leg& legOut );

		void createSnake(int index, hkVector4* createPosition, bool isBigSnake);
		// create a snake body segment with a wheel on the bottom.
		// the wheel provides asymetric friction, which is essential for this type of snake locomotion
		hkpRigidBody* createSegment( hkVector4& segmentPosition, hkVector4& segmentHalfSize, int index );

		// link together two segments of a snake with a powered hinge and add the motor
		void linkSegment( hkpRigidBody* front, hkpRigidBody* back, hkVector4& position, hkVector4& axis, LeglessCreatureData& snakeData );

		// simple snake locomotion technique.  
		void slither( hkReal dt, LeglessCreatureData& snakeData );

		void handleKeyPresses();

		void createWall(hkVector4& size, hkVector4& position);
	private:
		class hkLoader* m_loader;
		hkPseudoRandomGenerator m_rand;
		hkpShape* m_snakeBox;
		hkpShape* m_snakeSphere;
		hkUint64 m_step;
		hkBool m_cameraFollowingSteered;
};

#endif	// HK_CREATURES_DEMO_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
