/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

/// This demo illustrates constructing compound bodies from several (convex) pieces,
/// as well as how to shift the center of mass of objects.
/// We create a crowd of wibblies, and drop them on a base box, where they wibble away to their 
/// hearts' content.

#ifndef HK_COMPOUNDBODIES_H
#define HK_COMPOUNDBODIES_H

#include <Demos/DemoCommon/DemoFramework/hkDefaultPhysics2012Demo.h>

class hkPseudoRandomGenerator;


class CompoundBodiesDemo : public hkDefaultPhysics2012Demo
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);
		
		CompoundBodiesDemo(hkDemoEnvironment* env);

	private:

		hkpRigidBody* createWibbly(hkVector4& position, hkPseudoRandomGenerator* generator);
};
#endif // HK_COMPOUNDBODIES_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
